/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.routing;

import org.forgerock.http.Filter;
import org.forgerock.http.Handler;
import org.forgerock.http.header.AcceptApiVersionHeader;
import org.forgerock.http.header.ContentApiVersionHeader;
import org.forgerock.http.header.WarningHeader;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Status;
import org.forgerock.http.routing.ApiVersionRouterContext;
import org.forgerock.http.routing.ResourceApiVersionBehaviourManager;
import org.forgerock.http.routing.Version;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

public class ResourceApiVersionRoutingFilter
implements Filter {
    private final ResourceApiVersionBehaviourManager behaviourManager;

    public ResourceApiVersionRoutingFilter(ResourceApiVersionBehaviourManager behaviourManager) {
        this.behaviourManager = behaviourManager;
    }

    @Override
    public Promise<Response, NeverThrowsException> filter(Context context, Request request, Handler next) {
        Version requestedResourceVersion;
        ApiVersionRouterContext apiVersionRouterContext = this.createApiVersionRouterContext(context);
        try {
            requestedResourceVersion = AcceptApiVersionHeader.valueOf(request).getResourceVersion();
        }
        catch (IllegalArgumentException e) {
            Response response2 = new Response(Status.BAD_REQUEST);
            response2.getHeaders().put("Content-Type", (Object)"text/plain");
            response2.setEntity(e.getMessage()).setCause(e);
            return Promises.newResultPromise(response2);
        }
        return next.handle(apiVersionRouterContext, request).thenOnResult(response -> {
            Version protocolVersion = apiVersionRouterContext.getProtocolVersion();
            Version resourceVersion = apiVersionRouterContext.getResourceVersion();
            if (resourceVersion != null) {
                response.getHeaders().add(new ContentApiVersionHeader(protocolVersion, resourceVersion));
            }
            if (apiVersionRouterContext.isWarningEnabled() && requestedResourceVersion == null) {
                response.getHeaders().add(WarningHeader.newWarning("chf", "%s should be included in the request.", "Accept-API-Version"));
            }
        });
    }

    protected ApiVersionRouterContext createApiVersionRouterContext(Context context) {
        return new ApiVersionRouterContext(context, this.behaviourManager.getDefaultVersionBehaviour(), this.behaviourManager.isWarningEnabled());
    }
}

