/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.oauth2.resolver;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.forgerock.http.oauth2.AccessTokenException;
import org.forgerock.http.oauth2.AccessTokenInfo;
import org.forgerock.http.oauth2.AccessTokenResolver;
import org.forgerock.services.context.Context;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.PerItemEvictionStrategyCache;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.time.Duration;
import org.forgerock.util.time.TimeService;

public class CachingAccessTokenResolver
implements AccessTokenResolver {
    private final AccessTokenResolver resolver;
    private final PerItemEvictionStrategyCache<String, Promise<AccessTokenInfo, AccessTokenException>> cache;
    private final AsyncFunction<Promise<AccessTokenInfo, AccessTokenException>, Duration, Exception> expires;

    public CachingAccessTokenResolver(TimeService time, AccessTokenResolver resolver, PerItemEvictionStrategyCache<String, Promise<AccessTokenInfo, AccessTokenException>> cache) {
        this.resolver = resolver;
        this.cache = cache;
        this.expires = new AccessTokenExpirationFunction(time);
    }

    @Override
    public Promise<AccessTokenInfo, AccessTokenException> resolve(Context context, String token) {
        try {
            return this.cache.getValue(token, this.resolveToken(context, token), this.expires);
        }
        catch (InterruptedException e) {
            return Promises.newExceptionPromise(new AccessTokenException("Timed out retrieving OAuth2 access token information", e));
        }
        catch (ExecutionException e) {
            return Promises.newExceptionPromise(new AccessTokenException("Initial token resolution has failed", e));
        }
    }

    private Callable<Promise<AccessTokenInfo, AccessTokenException>> resolveToken(Context context, String token) {
        return () -> this.resolver.resolve(context, token);
    }

    private static class AccessTokenExpirationFunction
    implements AsyncFunction<Promise<AccessTokenInfo, AccessTokenException>, Duration, Exception> {
        private static final Function<AccessTokenException, Duration, AccessTokenException> TIMEOUT_ZERO = e -> Duration.ZERO;
        private final Function<AccessTokenInfo, Duration, AccessTokenException> computeTtl = accessToken -> {
            if (accessToken.getExpiresAt() == Long.MAX_VALUE) {
                return Duration.UNLIMITED;
            }
            long expires = accessToken.getExpiresAt() - time.now();
            if (expires <= 0L) {
                return Duration.ZERO;
            }
            return Duration.duration(expires, TimeUnit.MILLISECONDS);
        };

        public AccessTokenExpirationFunction(TimeService time) {
        }

        @Override
        public Promise<? extends Duration, ? extends Exception> apply(Promise<AccessTokenInfo, AccessTokenException> accessTokenPromise) {
            return accessTokenPromise.then(this.computeTtl, TIMEOUT_ZERO);
        }
    }
}

