/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.filter;

import org.forgerock.http.Filter;
import org.forgerock.http.Handler;
import org.forgerock.http.header.TransactionIdHeader;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.services.TransactionId;
import org.forgerock.services.context.Context;
import org.forgerock.services.context.TransactionIdContext;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionIdOutboundFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(TransactionIdOutboundFilter.class);

    @Override
    public Promise<Response, NeverThrowsException> filter(Context context, Request request, Handler next) {
        if (context.containsContext(TransactionIdContext.class)) {
            TransactionIdContext txContext = context.asContext(TransactionIdContext.class);
            TransactionId subTxId = txContext.getTransactionId().createSubTransactionId();
            request.getHeaders().put(new TransactionIdHeader(subTxId));
        } else {
            logger.trace("Expecting to find an instance of TransactionIdContext in the chain, but there was none.");
        }
        return next.handle(context, request);
    }
}

