/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.apache.async;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.forgerock.http.apache.AbstractHttpClient;
import org.forgerock.http.apache.async.CloseableBufferFactory;
import org.forgerock.http.io.Buffer;
import org.forgerock.http.io.PipeBufferedStream;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Status;
import org.forgerock.util.Factory;
import org.forgerock.util.Utils;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class AsyncHttpClient
extends AbstractHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(AsyncHttpClient.class);
    private final CloseableHttpAsyncClient client;
    private final Factory<Buffer> storage;
    private final CloseableBufferFactory<ByteBuffer> bufferFactory;

    AsyncHttpClient(CloseableHttpAsyncClient client, Factory<Buffer> storage, int threadCount) {
        this.client = client;
        this.storage = storage;
        this.bufferFactory = CloseableBufferFactory.closeableByteBufferFactory(threadCount, 8192);
    }

    @Override
    public Promise<Response, NeverThrowsException> sendAsync(Request request) {
        HttpUriRequest clientRequest = this.createHttpUriRequest(request);
        PromiseImpl<Response, NeverThrowsException> promise = PromiseImpl.create();
        HttpAsyncResponseConsumer<HttpResponse> httpAsyncResponseConsumer = new PromiseHttpAsyncResponseConsumer(promise, request.getUri().asURI().toASCIIString(), this.storage, this.bufferFactory);
        Map<String, String> mdc = MDC.getCopyOfContextMap();
        if (mdc != null) {
            httpAsyncResponseConsumer = new MdcAwareHttpAsyncResponseConsumer(httpAsyncResponseConsumer, mdc);
        }
        this.client.execute(HttpAsyncMethods.create(clientRequest), httpAsyncResponseConsumer, null);
        return promise;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    private static final class MdcAwareHttpAsyncResponseConsumer
    implements HttpAsyncResponseConsumer<HttpResponse> {
        private final HttpAsyncResponseConsumer<HttpResponse> delegate;
        private final Map<String, String> mdc;

        MdcAwareHttpAsyncResponseConsumer(HttpAsyncResponseConsumer<HttpResponse> delegate, Map<String, String> mdc) {
            this.delegate = delegate;
            this.mdc = mdc;
        }

        @Override
        public void responseReceived(HttpResponse response) throws IOException, HttpException {
            Map<String, String> previous = MDC.getCopyOfContextMap();
            try {
                MDC.setContextMap(this.mdc);
                this.delegate.responseReceived(response);
            }
            finally {
                this.restoreMdc(previous);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void consumeContent(ContentDecoder decoder, IOControl ioctrl) throws IOException {
            Map<String, String> previous = MDC.getCopyOfContextMap();
            try {
                MDC.setContextMap(this.mdc);
                this.delegate.consumeContent(decoder, ioctrl);
            }
            finally {
                this.restoreMdc(previous);
            }
        }

        @Override
        public void responseCompleted(HttpContext context) {
            Map<String, String> previous = MDC.getCopyOfContextMap();
            try {
                MDC.setContextMap(this.mdc);
                this.delegate.responseCompleted(context);
            }
            finally {
                this.restoreMdc(previous);
            }
        }

        @Override
        public void failed(Exception ex) {
            Map<String, String> previous = MDC.getCopyOfContextMap();
            try {
                MDC.setContextMap(this.mdc);
                this.delegate.failed(ex);
            }
            finally {
                this.restoreMdc(previous);
            }
        }

        @Override
        public Exception getException() {
            return this.delegate.getException();
        }

        @Override
        public HttpResponse getResult() {
            return this.delegate.getResult();
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }

        @Override
        public void close() throws IOException {
            Map<String, String> previous = MDC.getCopyOfContextMap();
            try {
                MDC.setContextMap(this.mdc);
                this.delegate.close();
            }
            finally {
                this.restoreMdc(previous);
            }
        }

        @Override
        public boolean cancel() {
            Map<String, String> previous = MDC.getCopyOfContextMap();
            try {
                MDC.setContextMap(this.mdc);
                boolean bl = this.delegate.cancel();
                return bl;
            }
            finally {
                this.restoreMdc(previous);
            }
        }

        private void restoreMdc(Map<String, String> previous) {
            if (previous != null) {
                MDC.setContextMap(previous);
            } else {
                MDC.clear();
            }
        }
    }

    static final class PromiseHttpAsyncResponseConsumer
    implements HttpAsyncResponseConsumer<HttpResponse> {
        private final PromiseImpl<Response, NeverThrowsException> promise;
        private final Factory<Buffer> storage;
        private final String uri;
        private final CloseableBufferFactory<ByteBuffer> bufferFactory;
        private Response response;
        private WritableByteChannel channel;
        private HttpResponse result;
        private Exception exception;

        PromiseHttpAsyncResponseConsumer(PromiseImpl<Response, NeverThrowsException> promise, String uri, Factory<Buffer> storage, CloseableBufferFactory<ByteBuffer> bufferFactory) {
            this.promise = promise;
            this.storage = storage;
            this.uri = uri;
            this.bufferFactory = bufferFactory;
        }

        @Override
        public void responseReceived(HttpResponse httpResponse) throws IOException, HttpException {
            this.result = httpResponse;
            this.response = AsyncHttpClient.createResponseWithoutEntity(httpResponse);
            HttpEntity entity = httpResponse.getEntity();
            if (entity != null) {
                PipeBufferedStream pipe = new PipeBufferedStream(this.storage);
                this.channel = Channels.newChannel(pipe.getIn());
                this.response.getEntity().setRawContentInputStream(pipe.getOut());
            }
        }

        @Override
        public void consumeContent(ContentDecoder contentDecoder, IOControl ioControl) throws IOException {
            try (CloseableBufferFactory.CloseableBuffer buffer = this.bufferFactory.newInstance();){
                ByteBuffer byteBuffer = (ByteBuffer)buffer.getBuffer();
                while (contentDecoder.read(byteBuffer) > 0) {
                    byteBuffer.flip();
                    this.channel.write(byteBuffer);
                    byteBuffer.clear();
                }
            }
            if (contentDecoder.isCompleted()) {
                this.channel.close();
            }
        }

        @Override
        public void responseCompleted(HttpContext httpContext) {
            this.promise.handleResult(this.response);
        }

        @Override
        public void failed(Exception e) {
            Utils.closeSilently(this.response, this.channel);
            this.exception = e;
            logger.trace("Failed to obtain response for {}", (Object)this.uri, (Object)e);
            this.promise.handleResult(new Response(Status.BAD_GATEWAY).setCause(e));
        }

        @Override
        public Exception getException() {
            return this.exception;
        }

        @Override
        public HttpResponse getResult() {
            return this.result;
        }

        @Override
        public boolean isDone() {
            return this.promise.isDone();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public boolean cancel() {
            return false;
        }
    }
}

