/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.models;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.forgerock.api.models.ApiError;
import org.forgerock.api.util.ValidationUtil;
import org.forgerock.util.Reject;

@JsonDeserialize(builder=Builder.class)
public final class Errors {
    public static final ErrorEntryComparator ERROR_ENTRY_COMPARATOR = new ErrorEntryComparator();
    private final Map<String, ApiError> errors;

    private Errors(Builder builder) {
        this.errors = builder.errors;
    }

    @JsonValue
    public Map<String, ApiError> getErrors() {
        return this.errors;
    }

    @JsonIgnore
    public ApiError get(String name) {
        return this.errors.get(name);
    }

    @JsonIgnore
    public Set<String> getNames() {
        return this.errors.keySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Errors errors1 = (Errors)o;
        return Objects.equals(this.errors, errors1.errors);
    }

    public int hashCode() {
        return Objects.hash(this.errors);
    }

    public static Builder errors() {
        return new Builder();
    }

    private static class ErrorEntryComparator
    implements Comparator<Map.Entry<String, ApiError>> {
        private ErrorEntryComparator() {
        }

        @Override
        public int compare(Map.Entry<String, ApiError> o1, Map.Entry<String, ApiError> o2) {
            int codeCompare = Integer.compare(o1.getValue().getCode(), o2.getValue().getCode());
            if (codeCompare == 0) {
                return o1.getValue().getDescription().toString().compareTo(o2.getValue().getDescription().toString());
            }
            return codeCompare;
        }
    }

    public static final class Builder {
        private final Map<String, ApiError> errors = new HashMap<String, ApiError>();

        private Builder() {
        }

        @JsonAnySetter
        public Builder put(String name, ApiError apiError) {
            if (ValidationUtil.isEmpty(name) || ValidationUtil.containsWhitespace(name)) {
                throw new IllegalArgumentException("ApiError name is required and may not contain whitespace");
            }
            if (this.errors.containsKey(name) && !this.errors.get(name).equals(apiError)) {
                throw new IllegalStateException("The give ApiError name already exists but the ApiError objects are not equal");
            }
            this.errors.put(name, Reject.checkNotNull(apiError));
            return this;
        }

        public Errors build() {
            return new Errors(this);
        }
    }
}

