/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.forgerock.api.ApiValidationException;
import org.forgerock.api.enums.CreateMode;
import org.forgerock.api.models.ApiDescription;
import org.forgerock.api.models.Operation;
import org.forgerock.api.models.Resource;

@JsonDeserialize(builder=Builder.class)
public final class Create
extends Operation {
    private final CreateMode mode;
    private final Boolean singleton;

    private Create(Builder builder) {
        super(builder);
        this.mode = builder.mode;
        this.singleton = builder.singleton;
        if (this.mode == null) {
            throw new ApiValidationException("mode required");
        }
    }

    public CreateMode getMode() {
        return this.mode;
    }

    public Boolean isSingleton() {
        return this.singleton;
    }

    public static final Builder create() {
        return new Builder();
    }

    @Override
    protected void allocateToResource(Resource.Builder resourceBuilder) {
        resourceBuilder.create(this);
    }

    public static Create fromAnnotation(org.forgerock.api.annotations.Create create, boolean instanceOperations, ApiDescription descriptor, Class<?> relativeType) {
        List<CreateMode> modes = Arrays.asList(create.modes());
        if (instanceOperations && !modes.contains((Object)CreateMode.ID_FROM_CLIENT) || !instanceOperations && !modes.contains((Object)CreateMode.ID_FROM_SERVER)) {
            return null;
        }
        return ((Builder)Create.create().detailsFromAnnotation(create.operationDescription(), descriptor, relativeType)).mode(instanceOperations ? CreateMode.ID_FROM_CLIENT : CreateMode.ID_FROM_SERVER).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Create create = (Create)o;
        return this.mode == create.mode && Objects.equals(this.singleton, create.singleton);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.mode, this.singleton});
    }

    public static final class Builder
    extends Operation.Builder<Builder> {
        private CreateMode mode;
        private Boolean singleton = false;

        private Builder() {
        }

        @JsonProperty(value="mode")
        public Builder mode(CreateMode mode) {
            this.mode = mode;
            return this;
        }

        @JsonProperty(value="singleton")
        public Builder singleton(Boolean singleton) {
            this.singleton = singleton;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Create build() {
            return new Create(this);
        }
    }
}

