/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.models;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.forgerock.api.ApiValidationException;
import org.forgerock.api.models.ApiError;
import org.forgerock.api.models.Definitions;
import org.forgerock.api.models.Errors;
import org.forgerock.api.models.Paths;
import org.forgerock.api.models.Resource;
import org.forgerock.api.models.Schema;
import org.forgerock.api.models.Services;
import org.forgerock.api.util.ValidationUtil;
import org.forgerock.util.i18n.LocalizableString;

@JsonDeserialize(builder=Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class ApiDescription {
    private final String id;
    private final String version;
    private final LocalizableString description;
    private final Definitions definitions;
    private final Services services;
    private final Errors errors;
    private final Paths paths;

    private ApiDescription(Builder builder) {
        this.id = builder.id;
        this.version = builder.version;
        this.description = builder.description;
        this.definitions = builder.definitions == null ? Definitions.definitions().build() : builder.definitions;
        this.services = builder.services == null ? Services.services().build() : builder.services;
        this.errors = builder.errors == null ? Errors.errors().build() : builder.errors;
        Paths paths = this.paths = builder.paths == null ? Paths.paths().build() : builder.paths;
        if (ValidationUtil.isEmpty(this.id) || ValidationUtil.isEmpty(this.version)) {
            throw new ApiValidationException("id and version required");
        }
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public LocalizableString getDescription() {
        return this.description;
    }

    public Definitions getDefinitions() {
        return this.definitions.getDefinitions().isEmpty() ? null : this.definitions;
    }

    void addDefinition(String id, Schema schema) {
        if (schema.getReference() != null) {
            throw new IllegalArgumentException("Cannot define a schema using a reference");
        }
        Schema defined = this.definitions.get(id);
        if (defined != null && !defined.equals(schema)) {
            throw new IllegalArgumentException("Trying to redefine already defined schema, " + id);
        }
        this.definitions.getDefinitions().put(id, schema);
    }

    public Services getServices() {
        return this.services.getServices().isEmpty() ? null : this.services;
    }

    void addService(String id, Resource resource) {
        if (resource.getReference() != null) {
            throw new IllegalArgumentException("Cannot define a resource using a reference");
        }
        Resource defined = this.services.get(id);
        if (defined != null && !defined.equals(resource)) {
            throw new IllegalArgumentException("Trying to redefine already defined resource, " + id);
        }
        this.services.getServices().put(id, resource);
    }

    public Errors getErrors() {
        return this.errors.getErrors().isEmpty() ? null : this.errors;
    }

    void addError(String id, ApiError apiError) {
        if (apiError.getReference() != null) {
            throw new IllegalArgumentException("Cannot define an apiError using a reference");
        }
        ApiError defined = this.errors.get(id);
        if (defined != null && !defined.equals(apiError)) {
            throw new IllegalArgumentException("Trying to redefine already defined apiError, " + id);
        }
        this.errors.getErrors().put(id, apiError);
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Paths getPaths() {
        return this.paths;
    }

    public static Builder apiDescription() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiDescription that = (ApiDescription)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.version, that.version) && Objects.equals(this.description, that.description) && Objects.equals(this.definitions, that.definitions) && Objects.equals(this.services, that.services) && Objects.equals(this.errors, that.errors) && Objects.equals(this.paths, that.paths);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.description, this.definitions, this.services, this.errors, this.paths);
    }

    public static final class Builder {
        private String id;
        private LocalizableString description;
        private Definitions definitions;
        private Errors errors;
        private Services services;
        private Paths paths;
        private String version;

        private Builder() {
        }

        @JsonProperty(value="id")
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="description")
        public Builder description(String description) {
            this.description = new LocalizableString(description);
            return this;
        }

        public Builder description(LocalizableString description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="definitions")
        public Builder definitions(Definitions definitions) {
            this.definitions = definitions;
            return this;
        }

        @JsonProperty(value="services")
        public Builder services(Services services) {
            this.services = services;
            return this;
        }

        @JsonProperty(value="errors")
        public Builder errors(Errors errors) {
            this.errors = errors;
            return this;
        }

        @JsonProperty(value="paths")
        public Builder paths(Paths paths) {
            this.paths = paths;
            return this;
        }

        @JsonProperty(value="version")
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public ApiDescription build() {
            return new ApiDescription(this);
        }
    }
}

