/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableRefCount<T>
extends AbstractFlowableWithUpstream<T, T> {
    final ConnectableFlowable<? extends T> source;
    volatile CompositeDisposable baseDisposable = new CompositeDisposable();
    final AtomicInteger subscriptionCount = new AtomicInteger();
    final ReentrantLock lock = new ReentrantLock();

    public FlowableRefCount(ConnectableFlowable<T> source) {
        super(source);
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribeActual(Subscriber<? super T> subscriber) {
        this.lock.lock();
        if (this.subscriptionCount.incrementAndGet() == 1) {
            AtomicBoolean writeLocked = new AtomicBoolean(true);
            try {
                this.source.connect(this.onSubscribe(subscriber, writeLocked));
            }
            finally {
                if (writeLocked.get()) {
                    this.lock.unlock();
                }
            }
        }
        try {
            this.doSubscribe(subscriber, this.baseDisposable);
        }
        finally {
            this.lock.unlock();
        }
    }

    private Consumer<Disposable> onSubscribe(final Subscriber<? super T> subscriber, final AtomicBoolean writeLocked) {
        return new Consumer<Disposable>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(Disposable subscription) {
                try {
                    FlowableRefCount.this.baseDisposable.add(subscription);
                    FlowableRefCount.this.doSubscribe(subscriber, FlowableRefCount.this.baseDisposable);
                }
                finally {
                    FlowableRefCount.this.lock.unlock();
                    writeLocked.set(false);
                }
            }
        };
    }

    void doSubscribe(Subscriber<? super T> subscriber, CompositeDisposable currentBase) {
        Disposable d = this.disconnect(currentBase);
        ConnectionSubscriber connection = new ConnectionSubscriber(subscriber, currentBase, d);
        subscriber.onSubscribe(connection);
        this.source.subscribe(connection);
    }

    private Disposable disconnect(final CompositeDisposable current) {
        return Disposables.fromRunnable(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FlowableRefCount.this.lock.lock();
                try {
                    if (FlowableRefCount.this.baseDisposable == current && FlowableRefCount.this.subscriptionCount.decrementAndGet() == 0) {
                        FlowableRefCount.this.baseDisposable.dispose();
                        FlowableRefCount.this.baseDisposable = new CompositeDisposable();
                    }
                }
                finally {
                    FlowableRefCount.this.lock.unlock();
                }
            }
        });
    }

    final class ConnectionSubscriber
    extends AtomicReference<Subscription>
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = 152064694420235350L;
        final Subscriber<? super T> subscriber;
        final CompositeDisposable currentBase;
        final Disposable resource;
        final AtomicLong requested;

        ConnectionSubscriber(Subscriber<? super T> subscriber, CompositeDisposable currentBase, Disposable resource) {
            this.subscriber = subscriber;
            this.currentBase = currentBase;
            this.resource = resource;
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(Subscription s) {
            SubscriptionHelper.deferredSetOnce(this, this.requested, s);
        }

        @Override
        public void onError(Throwable e) {
            this.cleanup();
            this.subscriber.onError(e);
        }

        @Override
        public void onNext(T t) {
            this.subscriber.onNext(t);
        }

        @Override
        public void onComplete() {
            this.cleanup();
            this.subscriber.onComplete();
        }

        @Override
        public void request(long n) {
            SubscriptionHelper.deferredRequest(this, this.requested, n);
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this);
            this.resource.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanup() {
            FlowableRefCount.this.lock.lock();
            try {
                if (FlowableRefCount.this.baseDisposable == this.currentBase) {
                    FlowableRefCount.this.baseDisposable.dispose();
                    FlowableRefCount.this.baseDisposable = new CompositeDisposable();
                    FlowableRefCount.this.subscriptionCount.set(0);
                }
            }
            finally {
                FlowableRefCount.this.lock.unlock();
            }
        }
    }
}

