/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.extensions;

import com.forgerock.opendj.ldap.extensions.PasswordPolicyStateExtendedRequest;
import com.forgerock.opendj.ldap.extensions.PasswordPolicyStateOperation;
import com.forgerock.opendj.ldap.extensions.PasswordPolicyStateOperationContainer;
import java.util.ArrayList;
import java.util.List;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.messages.AbstractExtendedResult;

public final class PasswordPolicyStateExtendedResult
extends AbstractExtendedResult<PasswordPolicyStateExtendedResult>
implements PasswordPolicyStateOperationContainer {
    private String targetUser = "";
    private final List<PasswordPolicyStateOperation> operations = new ArrayList<PasswordPolicyStateOperation>();

    public PasswordPolicyStateExtendedResult(ResultCode resultCode) {
        super(resultCode);
    }

    @Override
    public void addOperation(PasswordPolicyStateOperation operation) {
        this.operations.add(operation);
    }

    @Override
    public String getOid() {
        return "1.3.6.1.4.1.26027.1.6.1";
    }

    @Override
    public Iterable<PasswordPolicyStateOperation> getOperations() {
        return this.operations;
    }

    @Override
    public String getTargetUser() {
        return this.targetUser;
    }

    @Override
    public ByteString getValue() {
        return PasswordPolicyStateExtendedRequest.encode(this.targetUser, this.operations);
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void setTargetUser(String targetUser) {
        this.targetUser = targetUser != null ? targetUser : "";
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PasswordPolicyStateExtendedResponse(resultCode=");
        builder.append(this.getResultCode());
        builder.append(", matchedDN=");
        builder.append(this.getMatchedDn());
        builder.append(", diagnosticMessage=");
        builder.append(this.getDiagnosticMessage());
        builder.append(", referrals=");
        builder.append(this.getReferralUris());
        builder.append(", responseName=");
        builder.append(this.getOid());
        builder.append(", targetUser=");
        builder.append(this.targetUser);
        builder.append(", operations=");
        builder.append(this.operations);
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }
}

