/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.extensions;

import com.forgerock.opendj.ldap.CoreMessages;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.io.Asn1;
import org.forgerock.opendj.io.Asn1Reader;
import org.forgerock.opendj.io.Asn1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.messages.AbstractExtendedRequest;
import org.forgerock.opendj.ldap.messages.AbstractExtendedResultDecoder;
import org.forgerock.opendj.ldap.messages.ExtendedRequest;
import org.forgerock.opendj.ldap.messages.ExtendedRequestDecoder;
import org.forgerock.opendj.ldap.messages.ExtendedResult;
import org.forgerock.opendj.ldap.messages.ExtendedResultDecoder;
import org.forgerock.opendj.ldap.messages.Responses;

public final class GetSymmetricKeyExtendedRequest
extends AbstractExtendedRequest<GetSymmetricKeyExtendedRequest, ExtendedResult> {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    public static final String OID = "1.3.6.1.4.1.26027.1.6.3";
    private static final byte TYPE_SYMMETRIC_KEY_ELEMENT = -128;
    private static final byte TYPE_INSTANCE_KEY_ID_ELEMENT = -127;
    public static final RequestDecoder REQUEST_DECODER = new RequestDecoder();
    private static final ResultDecoder RESULT_DECODER = new ResultDecoder();
    private String requestSymmetricKey;
    private String instanceKeyId;

    public static GetSymmetricKeyExtendedRequest newRequest() {
        return new GetSymmetricKeyExtendedRequest();
    }

    private GetSymmetricKeyExtendedRequest() {
    }

    public String getInstanceKeyId() {
        return this.instanceKeyId;
    }

    @Override
    public String getOid() {
        return OID;
    }

    public String getRequestSymmetricKey() {
        return this.requestSymmetricKey;
    }

    @Override
    public ExtendedResultDecoder<ExtendedResult> getResultDecoder() {
        return RESULT_DECODER;
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder();
        Asn1Writer writer = Asn1.getWriter(buffer);
        try {
            writer.writeStartSequence();
            if (this.requestSymmetricKey != null) {
                writer.writeOctetString((byte)-128, this.requestSymmetricKey);
            }
            if (this.instanceKeyId != null) {
                writer.writeOctetString((byte)-127, this.instanceKeyId);
            }
            writer.writeEndSequence();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return buffer.toByteString();
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    public GetSymmetricKeyExtendedRequest setInstanceKeyId(String instanceKeyId) {
        this.instanceKeyId = instanceKeyId;
        return this;
    }

    public GetSymmetricKeyExtendedRequest setRequestSymmetricKey(String requestSymmetricKey) {
        this.requestSymmetricKey = requestSymmetricKey;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GetSymmetricKeyExtendedRequest(requestName=");
        builder.append(this.getOid());
        builder.append(", requestSymmetricKey=");
        builder.append(this.requestSymmetricKey);
        builder.append(", instanceKeyId=");
        builder.append(this.instanceKeyId);
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    private static final class ResultDecoder
    extends AbstractExtendedResultDecoder<ExtendedResult> {
        private ResultDecoder() {
        }

        @Override
        public ExtendedResult newExtendedErrorResult(ResultCode resultCode, String matchedDN, CharSequence diagnosticMessage) {
            return Responses.newGenericExtendedResult(resultCode).setMatchedDn(matchedDN).setDiagnosticMessage(diagnosticMessage);
        }

        @Override
        public ExtendedResult decodeExtendedResult(ExtendedResult result, DecodeOptions options) throws DecodeException {
            return result;
        }
    }

    private static final class RequestDecoder
    implements ExtendedRequestDecoder<GetSymmetricKeyExtendedRequest, ExtendedResult> {
        private RequestDecoder() {
        }

        @Override
        public GetSymmetricKeyExtendedRequest decodeExtendedRequest(ExtendedRequest<?> request, DecodeOptions options) throws DecodeException {
            ByteString requestValue = request.getValue();
            if (requestValue == null) {
                LocalizableMessage message = CoreMessages.ERR_GET_SYMMETRIC_KEY_NO_VALUE.get();
                throw DecodeException.error(message);
            }
            String requestSymmetricKey = null;
            String instanceKeyID = null;
            try {
                Asn1Reader reader = Asn1.getReader(requestValue);
                reader.readStartSequence();
                if (reader.hasNextElement() && reader.peekType() == -128) {
                    requestSymmetricKey = reader.readOctetStringAsString();
                }
                if (reader.hasNextElement() && reader.peekType() == -127) {
                    instanceKeyID = reader.readOctetStringAsString();
                }
                reader.readEndSequence();
                GetSymmetricKeyExtendedRequest newRequest = new GetSymmetricKeyExtendedRequest().setRequestSymmetricKey(requestSymmetricKey).setInstanceKeyId(instanceKeyID);
                for (Control control : request.getControls()) {
                    newRequest.addControl(control);
                }
                return newRequest;
            }
            catch (IOException ioe) {
                logger.debug(LocalizableMessage.raw("%s", ioe));
                LocalizableMessage message = CoreMessages.ERR_GET_SYMMETRIC_KEY_ASN1_DECODE_EXCEPTION.get(ioe.getMessage());
                throw DecodeException.error(message, ioe);
            }
        }
    }
}

