/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.ApplicationKeyManager;
import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.ClientException;
import com.forgerock.opendj.cli.CommandBuilder;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.FileBasedArgument;
import com.forgerock.opendj.cli.IntegerArgument;
import com.forgerock.opendj.cli.PromptingTrustManager;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.Utils;
import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import com.sun.security.auth.callback.TextCallbackHandler;
import com.sun.security.auth.module.Krb5LoginModule;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.LdapConnectionFactory;
import org.forgerock.opendj.ldap.SslOptions;
import org.forgerock.opendj.ldap.controls.AuthorizationIdentityRequestControl;
import org.forgerock.opendj.ldap.controls.PasswordPolicyRequestControl;
import org.forgerock.opendj.ldap.messages.BindRequest;
import org.forgerock.opendj.ldap.messages.Requests;
import org.forgerock.opendj.security.KeyManagers;
import org.forgerock.opendj.security.SslContextBuilder;
import org.forgerock.opendj.security.TrustManagers;
import org.forgerock.util.Options;
import org.forgerock.util.Reject;
import org.forgerock.util.time.Duration;

public final class ConnectionFactoryProvider {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private StringArgument hostNameArg;
    private IntegerArgument portArg;
    private StringArgument bindNameArg;
    private FileBasedArgument bindPasswordFileArg;
    private char[] passwordFromInteractivePrompt;
    private StringArgument bindPasswordArg;
    private IntegerArgument connectTimeOut;
    private BooleanArgument trustAllArg;
    private StringArgument trustStorePathArg;
    private StringArgument trustStorePasswordArg;
    private FileBasedArgument trustStorePasswordFileArg;
    private StringArgument keyStorePathArg;
    private StringArgument keyStorePasswordArg;
    private FileBasedArgument keyStorePasswordFileArg;
    private StringArgument certNicknameArg;
    private BooleanArgument useSslArg;
    private BooleanArgument useStartTlsArg;
    private StringArgument saslOptionArg;
    private final BooleanArgument reportAuthzIdArg;
    private final BooleanArgument usePasswordPolicyControlArg;
    private SSLContext sslContext;
    private ConnectionFactory connFactory;
    private BindRequest bindRequest;
    private final ConsoleApplication app;
    private boolean isAdminConnection;
    private final boolean alwaysUseSsl;

    private static String defaultHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            return "Unknown (" + e + ")";
        }
    }

    public ConnectionFactoryProvider(ArgumentParser argumentParser, ConsoleApplication app) {
        this(argumentParser, app, "", 389, false);
    }

    public ConnectionFactoryProvider(ArgumentParser parser, ConsoleApplication app, String defaultBindDN, int defaultPort, boolean alwaysSSL) {
        this.app = app;
        this.hostNameArg = parser.addLdapConnectionArgument(CommonArguments.hostNameArgument(ConnectionFactoryProvider.defaultHostName()));
        this.portArg = parser.addLdapConnectionArgument(CommonArguments.portArgument(defaultPort, alwaysSSL ? CliMessages.INFO_DESCRIPTION_ADMIN_PORT.get() : CliMessages.INFO_DESCRIPTION_PORT.get()));
        this.bindNameArg = parser.addLdapConnectionArgument(CommonArguments.bindDnArgument(defaultBindDN));
        this.bindPasswordArg = parser.addLdapConnectionArgument(CommonArguments.bindPasswordArgument());
        this.bindPasswordFileArg = parser.addLdapConnectionArgument(CommonArguments.bindPasswordFileArgument());
        this.saslOptionArg = parser.addLdapConnectionArgument(CommonArguments.saslArgument());
        this.trustAllArg = parser.addLdapConnectionArgument(CommonArguments.trustAllArgument());
        this.trustStorePathArg = parser.addLdapConnectionArgument(CommonArguments.trustStorePathArgument());
        this.trustStorePasswordArg = parser.addLdapConnectionArgument(CommonArguments.trustStorePasswordArgument(CliMessages.INFO_DESCRIPTION_TRUSTSTOREPASSWORD.get()));
        this.trustStorePasswordFileArg = parser.addLdapConnectionArgument(CommonArguments.trustStorePasswordFileArgument());
        this.keyStorePathArg = parser.addLdapConnectionArgument(CommonArguments.keyStorePathArgument());
        this.keyStorePasswordArg = parser.addLdapConnectionArgument(CommonArguments.keyStorePasswordArgument());
        this.keyStorePasswordFileArg = parser.addLdapConnectionArgument(CommonArguments.keyStorePasswordFileArgument());
        this.certNicknameArg = parser.addLdapConnectionArgument(CommonArguments.certNickNameArgument());
        this.reportAuthzIdArg = parser.addArgument(CommonArguments.reportAuthzIdArgument());
        this.connectTimeOut = parser.addArgument(CommonArguments.connectTimeOutArgument());
        this.usePasswordPolicyControlArg = (BooleanArgument)((BooleanArgument.Builder)BooleanArgument.builder("usePasswordPolicyControl").description(CliMessages.INFO_DESCRIPTION_USE_PWP_CONTROL.get())).buildAndAddToParser(parser);
        this.useSslArg = CommonArguments.useSslArgument();
        this.useStartTlsArg = CommonArguments.startTlsArgument();
        this.alwaysUseSsl = alwaysSSL;
        if (this.alwaysUseSsl) {
            this.useSslArg.setPresent(true);
        } else {
            parser.addLdapConnectionArgument(this.useSslArg);
            parser.addLdapConnectionArgument(this.useStartTlsArg);
        }
    }

    public int getConnectTimeout() {
        if (this.connectTimeOut.isPresent()) {
            try {
                return this.connectTimeOut.getIntValue();
            }
            catch (ArgumentException e) {
                return Integer.valueOf(this.connectTimeOut.getDefaultValue());
            }
        }
        return Integer.valueOf(this.connectTimeOut.getDefaultValue());
    }

    public String getHostname() throws ArgumentException {
        if (this.hostNameArg.isPresent()) {
            return Utils.getHostNameForLdapUrl(this.hostNameArg.getValue());
        }
        if (this.app.isInteractive()) {
            try {
                String value = this.app.readInput(CliMessages.INFO_DESCRIPTION_HOST.get(), this.getHostNameDefaultValue());
                this.app.println();
                this.hostNameArg.addValue(value);
                this.hostNameArg.setPresent(true);
                return Utils.getHostNameForLdapUrl(value);
            }
            catch (ClientException e) {
                throw new ArgumentException(CliMessages.ERR_ERROR_CANNOT_READ_HOST_NAME.get(), (Throwable)e);
            }
        }
        return this.getHostNameDefaultValue();
    }

    private String getHostNameDefaultValue() {
        return this.hostNameArg.getDefaultValue() != null ? this.hostNameArg.getDefaultValue() : "";
    }

    public int getPort() {
        if (this.portArg.isPresent()) {
            try {
                return this.portArg.getIntValue();
            }
            catch (ArgumentException e) {
                return Integer.valueOf(this.portArg.getDefaultValue());
            }
        }
        if (this.app.isInteractive()) {
            LocalizableMessage portMsg = this.isAdminConnection ? CliMessages.INFO_DESCRIPTION_ADMIN_PORT.get() : CliMessages.INFO_DESCRIPTION_PORT.get();
            int value = this.app.askPort(portMsg, Integer.valueOf(this.portArg.getDefaultValue()), logger);
            this.app.println();
            this.portArg.addValue(Integer.toString(value));
            this.portArg.setPresent(true);
            return value;
        }
        return Integer.valueOf(this.portArg.getDefaultValue());
    }

    public static List<String> getDefaultProtocols() throws NoSuchAlgorithmException {
        List<String> enabled = Arrays.asList(SSLContext.getDefault().createSSLEngine().getEnabledProtocols());
        String property = System.getProperty("org.opends.ldaps.protocols");
        ArrayList<String> defaults = new ArrayList<String>();
        if (property != null && property.length() != 0) {
            for (String protocol : property.split(",")) {
                if (!enabled.contains(protocol)) continue;
                defaults.add(protocol);
            }
            return defaults;
        }
        for (String protocol : enabled) {
            if (protocol.startsWith("SSL")) continue;
            defaults.add(protocol);
        }
        return defaults;
    }

    public ConnectionFactory getAuthenticatedConnectionFactory() throws ArgumentException {
        return this.getConnectionFactory(true);
    }

    public ConnectionFactory getUnauthenticatedConnectionFactory() throws ArgumentException {
        return this.getConnectionFactory(false);
    }

    private ConnectionFactory getConnectionFactory(boolean usePreAuthentication) throws ArgumentException {
        if (this.connFactory == null) {
            this.checkForConflictingArguments();
            if (this.app.isInteractive()) {
                boolean bindPwdIsMissing;
                boolean portIsMissing = !this.portArg.isPresent() || this.portArg.getIntValue() == 0;
                boolean bl = bindPwdIsMissing = !this.passwordProvidedInArguments();
                if (!this.hostNameArg.isPresent() || portIsMissing || !this.bindNameArg.isPresent() || bindPwdIsMissing) {
                    this.app.printHeader(CliMessages.INFO_LDAP_CONN_HEADING_CONNECTION_PARAMETERS.get());
                }
                if (!this.hostNameArg.isPresent()) {
                    this.getHostname();
                }
                if (portIsMissing) {
                    this.getPort();
                }
                if (!this.bindNameArg.isPresent()) {
                    this.getBindName();
                }
                if (bindPwdIsMissing) {
                    this.getPassword();
                }
            }
            try {
                if ((this.useSslArg.isPresent() || this.useStartTlsArg.isPresent()) && this.sslContext == null) {
                    this.sslContext = new SslContextBuilder().trustManager(this.getTrustManager()).keyManager(this.getKeyManager()).build();
                }
            }
            catch (Exception e) {
                throw new ArgumentException(CliMessages.ERR_LDAP_CONN_CANNOT_INITIALIZE_SSL.get(e.toString()), (Throwable)e);
            }
            Options options = Options.defaultOptions();
            if (this.sslContext != null) {
                try {
                    options.set(LdapConnectionFactory.SSL_OPTIONS, SslOptions.newSslOptions(this.sslContext).enabledProtocols(ConnectionFactoryProvider.getDefaultProtocols())).set(LdapConnectionFactory.SSL_USE_STARTTLS, this.useStartTlsArg.isPresent());
                }
                catch (NoSuchAlgorithmException e) {
                    throw new ArgumentException(CliMessages.ERR_LDAP_CONN_CANNOT_INITIALIZE_SSL.get(e.toString()), (Throwable)e);
                }
            }
            options.set(LdapConnectionFactory.CONNECT_TIMEOUT, Duration.duration(this.getConnectTimeout(), TimeUnit.MILLISECONDS));
            if (usePreAuthentication) {
                options.set(LdapConnectionFactory.AUTHN_BIND_REQUEST, this.getBindRequest());
            }
            this.connFactory = new LdapConnectionFactory(this.hostNameArg.getValue(), this.portArg.getIntValue(), options);
        }
        return this.connFactory;
    }

    private void checkForConflictingArguments() throws ArgumentException {
        String value;
        Utils.throwIfArgumentsConflict((Argument)this.bindPasswordArg, (Argument)this.bindPasswordFileArg);
        Utils.throwIfArgumentsConflict((Argument)this.trustAllArg, (Argument)this.trustStorePathArg);
        Utils.throwIfArgumentsConflict((Argument)this.trustAllArg, (Argument)this.trustStorePasswordArg);
        Utils.throwIfArgumentsConflict((Argument)this.trustAllArg, (Argument)this.trustStorePasswordFileArg);
        Utils.throwIfArgumentsConflict((Argument)this.trustStorePasswordArg, (Argument)this.trustStorePasswordFileArg);
        Utils.throwIfArgumentsConflict((Argument)this.useStartTlsArg, (Argument)this.useSslArg);
        if (this.trustStorePathArg.isPresent() && !this.canReadPath(value = this.trustStorePathArg.getValue())) {
            LocalizableMessage message = CliMessages.ERR_CANNOT_READ_TRUSTSTORE.get(value);
            throw new ArgumentException(message);
        }
        if (this.keyStorePathArg.isPresent() && !this.canReadPath(value = this.keyStorePathArg.getValue())) {
            LocalizableMessage message = CliMessages.ERR_CANNOT_READ_KEYSTORE.get(value);
            throw new ArgumentException(message);
        }
    }

    private boolean canReadPath(String path) {
        File file = new File(path);
        return file.exists() && file.canRead();
    }

    public String getAuthcId(String saslMechanism) throws ArgumentException {
        String value = this.getAuthcId();
        if (value == null && this.bindNameArg.isPresent()) {
            value = "dn: " + this.bindNameArg.getValue();
        }
        if (value == null && this.app.isInteractive()) {
            try {
                String bindName = this.bindNameArg.getDefaultValue();
                value = this.app.readInput(LocalizableMessage.raw("Authentication ID:", new Object[0]), bindName == null ? null : "dn: " + bindName);
            }
            catch (ClientException e) {
                throw new ArgumentException(LocalizableMessage.raw("Unable to read authentication ID", new Object[0]), (Throwable)e);
            }
        }
        if (value == null) {
            throw new ArgumentException(CliMessages.ERR_LDAPAUTH_SASL_AUTHID_REQUIRED.get(saslMechanism));
        }
        return value;
    }

    private String getAuthcId() throws ArgumentException {
        return this.getSaslProperty("authid");
    }

    public String getAuthzId() throws ArgumentException {
        return this.getSaslProperty("authzid");
    }

    public String getBindName() throws ArgumentException {
        String value = "";
        if (this.bindNameArg.isPresent()) {
            value = this.bindNameArg.getValue();
        } else if (this.app.isInteractive()) {
            LocalizableMessage bindMsg = this.isAdminConnection ? CliMessages.INFO_DESCRIPTION_ADMIN_BINDDN.get() : CliMessages.INFO_DESCRIPTION_BINDDN.get();
            try {
                value = this.app.readInput(bindMsg, this.bindNameArg.getDefaultValue() == null ? value : this.bindNameArg.getDefaultValue());
                this.app.println();
                this.bindNameArg.clearValues();
                this.bindNameArg.addValue(value);
                this.bindNameArg.setPresent(true);
            }
            catch (ClientException e) {
                throw new ArgumentException(CliMessages.ERR_ERROR_CANNOT_READ_BIND_NAME.get(), (Throwable)e);
            }
        }
        return value;
    }

    public BindRequest getBindRequest() throws ArgumentException {
        if (this.bindRequest == null) {
            this.bindRequest = this.getBindRequest0();
            if (this.bindRequest != null) {
                if (this.reportAuthzIdArg.isPresent()) {
                    this.bindRequest.addControl(AuthorizationIdentityRequestControl.newControl(false));
                }
                if (this.usePasswordPolicyControlArg.isPresent()) {
                    this.bindRequest.addControl(PasswordPolicyRequestControl.newControl(false));
                }
            }
        }
        return this.bindRequest;
    }

    private BindRequest getBindRequest0() throws ArgumentException {
        String saslMechanism = this.getSaslMechanism();
        if (saslMechanism == null) {
            if (this.bindNameArg.isPresent() || this.passwordProvidedInArguments()) {
                return Requests.newSimpleBindRequest(this.getBindName(), this.getPassword());
            }
            return null;
        }
        switch (saslMechanism) {
            case "DIGEST-MD5": {
                return Requests.newDigestMd5SaslBindRequest(this.getHostname(), this.getAuthcId("DIGEST-MD5"), this.getPassword(), this.getAuthzId(), this.getRealm(), null);
            }
            case "CRAM-MD5": {
                return Requests.newCramMd5SaslBindRequest(this.getAuthcId("CRAM-MD5"), this.getPassword());
            }
            case "GSSAPI": {
                return Requests.newGssapiSaslBindRequest(this.getHostname(), ConnectionFactoryProvider.kerberos5Login(this.getAuthcId("GSSAPI"), this.getPassword(), this.getKdc(), this.getRealm()), this.getAuthzId(), null);
            }
            case "EXTERNAL": {
                if (this.sslContext == null) {
                    throw new ArgumentException(CliMessages.ERR_TOOL_SASLEXTERNAL_NEEDS_SSL_OR_TLS.get());
                }
                if (!this.keyStorePathArg.isPresent() && this.getKeyStoreFromSystemProperty() == null) {
                    throw new ArgumentException(CliMessages.ERR_TOOL_SASLEXTERNAL_NEEDS_KEYSTORE.get());
                }
                return Requests.newExternalSaslBindRequest(this.getAuthzId());
            }
            case "PLAIN": {
                return Requests.newPlainSaslBindRequest(this.getAuthcId("PLAIN"), this.getPassword(), this.getAuthzId());
            }
            case "ANONYMOUS": {
                return Requests.newAnonymousSaslBindRequest(this.getTrace());
            }
        }
        throw new ArgumentException(CliMessages.ERR_LDAPAUTH_UNSUPPORTED_SASL_MECHANISM.get(saslMechanism));
    }

    public static Subject kerberos5Login(String authenticationID, char[] password, String kdc, String realm) throws ArgumentException {
        Reject.ifNull(authenticationID, "authenticationID must not be null");
        Reject.ifNull((Object)password, "password must not be null");
        if (realm != null) {
            System.setProperty("java.security.krb5.realm", realm);
        }
        if (kdc != null) {
            System.setProperty("java.security.krb5.kdc", kdc);
        }
        HashMap<String, Object> state = new HashMap<String, Object>(2);
        state.put("javax.security.auth.login.name", authenticationID);
        state.put("javax.security.auth.login.password", password);
        HashMap<String, String> options = new HashMap<String, String>(5);
        options.put("tryFirstPass", "true");
        options.put("useTicketCache", "true");
        options.put("doNotPrompt", "true");
        options.put("storePass", "false");
        options.put("forwardable", "true");
        Subject subject = new Subject();
        Krb5LoginModule login = new Krb5LoginModule();
        login.initialize(subject, new TextCallbackHandler(), state, options);
        try {
            if (login.login()) {
                login.commit();
            }
            return subject;
        }
        catch (LoginException e) {
            throw new ArgumentException(CoreMessages.ERR_LDAPAUTH_GSSAPI_LOCAL_AUTHENTICATION_FAILED.get(StaticUtils.getExceptionMessage(e)));
        }
    }

    public String getSaslMechanism() throws ArgumentException {
        return this.getSaslProperty("mech");
    }

    public String getKdc() throws ArgumentException {
        return this.getSaslProperty("kdc");
    }

    public String getRealm() throws ArgumentException {
        return this.getSaslProperty("realm");
    }

    public String getTrace() throws ArgumentException {
        return this.getSaslProperty("trace");
    }

    private String getSaslProperty(String propertyName) throws ArgumentException {
        for (String s : this.saslOptionArg.getValues()) {
            if (!s.startsWith(propertyName)) continue;
            return this.parseSaslOptionValue(s);
        }
        return null;
    }

    public String toString() {
        return this.connFactory.toString();
    }

    private X509KeyManager getKeyManager() throws GeneralSecurityException, IOException {
        String keyStoreFile;
        String keyStorePathArgValue = this.keyStorePathArg.getValue();
        String string = keyStoreFile = keyStorePathArgValue != null ? keyStorePathArgValue : this.getKeyStoreFromSystemProperty();
        if (keyStoreFile == null) {
            return null;
        }
        char[] keyStorePIN = this.getKeyStorePin() != null ? this.getKeyStorePin().toCharArray() : null;
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream fos = new FileInputStream(keyStoreFile);){
            keystore.load(fos, keyStorePIN);
        }
        ApplicationKeyManager akm = new ApplicationKeyManager(keystore, keyStorePIN);
        String clientAlias = this.certNicknameArg.isPresent() ? this.certNicknameArg.getValue() : null;
        return clientAlias != null ? KeyManagers.useSingleCertificate(clientAlias, akm) : null;
    }

    private String getKeyStoreFromSystemProperty() {
        return System.getProperty("javax.net.ssl.keyStore");
    }

    private String getKeyStorePin() {
        String pwd = this.keyStorePasswordArg.isPresent() ? this.keyStorePasswordArg.getValue() : (this.keyStorePasswordFileArg.isPresent() ? this.keyStorePasswordFileArg.getValue() : System.getProperty("javax.net.ssl.keyStorePassword"));
        return pwd;
    }

    public void forcePasswordPromptIfNeeded() throws ArgumentException {
        if (this.bindNameArg.isPresent() && !this.passwordProvidedInArguments() && this.bindRequiresPassword()) {
            this.interactivelyPromptForPassword();
        }
    }

    private boolean bindRequiresPassword() throws ArgumentException {
        String saslMechanism = this.getSaslMechanism();
        if (saslMechanism == null) {
            return true;
        }
        switch (saslMechanism) {
            case "EXTERNAL": 
            case "ANONYMOUS": {
                return false;
            }
        }
        return true;
    }

    private boolean passwordProvidedInArguments() {
        return this.passwordProvidedOnCommandLine() || this.bindPasswordFileArg.isPresent();
    }

    public char[] getPassword() throws ArgumentException {
        if (this.passwordProvidedOnCommandLine()) {
            return this.bindPasswordArg.getValue().toCharArray();
        }
        if (this.bindPasswordFileArg.isPresent()) {
            return this.bindPasswordFileArg.getValue().toCharArray();
        }
        if (this.passwordFromInteractivePrompt != null) {
            return this.passwordFromInteractivePrompt;
        }
        if (this.app.isInteractive()) {
            return this.interactivelyPromptForPassword();
        }
        return "".toCharArray();
    }

    private boolean passwordProvidedOnCommandLine() {
        return this.bindPasswordArg.isPresent() && !"-".equals(this.bindPasswordArg.getValue());
    }

    private char[] interactivelyPromptForPassword() throws ArgumentException {
        try {
            this.passwordFromInteractivePrompt = this.app.readPassword(CliMessages.INFO_LDAPAUTH_PASSWORD_PROMPT.get(this.getBindName()));
            this.app.println();
            return this.passwordFromInteractivePrompt;
        }
        catch (ClientException e) {
            throw new ArgumentException(CliMessages.ERR_ERROR_CANNOT_READ_PASSWORD.get(), (Throwable)e);
        }
    }

    private TrustManager getTrustManager() throws IOException, GeneralSecurityException {
        String trustStorePath;
        if (this.trustAllArg.isPresent()) {
            return TrustManagers.trustAll();
        }
        String string = trustStorePath = this.trustStorePathArg.getValue() != null ? this.trustStorePathArg.getValue() : this.getTrustStoreFromSystemProperty();
        if (trustStorePath != null) {
            return this.trustInteractively(TrustManagers.checkValidityDates(TrustManagers.checkHostName(this.hostNameArg.getValue(), TrustManagers.checkUsingTrustStore(trustStorePath, this.getTrustStorePin(), null))));
        }
        return this.trustInteractively(null);
    }

    private TrustManager trustInteractively(X509TrustManager tm) throws IOException, GeneralSecurityException {
        if (this.app != null && !this.app.isQuiet()) {
            return new PromptingTrustManager(this.app, tm);
        }
        return tm;
    }

    private String getTrustStoreFromSystemProperty() {
        return System.getProperty("javax.net.ssl.trustStore");
    }

    private char[] getTrustStorePin() {
        String pwd = this.trustStorePasswordArg.isPresent() ? this.trustStorePasswordArg.getValue() : (this.trustStorePasswordFileArg.isPresent() ? this.trustStorePasswordFileArg.getValue() : System.getProperty("javax.net.ssl.trustStorePassword"));
        return pwd == null ? null : pwd.toCharArray();
    }

    private String parseSaslOptionValue(String option) throws ArgumentException {
        int equalPos = option.indexOf(61);
        if (equalPos == -1) {
            throw new ArgumentException(CliMessages.ERR_LDAP_CONN_CANNOT_PARSE_SASL_OPTION.get(option));
        }
        return option.substring(equalPos + 1, option.length());
    }

    public void setIsAnAdminConnection() {
        this.isAdminConnection = true;
    }

    public CommandBuilder getConnectionCommandLineParameters() {
        CommandBuilder builder = new CommandBuilder();
        builder.addArgumentsIfPresent(this.hostNameArg, this.portArg, this.bindNameArg, this.bindPasswordFileArg, this.saslOptionArg, this.trustAllArg, this.trustStorePathArg, this.trustStorePasswordFileArg, this.keyStorePathArg, this.keyStorePasswordFileArg, this.certNicknameArg, this.reportAuthzIdArg, this.connectTimeOut, this.usePasswordPolicyControlArg);
        if (this.bindPasswordArg.isPresent() || this.passwordFromInteractivePrompt != null) {
            builder.addArgumentAndValue(this.bindPasswordArg, "******");
        }
        builder.addObfuscatedArguments(this.trustStorePasswordArg, this.keyStorePasswordArg);
        if (!this.alwaysUseSsl) {
            builder.addArgumentsIfPresent(this.useSslArg, this.useStartTlsArg);
        }
        if (!this.trustStorePathArg.isPresent()) {
            builder.addArgument(this.trustAllArg);
        }
        return builder;
    }
}

