/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.DocDescriptionSupplement;
import com.forgerock.opendj.cli.SubCommand;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.util.Reject;

public abstract class Argument
implements DocDescriptionSupplement {
    final String longIdentifier;
    private final Character shortIdentifier;
    private final LocalizableMessage description;
    private final boolean isHidden;
    private final boolean isMultiValued;
    private final boolean isRequired;
    private final boolean needsValue;
    private final String defaultValue;
    private final LocalizableMessage valuePlaceholder;
    private final LinkedList<String> values = new LinkedList();
    private boolean isPresent;
    private boolean isValueSetByProperty;
    private LocalizableMessage docDescriptionSupplement;

    <B extends ArgumentBuilder<B, T, A>, T, A extends Argument> Argument(ArgumentBuilder<B, T, A> builder) {
        this.shortIdentifier = builder.shortIdentifier;
        this.longIdentifier = builder.longIdentifier;
        this.isRequired = builder.required;
        this.isMultiValued = builder.multiValued;
        this.needsValue = builder.needsValue;
        this.valuePlaceholder = builder.valuePlaceholder;
        this.defaultValue = builder.defaultValue != null ? String.valueOf(builder.defaultValue) : null;
        this.description = builder.description;
        this.isHidden = builder.hidden;
        this.docDescriptionSupplement = builder.docDescriptionSupplement;
        if (this.needsValue && this.valuePlaceholder == null) {
            throw new IllegalArgumentException(CliMessages.ERR_ARG_NO_VALUE_PLACEHOLDER.get(this.longIdentifier).toString());
        }
        this.isPresent = false;
    }

    public void addValue(String valueString) {
        if (!this.isMultiValued) {
            this.clearValues();
        }
        this.values.add(valueString);
    }

    public void clearValues() {
        this.values.clear();
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public LocalizableMessage getDescription() {
        return this.description != null ? this.description : LocalizableMessage.EMPTY;
    }

    @Override
    public LocalizableMessage getDocDescriptionSupplement() {
        return this.docDescriptionSupplement != null ? this.docDescriptionSupplement : LocalizableMessage.EMPTY;
    }

    public int getIntValue() throws ArgumentException {
        if (this.values.isEmpty()) {
            throw new ArgumentException(CliMessages.ERR_ARG_NO_INT_VALUE.get(this.longIdentifier));
        }
        Iterator iterator = this.values.iterator();
        String valueString = (String)iterator.next();
        if (iterator.hasNext()) {
            throw new ArgumentException(CliMessages.ERR_ARG_INT_MULTIPLE_VALUES.get(this.longIdentifier));
        }
        try {
            return Integer.parseInt(valueString);
        }
        catch (Exception e) {
            throw new ArgumentException(CliMessages.ERR_ARG_CANNOT_DECODE_AS_INT.get(valueString, this.longIdentifier), (Throwable)e);
        }
    }

    public String getLongIdentifier() {
        return this.longIdentifier;
    }

    public Character getShortIdentifier() {
        return this.shortIdentifier;
    }

    public String getValue() {
        return !this.values.isEmpty() ? this.values.getFirst() : this.defaultValue;
    }

    public LocalizableMessage getValuePlaceholder() {
        return this.valuePlaceholder;
    }

    public List<String> getValues() {
        return this.values;
    }

    public String[] getValuesAsArray() {
        return this.values.toArray(new String[0]);
    }

    public boolean hasValue() {
        return !this.values.isEmpty();
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isMultiValued() {
        return this.isMultiValued;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public boolean isValueSetByProperty() {
        return this.isValueSetByProperty;
    }

    public boolean needsValue() {
        return this.needsValue;
    }

    public void setPresent(boolean isPresent) {
        this.isPresent = isPresent;
    }

    void valueSetByProperty() {
        this.isValueSetByProperty = true;
    }

    public abstract boolean valueIsAcceptable(String var1, LocalizableMessageBuilder var2);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("(");
        if (this.longIdentifier != null) {
            sb.append("longID=");
            sb.append(this.longIdentifier);
        }
        if (this.shortIdentifier != null) {
            if (this.longIdentifier != null) {
                sb.append(", ");
            }
            sb.append("shortID=");
            sb.append(this.shortIdentifier);
        }
        sb.append(", values=").append(this.values);
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object arg) {
        return this == arg || arg instanceof Argument && ((Argument)arg).longIdentifier.equalsIgnoreCase(this.longIdentifier);
    }

    public int hashCode() {
        return this.longIdentifier.hashCode();
    }

    static abstract class ArgumentBuilder<B extends ArgumentBuilder<B, T, A>, T, A extends Argument> {
        T defaultValue;
        LocalizableMessage description;
        LocalizableMessage docDescriptionSupplement;
        boolean hidden;
        final String longIdentifier;
        boolean multiValued;
        boolean needsValue = true;
        boolean required;
        Character shortIdentifier;
        LocalizableMessage valuePlaceholder;

        ArgumentBuilder(String longIdentifier) {
            Reject.ifNull(longIdentifier, "An argument must have a long identifier");
            this.longIdentifier = longIdentifier;
        }

        abstract B getThis();

        public abstract A buildArgument();

        public A buildAndAddToParser(ArgumentParser parser) {
            return parser.addArgument(this.buildArgument());
        }

        public A buildAndAddToSubCommand(SubCommand subCommand) {
            return subCommand.addArgument(this.buildArgument());
        }

        public B defaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
            return this.getThis();
        }

        public B description(LocalizableMessage description) {
            this.description = description;
            return this.getThis();
        }

        public B docDescriptionSupplement(LocalizableMessage docDescriptionSupplement) {
            this.docDescriptionSupplement = docDescriptionSupplement;
            return this.getThis();
        }

        public B hidden() {
            this.hidden = true;
            return this.getThis();
        }

        public B multiValued() {
            this.multiValued = true;
            return this.getThis();
        }

        public B required() {
            this.required = true;
            return this.getThis();
        }

        public B shortIdentifier(Character shortIdentifier) {
            this.shortIdentifier = shortIdentifier;
            return this.getThis();
        }

        public B valuePlaceholder(LocalizableMessage valuePlaceholder) {
            this.valuePlaceholder = valuePlaceholder;
            return this.getThis();
        }
    }
}

