/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.services.context;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.forgerock.json.JsonValue;
import org.forgerock.services.context.Context;
import org.forgerock.util.Reject;

public abstract class AbstractContext
implements Context {
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PARENT = "parent";
    private final Context parent;
    protected final JsonValue data;

    protected AbstractContext(Context parent, String name) {
        this(null, name, parent);
    }

    protected AbstractContext(String id, String name, Context parent) {
        this.data = JsonValue.json(JsonValue.object(new Map.Entry[0]));
        this.data.put(ATTR_CLASS, (Object)this.getClass().getName());
        if (id != null) {
            this.data.put(ATTR_ID, (Object)id);
        }
        this.data.put(ATTR_NAME, (Object)name);
        this.parent = parent;
    }

    public AbstractContext(JsonValue savedContext, ClassLoader classLoader) {
        JsonValue savedParentContext = savedContext.get(ATTR_PARENT);
        savedContext.remove(ATTR_PARENT);
        this.data = savedContext.copy();
        this.parent = savedParentContext.isNull() ? null : AbstractContext.load0(savedParentContext, classLoader);
    }

    private static Context load0(JsonValue savedContext, ClassLoader classLoader) {
        String className = savedContext.get(ATTR_CLASS).required().asString();
        try {
            Class<AbstractContext> clazz = Class.forName(className, true, classLoader).asSubclass(AbstractContext.class);
            Constructor<AbstractContext> constructor = clazz.getDeclaredConstructor(JsonValue.class, ClassLoader.class);
            return constructor.newInstance(savedContext, classLoader);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to instantiate Context implementation class '" + className + "'", e);
        }
    }

    @Override
    public final String getContextName() {
        return this.data.get(ATTR_NAME).asString();
    }

    @Override
    public final <T extends Context> T asContext(Class<T> clazz) {
        Reject.ifNull(clazz, "clazz cannot be null");
        T context = this.asContext0(clazz);
        if (context != null) {
            return context;
        }
        throw new IllegalArgumentException("No context of type " + clazz.getName() + " found.");
    }

    @Override
    public final Context getContext(String contextName) {
        Context context = this.getContext0(contextName);
        if (context != null) {
            return context;
        }
        throw new IllegalArgumentException("No context of named " + contextName + " found.");
    }

    @Override
    public final boolean containsContext(Class<? extends Context> clazz) {
        return this.asContext0(clazz) != null;
    }

    @Override
    public final boolean containsContext(String contextName) {
        return this.getContext0(contextName) != null;
    }

    @Override
    public final String getId() {
        if (this.data.get(ATTR_ID).isNull() && !this.isRootContext()) {
            return this.getParent().getId();
        }
        return this.data.get(ATTR_ID).required().asString();
    }

    @Override
    public final Context getParent() {
        return this.parent;
    }

    @Override
    public final boolean isRootContext() {
        return this.getParent() == null;
    }

    @Override
    public JsonValue toJsonValue() {
        JsonValue value = this.data.copy();
        value.put(ATTR_PARENT, this.parent != null ? this.parent.toJsonValue().getObject() : null);
        return value;
    }

    public String toString() {
        return this.toJsonValue().toString();
    }

    private <T extends Context> T asContext0(Class<T> clazz) {
        try {
            for (Context context = this; context != null; context = context.getParent()) {
                Class<?> contextClass = context.getClass();
                if (!clazz.isAssignableFrom(contextClass)) continue;
                return (T)((Context)contextClass.asSubclass(clazz).cast(context));
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to instantiate Context implementation class '" + clazz.getName() + "'", e);
        }
    }

    private Context getContext0(String contextName) {
        for (Context context = this; context != null; context = context.getParent()) {
            if (!context.getContextName().equals(contextName)) continue;
            return context;
        }
        return null;
    }
}

