/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.security;

import java.security.KeyStore;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.security.ExternalKeyWrappingStrategy;
import org.forgerock.opendj.security.KeyStoreObjectCache;
import org.forgerock.opendj.security.OpenDjSecurityProvider;
import org.forgerock.util.Factory;
import org.forgerock.util.Option;
import org.forgerock.util.Options;

public final class KeyStoreParameters
implements KeyStore.LoadStoreParameter {
    public static final Option<Factory<char[]>> GLOBAL_PASSWORD = Option.of(Factory.class, OpenDjSecurityProvider.newClearTextPasswordFactory(null));
    public static final Option<KeyStoreObjectCache> CACHE = Option.withDefault(KeyStoreObjectCache.NONE);
    public static final Option<Integer> PBKDF2_ITERATIONS = Option.withDefault(10000);
    public static final Option<Integer> PBKDF2_SALT_SIZE = Option.withDefault(16);
    public static final Option<ExternalKeyWrappingStrategy> EXTERNAL_KEY_WRAPPING_STRATEGY = Option.of(ExternalKeyWrappingStrategy.class, null);
    private final ConnectionFactory factory;
    private final Dn baseDn;
    private final Options options;

    public static KeyStoreParameters newKeyStoreParameters(ConnectionFactory factory, Dn baseDN) {
        return KeyStoreParameters.newKeyStoreParameters(factory, baseDN, Options.defaultOptions());
    }

    public static KeyStoreParameters newKeyStoreParameters(ConnectionFactory factory, Dn baseDN, Options options) {
        return new KeyStoreParameters(factory, baseDN, options);
    }

    private KeyStoreParameters(ConnectionFactory factory, Dn baseDn, Options options) {
        this.factory = factory;
        this.baseDn = baseDn;
        this.options = options;
    }

    @Override
    public KeyStore.ProtectionParameter getProtectionParameter() {
        throw new IllegalStateException();
    }

    Options getOptions() {
        return this.options;
    }

    Connection getConnection() throws LdapException {
        return this.getConnectionFactory().getConnection();
    }

    ConnectionFactory getConnectionFactory() {
        return this.factory;
    }

    Dn getBaseDn() {
        return this.baseDn;
    }
}

