/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.EntryNotFoundException;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.MultipleEntriesFoundException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.messages.Requests;
import org.forgerock.opendj.ldap.messages.Result;
import org.forgerock.opendj.ldap.messages.SearchRequest;
import org.forgerock.opendj.ldap.messages.SearchResultEntry;
import org.forgerock.opendj.ldap.messages.SearchResultReference;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.rest2ldap.AbstractLdapPropertyMapper;
import org.forgerock.opendj.rest2ldap.DnTemplate;
import org.forgerock.opendj.rest2ldap.FilterType;
import org.forgerock.opendj.rest2ldap.PropertyMapper;
import org.forgerock.opendj.rest2ldap.Resource;
import org.forgerock.opendj.rest2ldap.Rest2Ldap;
import org.forgerock.opendj.rest2ldap.Rest2ldapMessages;
import org.forgerock.opendj.rest2ldap.Utils;
import org.forgerock.services.context.Context;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.promise.ResultHandler;

public final class ReferencePropertyMapper
extends AbstractLdapPropertyMapper<ReferencePropertyMapper> {
    private static final int SEARCH_MAX_CANDIDATES = 1000;
    private final DnTemplate baseDnTemplate;
    private final Schema schema;
    private Filter filter;
    private final PropertyMapper mapper;
    private final AttributeDescription primaryKey;
    private SearchScope scope = SearchScope.WHOLE_SUBTREE;

    ReferencePropertyMapper(Schema schema, AttributeDescription ldapAttributeName, String baseDnTemplate, AttributeDescription primaryKey, PropertyMapper mapper) {
        super(ldapAttributeName);
        this.schema = schema;
        this.baseDnTemplate = DnTemplate.compile(baseDnTemplate);
        this.primaryKey = primaryKey;
        this.mapper = mapper;
    }

    public ReferencePropertyMapper searchFilter(Filter filter) {
        this.filter = Reject.checkNotNull(filter);
        return this;
    }

    public ReferencePropertyMapper searchFilter(String filter) {
        return this.searchFilter(Filter.valueOf(filter));
    }

    public ReferencePropertyMapper searchScope(SearchScope scope) {
        this.scope = Reject.checkNotNull(scope);
        return this;
    }

    public String toString() {
        return "reference(" + this.ldapAttributeName + ")";
    }

    @Override
    Promise<Filter, ResourceException> getLdapFilter(final Context context, Resource resource, JsonPointer path, JsonPointer subPath, FilterType type, String operator, Object valueAssertion) {
        return this.mapper.getLdapFilter(context, resource, path, subPath, type, operator, valueAssertion).thenAsync(new AsyncFunction<Filter, Filter, ResourceException>(){

            @Override
            public Promise<Filter, ResourceException> apply(Filter result) {
                SearchRequest request = ReferencePropertyMapper.this.createSearchRequest(context, result);
                final LinkedList subFilters = new LinkedList();
                return Utils.connectionFrom(context).searchAsync(request, new SearchResultHandler(){

                    @Override
                    public boolean handleEntry(SearchResultEntry entry) {
                        if (subFilters.size() < 1000) {
                            subFilters.add(Filter.equality(ReferencePropertyMapper.this.ldapAttributeName.toString(), entry.getName()));
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public boolean handleReference(SearchResultReference reference) {
                        return true;
                    }
                }).then(new Function<Result, Filter, ResourceException>(){

                    @Override
                    public Filter apply(Result result) throws ResourceException {
                        if (subFilters.size() >= 1000) {
                            throw Rest2Ldap.asResourceException(LdapException.newLdapException(ResultCode.ADMIN_LIMIT_EXCEEDED));
                        }
                        if (subFilters.size() == 1) {
                            return (Filter)subFilters.get(0);
                        }
                        return Filter.or(subFilters);
                    }
                }, new Function<LdapException, Filter, ResourceException>(){

                    @Override
                    public Filter apply(LdapException exception) throws ResourceException {
                        throw Rest2Ldap.asResourceException(exception);
                    }
                });
            }
        });
    }

    @Override
    Promise<Attribute, ResourceException> getNewLdapAttributes(final Context context, Resource resource, final JsonPointer path, List<Object> newValues) {
        final LinkedAttribute newLDAPAttribute = new LinkedAttribute(this.ldapAttributeName);
        final AtomicInteger pendingSearches = new AtomicInteger(newValues.size());
        final AtomicReference exception = new AtomicReference();
        final PromiseImpl<Attribute, ResourceException> promise = PromiseImpl.create();
        for (Object value : newValues) {
            this.mapper.create(context, resource, path, new JsonValue(value)).thenOnResult(new ResultHandler<List<Attribute>>(){

                @Override
                public void handleResult(List<Attribute> result) {
                    Attribute primaryKeyAttribute = null;
                    for (Attribute attribute : result) {
                        if (!attribute.getAttributeDescription().equals(ReferencePropertyMapper.this.primaryKey)) continue;
                        primaryKeyAttribute = attribute;
                        break;
                    }
                    if (primaryKeyAttribute == null || primaryKeyAttribute.isEmpty()) {
                        promise.handleException(Utils.newBadRequestException(Rest2ldapMessages.ERR_REFERENCE_FIELD_NO_PRIMARY_KEY.get(path)));
                        return;
                    }
                    if (primaryKeyAttribute.size() > 1) {
                        promise.handleException(Utils.newBadRequestException(Rest2ldapMessages.ERR_REFERENCE_FIELD_MULTIPLE_PRIMARY_KEYS.get(path)));
                        return;
                    }
                    final ByteString primaryKeyValue = primaryKeyAttribute.firstValue();
                    Filter filter = Filter.equality(ReferencePropertyMapper.this.primaryKey.toString(), primaryKeyValue);
                    SearchRequest search = ReferencePropertyMapper.this.createSearchRequest(context, filter);
                    Utils.connectionFrom(context).searchSingleEntryAsync(search).thenOnResult(new ResultHandler<SearchResultEntry>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void handleResult(SearchResultEntry result) {
                            Attribute attribute = newLDAPAttribute;
                            synchronized (attribute) {
                                newLDAPAttribute.add(new Object[]{result.getName()});
                            }
                            this.completeIfNecessary();
                        }
                    }).thenOnException(new ExceptionHandler<LdapException>(){

                        @Override
                        public void handleException(LdapException error) {
                            ResourceException re;
                            try {
                                throw error;
                            }
                            catch (EntryNotFoundException e) {
                                re = Utils.newBadRequestException(Rest2ldapMessages.ERR_REFERENCE_FIELD_DOES_NOT_EXIST.get(primaryKeyValue, path));
                            }
                            catch (MultipleEntriesFoundException e) {
                                re = Utils.newBadRequestException(Rest2ldapMessages.ERR_REFERENCE_FIELD_AMBIGUOUS.get(primaryKeyValue, path));
                            }
                            catch (LdapException e) {
                                re = Rest2Ldap.asResourceException(e);
                            }
                            exception.compareAndSet(null, re);
                            this.completeIfNecessary();
                        }
                    });
                }

                private void completeIfNecessary() {
                    if (pendingSearches.decrementAndGet() == 0) {
                        if (exception.get() != null) {
                            promise.handleException((Exception)exception.get());
                        } else {
                            promise.handleResult(newLDAPAttribute);
                        }
                    }
                }
            });
        }
        return promise;
    }

    @Override
    ReferencePropertyMapper getThis() {
        return this;
    }

    @Override
    Promise<JsonValue, ResourceException> read(Context context, Resource resource, JsonPointer path, Entry e) {
        Set<Dn> dns = e.parseAttribute(this.ldapAttributeName).usingSchema(this.schema).asSetOfDn();
        switch (dns.size()) {
            case 0: {
                return Promises.newResultPromise(null);
            }
            case 1: {
                if (!this.attributeIsSingleValued()) break;
                try {
                    return this.readEntry(context, resource, path, dns.iterator().next());
                }
                catch (Exception ex) {
                    return Promises.newExceptionPromise(Rest2Ldap.asResourceException(ex));
                }
            }
        }
        try {
            ArrayList promises = new ArrayList(dns.size());
            for (Dn dn : dns) {
                promises.add(this.readEntry(context, resource, path, dn));
            }
            return Promises.when(promises).then(new Function<List<JsonValue>, JsonValue, ResourceException>(){

                @Override
                public JsonValue apply(List<JsonValue> value) {
                    if (value.isEmpty()) {
                        return null;
                    }
                    ArrayList<Object> result = new ArrayList<Object>(value.size());
                    for (JsonValue e : value) {
                        if (e == null) continue;
                        result.add(e.getObject());
                    }
                    return result.isEmpty() ? null : new JsonValue(result);
                }
            });
        }
        catch (Exception ex) {
            return Promises.newExceptionPromise(Rest2Ldap.asResourceException(ex));
        }
    }

    private SearchRequest createSearchRequest(Context context, Filter result) {
        Filter searchFilter = this.filter != null ? Filter.and(this.filter, result) : result;
        return Requests.newSearchRequest(this.baseDnTemplate.format(context), this.scope, searchFilter, "1.1");
    }

    private Promise<JsonValue, ResourceException> readEntry(final Context context, final Resource resource, final JsonPointer path, Dn dn) {
        LinkedHashSet<String> requestedLDAPAttributes = new LinkedHashSet<String>();
        this.mapper.getLdapAttributes(path, new JsonPointer(), requestedLDAPAttributes);
        Filter searchFilter = this.filter != null ? this.filter : Filter.alwaysTrue();
        String[] attributes = requestedLDAPAttributes.toArray(new String[requestedLDAPAttributes.size()]);
        SearchRequest request = Requests.newSearchRequest(dn, SearchScope.BASE_OBJECT, searchFilter, attributes);
        return Utils.connectionFrom(context).searchSingleEntryAsync(request).thenAsync(new AsyncFunction<SearchResultEntry, JsonValue, ResourceException>(){

            @Override
            public Promise<JsonValue, ResourceException> apply(SearchResultEntry result) {
                return ReferencePropertyMapper.this.mapper.read(context, resource, path, result);
            }
        }, new AsyncFunction<LdapException, JsonValue, ResourceException>(){

            @Override
            public Promise<JsonValue, ResourceException> apply(LdapException error) {
                if (error instanceof EntryNotFoundException) {
                    return Promises.newResultPromise(null);
                }
                return Promises.newExceptionPromise(Rest2Ldap.asResourceException(error));
            }
        });
    }

    @Override
    JsonValue toJsonSchema() {
        if (this.mapper.isMultiValued()) {
            JsonValue jsonSchema = JsonValue.json(JsonValue.object(JsonValue.field("type", "array"), JsonValue.field("items", this.mapper.toJsonSchema().getObject()), JsonValue.field("uniqueItems", true)));
            this.putWritabilityProperties(jsonSchema);
            return jsonSchema;
        }
        return this.mapper.toJsonSchema();
    }
}

