/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import com.forgerock.opendj.ldap.CoreMessages;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.io.Asn1;
import org.forgerock.opendj.io.Ldap;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.Attributes;
import org.forgerock.opendj.ldap.Ava;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.Entries;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.Matcher;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.Rdn;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.controls.SubtreeDeleteRequestControl;
import org.forgerock.opendj.ldap.messages.AddRequest;
import org.forgerock.opendj.ldap.messages.DeleteRequest;
import org.forgerock.opendj.ldap.messages.ModifyDnRequest;
import org.forgerock.opendj.ldap.messages.ModifyRequest;
import org.forgerock.opendj.ldap.messages.Requests;
import org.forgerock.opendj.ldap.messages.SearchRequest;
import org.forgerock.opendj.ldap.schema.AttributeUsage;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.ldif.ChangeRecordReader;
import org.forgerock.opendj.ldif.ChangeRecordVisitor;
import org.forgerock.opendj.ldif.ChangeRecordWriter;
import org.forgerock.opendj.ldif.EntryReader;
import org.forgerock.opendj.ldif.EntryWriter;
import org.forgerock.opendj.ldif.LdifEntryReader;
import org.forgerock.opendj.ldif.RejectedChangeRecordListener;

public final class Ldif {
    private static final Comparator<byte[][]> DN_ORDER2 = new Comparator<byte[][]>(){

        @Override
        public int compare(byte[][] b1, byte[][] b2) {
            return DN_ORDER.compare(b1[0], b2[0]);
        }
    };
    private static final Comparator<byte[]> DN_ORDER = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] b1, byte[] b2) {
            ByteString bs = ByteString.valueOfBytes(b1);
            ByteString bs2 = ByteString.valueOfBytes(b2);
            return bs.compareTo(bs2);
        }
    };

    public static ChangeRecordWriter copyTo(ChangeRecordReader input, ChangeRecordWriter output) throws IOException {
        while (input.hasNext()) {
            output.writeChangeRecord(input.readChangeRecord());
        }
        return output;
    }

    public static EntryWriter copyTo(EntryReader input, EntryWriter output) throws IOException {
        while (input.hasNext()) {
            output.writeEntry(input.readEntry());
        }
        return output;
    }

    public static ChangeRecordReader diff(EntryReader source, EntryReader target) throws IOException {
        return Ldif.diff(source, target, Entries.diffOptions());
    }

    public static ChangeRecordReader diff(final EntryReader source, final EntryReader target, final Entries.DiffOptions options) throws IOException {
        List<byte[][]> source2 = Ldif.readEntriesAsList(source);
        List<byte[][]> target2 = Ldif.readEntriesAsList(target);
        final Iterator<byte[][]> sourceIterator = source2.iterator();
        final Iterator<byte[][]> targetIterator = target2.iterator();
        return new ChangeRecordReader(){
            private Entry sourceEntry;
            private Entry targetEntry;
            {
                this.sourceEntry = this.nextEntry(sourceIterator);
                this.targetEntry = this.nextEntry(targetIterator);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    source.close();
                }
                finally {
                    target.close();
                }
            }

            @Override
            public boolean hasNext() {
                return this.sourceEntry != null || this.targetEntry != null;
            }

            @Override
            public ChangeRecord readChangeRecord() throws IOException {
                if (this.sourceEntry != null && this.targetEntry != null) {
                    Dn targetDN;
                    Dn sourceDN = this.sourceEntry.getName();
                    int cmp = sourceDN.compareTo(targetDN = this.targetEntry.getName());
                    if (cmp == 0) {
                        ModifyRequest request = Entries.diffEntries(this.sourceEntry, this.targetEntry, options);
                        this.sourceEntry = this.nextEntry(sourceIterator);
                        this.targetEntry = this.nextEntry(targetIterator);
                        return request;
                    }
                    if (cmp < 0) {
                        DeleteRequest request = Requests.newDeleteRequest(this.sourceEntry.getName());
                        this.sourceEntry = this.nextEntry(sourceIterator);
                        return request;
                    }
                    AddRequest request = Requests.newAddRequest(this.targetEntry);
                    this.targetEntry = this.nextEntry(targetIterator);
                    return request;
                }
                if (this.sourceEntry != null) {
                    DeleteRequest request = Requests.newDeleteRequest(this.sourceEntry.getName());
                    this.sourceEntry = this.nextEntry(sourceIterator);
                    return request;
                }
                if (this.targetEntry != null) {
                    AddRequest request = Requests.newAddRequest(this.targetEntry);
                    this.targetEntry = this.nextEntry(targetIterator);
                    return request;
                }
                throw new NoSuchElementException();
            }

            private Entry nextEntry(Iterator<byte[][]> i) {
                if (i.hasNext()) {
                    return Ldif.decodeEntry(i.next()[1]);
                }
                return null;
            }
        };
    }

    public static Entry makeEntry(String ... ldifLines) {
        List<Entry> entries = Ldif.makeEntries(ldifLines);
        if (entries.size() > 1) {
            throw new LocalizedIllegalArgumentException(CoreMessages.WARN_READ_LDIF_ENTRY_MULTIPLE_ENTRIES_FOUND.get(entries.size()));
        }
        return entries.get(0);
    }

    public static Entry makeEntry(List<String> ldifLines) {
        return Ldif.makeEntry(ldifLines.toArray(new String[ldifLines.size()]));
    }

    public static List<Entry> makeEntries(String ... ldifLines) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        try (LdifEntryReader reader = new LdifEntryReader(ldifLines);){
            while (reader.hasNext()) {
                entries.add(reader.readEntry());
            }
        }
        catch (DecodeException e) {
            throw new LocalizedIllegalArgumentException(e.getMessageObject());
        }
        catch (IOException e) {
            throw new LocalizedIllegalArgumentException(CoreMessages.WARN_READ_LDIF_RECORD_UNEXPECTED_IO_ERROR.get(e.getMessage()));
        }
        if (entries.isEmpty()) {
            throw new LocalizedIllegalArgumentException(CoreMessages.WARN_READ_LDIF_ENTRY_NO_ENTRY_FOUND.get());
        }
        return entries;
    }

    public static List<Entry> makeEntries(List<String> ldifLines) {
        return Ldif.makeEntries(ldifLines.toArray(new String[ldifLines.size()]));
    }

    public static EntryReader newEntryCollectionReader(Collection<Entry> entries) {
        return new EntryIteratorReader(entries.iterator());
    }

    public static EntryReader newEntryIteratorReader(Iterator<Entry> entries) {
        return new EntryIteratorReader(entries);
    }

    public static EntryReader patch(EntryReader input, ChangeRecordReader patch) throws IOException {
        return Ldif.patch(input, patch, RejectedChangeRecordListener.OVERWRITE);
    }

    public static EntryReader patch(final EntryReader input, final ChangeRecordReader patch, final RejectedChangeRecordListener listener) throws IOException {
        final TreeMap<byte[], byte[]> entries = Ldif.readEntriesAsMap(input);
        while (patch.hasNext()) {
            ChangeRecord change = patch.readChangeRecord();
            final Dn changeDN = change.getName();
            final byte[] changeNormDN = Ldif.toNormalizedByteArray(change.getName());
            change.accept(new ChangeRecordVisitor<Void, Void, DecodeException>(){

                @Override
                public Void visitRequest(Void p, AddRequest change) throws DecodeException {
                    if (entries.get(changeNormDN) != null) {
                        Entry existingEntry = Ldif.decodeEntry((byte[])entries.get(changeNormDN));
                        Entry entry = listener.handleDuplicateEntry(change, existingEntry);
                        entries.put(Ldif.toNormalizedByteArray(entry.getName()), Ldif.encodeEntry(entry)[1]);
                    } else {
                        entries.put(changeNormDN, Ldif.encodeEntry(change)[1]);
                    }
                    return null;
                }

                @Override
                public Void visitRequest(Void p, DeleteRequest change) throws DecodeException {
                    if (entries.get(changeNormDN) == null) {
                        listener.handleRejectedChangeRecord(change, CoreMessages.REJECTED_CHANGE_FAIL_DELETE.get(change.getName()));
                    } else if (change.getControl(SubtreeDeleteRequestControl.DECODER, new DecodeOptions()) != null) {
                        entries.subMap(Ldif.toNormalizedByteArray(change.getName()), Ldif.toNormalizedByteArray(change.getName().child(Rdn.maxValue()))).clear();
                    } else {
                        entries.remove(changeNormDN);
                    }
                    return null;
                }

                @Override
                public Void visitRequest(Void p, ModifyDnRequest change) throws DecodeException {
                    if (entries.get(changeNormDN) == null) {
                        listener.handleRejectedChangeRecord(change, CoreMessages.REJECTED_CHANGE_FAIL_MODIFYDN.get(change.getName()));
                    } else {
                        Dn newDN = change.getName().rename(change.getNewRdn(), change.getNewSuperior());
                        TreeMap<byte[], byte[]> renamedEntries = new TreeMap<byte[], byte[]>(DN_ORDER);
                        Iterator i = entries.subMap(changeNormDN, Ldif.toNormalizedByteArray(changeDN.child(Rdn.maxValue()))).entrySet().iterator();
                        while (i.hasNext()) {
                            Map.Entry e = i.next();
                            Entry entry = Ldif.decodeEntry((byte[])e.getValue());
                            Dn renamedDN = entry.getName().rename(changeDN, newDN);
                            entry.setName(renamedDN);
                            renamedEntries.put(Ldif.toNormalizedByteArray(renamedDN), Ldif.encodeEntry(entry)[1]);
                            i.remove();
                        }
                        Entry targetEntry = Ldif.decodeEntry((byte[])renamedEntries.values().iterator().next());
                        if (change.isDeleteOldRdn()) {
                            for (Ava ava : changeDN.rdn()) {
                                targetEntry.removeAttribute(ava.toAttribute(), null);
                            }
                        }
                        for (Ava ava : newDN.rdn()) {
                            targetEntry.addAttribute(ava.toAttribute());
                        }
                        renamedEntries.remove(Ldif.toNormalizedByteArray(targetEntry.getName()));
                        renamedEntries.put(Ldif.toNormalizedByteArray(targetEntry.getName()), Ldif.encodeEntry(targetEntry)[1]);
                        for (byte[] bytes : renamedEntries.values()) {
                            Entry renamedEntry = Ldif.decodeEntry(bytes);
                            byte[] existingEntryDn = (byte[])entries.get(Ldif.toNormalizedByteArray(renamedEntry.getName()));
                            if (existingEntryDn != null) {
                                Entry existingEntry = Ldif.decodeEntry(existingEntryDn);
                                Entry tmp = listener.handleDuplicateEntry(change, existingEntry, renamedEntry);
                                entries.put(Ldif.toNormalizedByteArray(tmp.getName()), Ldif.encodeEntry(tmp)[1]);
                                continue;
                            }
                            entries.put(Ldif.toNormalizedByteArray(renamedEntry.getName()), Ldif.encodeEntry(renamedEntry)[1]);
                        }
                        renamedEntries.clear();
                    }
                    return null;
                }

                @Override
                public Void visitRequest(Void p, ModifyRequest change) throws DecodeException {
                    if (entries.get(changeNormDN) == null) {
                        listener.handleRejectedChangeRecord(change, CoreMessages.REJECTED_CHANGE_FAIL_MODIFY.get(change.getName()));
                    } else {
                        Entry entry = Ldif.decodeEntry((byte[])entries.get(changeNormDN));
                        for (Modification modification : change.getModifications()) {
                            ModificationType modType = modification.getModificationType();
                            if (modType.equals(ModificationType.ADD)) {
                                entry.addAttribute(modification.getAttribute(), null);
                                continue;
                            }
                            if (modType.equals(ModificationType.DELETE)) {
                                entry.removeAttribute(modification.getAttribute(), null);
                                continue;
                            }
                            if (modType.equals(ModificationType.REPLACE)) {
                                entry.replaceAttribute(modification.getAttribute());
                                continue;
                            }
                            System.err.println("Unable to apply \"" + modType + "\" modification to entry \"" + change.getName() + "\": modification type not supported");
                        }
                        entries.put(changeNormDN, Ldif.encodeEntry(entry)[1]);
                    }
                    return null;
                }
            }, null);
        }
        return new EntryReader(){
            private final Iterator<byte[]> iterator;
            {
                this.iterator = entries.values().iterator();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    input.close();
                }
                finally {
                    patch.close();
                }
            }

            @Override
            public boolean hasNext() throws IOException {
                return this.iterator.hasNext();
            }

            @Override
            public Entry readEntry() throws IOException {
                return Ldif.decodeEntry(this.iterator.next());
            }
        };
    }

    public static EntryReader search(EntryReader input, SearchRequest search) {
        return Ldif.search(input, search, Schema.getDefaultSchema());
    }

    public static EntryReader search(final EntryReader input, final SearchRequest search, final Schema schema) {
        final Matcher matcher = search.getFilter().matcher(schema);
        return new EntryReader(){
            private Entry nextEntry;
            private int entryCount;

            @Override
            public void close() throws IOException {
                input.close();
            }

            @Override
            public boolean hasNext() throws IOException {
                if (this.nextEntry == null) {
                    int sizeLimit = search.getSizeLimit();
                    if (sizeLimit != 0 && this.entryCount >= sizeLimit) {
                        throw LdapException.newLdapException(ResultCode.SIZE_LIMIT_EXCEEDED);
                    }
                    Dn baseDN = search.getName();
                    SearchScope scope = search.getScope();
                    while (input.hasNext()) {
                        Entry entry = input.readEntry();
                        if (!entry.getName().isInScopeOf(baseDN, scope) || !matcher.matches(entry).toBoolean()) continue;
                        this.nextEntry = this.filterEntry(entry);
                        break;
                    }
                }
                return this.nextEntry != null;
            }

            @Override
            public Entry readEntry() throws IOException {
                if (this.hasNext()) {
                    Entry entry = this.nextEntry;
                    this.nextEntry = null;
                    ++this.entryCount;
                    return entry;
                }
                throw new NoSuchElementException();
            }

            private Entry filterEntry(Entry entry) {
                if (search.getAttributes().isEmpty()) {
                    if (search.isTypesOnly()) {
                        LinkedHashMapEntry filteredEntry = new LinkedHashMapEntry(entry.getName());
                        for (Attribute attribute : entry.getAllAttributes()) {
                            filteredEntry.addAttribute(Attributes.emptyAttribute(attribute.getAttributeDescription()));
                        }
                        return filteredEntry;
                    }
                    return entry;
                }
                LinkedHashMapEntry filteredEntry = new LinkedHashMapEntry(entry.getName());
                for (String atd : search.getAttributes()) {
                    if ("*".equals(atd)) {
                        for (Attribute attribute : entry.getAllAttributes()) {
                            if (attribute.getAttributeDescription().getAttributeType().getUsage() != AttributeUsage.USER_APPLICATIONS) continue;
                            if (search.isTypesOnly()) {
                                filteredEntry.addAttribute(Attributes.emptyAttribute(attribute.getAttributeDescription()));
                                continue;
                            }
                            filteredEntry.addAttribute(attribute);
                        }
                        continue;
                    }
                    if ("+".equals(atd)) {
                        for (Attribute attribute : entry.getAllAttributes()) {
                            if (attribute.getAttributeDescription().getAttributeType().getUsage() == AttributeUsage.USER_APPLICATIONS) continue;
                            if (search.isTypesOnly()) {
                                filteredEntry.addAttribute(Attributes.emptyAttribute(attribute.getAttributeDescription()));
                                continue;
                            }
                            filteredEntry.addAttribute(attribute);
                        }
                        continue;
                    }
                    AttributeDescription ad = AttributeDescription.valueOf(atd, schema);
                    for (Attribute attribute : entry.getAllAttributes(ad)) {
                        if (search.isTypesOnly()) {
                            filteredEntry.addAttribute(Attributes.emptyAttribute(attribute.getAttributeDescription()));
                            continue;
                        }
                        filteredEntry.addAttribute(attribute);
                    }
                }
                return filteredEntry;
            }
        };
    }

    /*
     * Exception decompiling
     */
    public static String toLdif(Entry entry) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static String toLdif(ChangeRecord change) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static List<byte[][]> readEntriesAsList(EntryReader reader) throws IOException {
        ArrayList<byte[][]> entries = new ArrayList<byte[][]>();
        while (reader.hasNext()) {
            Entry entry = reader.readEntry();
            entries.add(Ldif.encodeEntry(entry));
        }
        Collections.sort(entries, DN_ORDER2);
        return entries;
    }

    private static TreeMap<byte[], byte[]> readEntriesAsMap(EntryReader reader) throws IOException {
        TreeMap<byte[], byte[]> entries = new TreeMap<byte[], byte[]>(DN_ORDER);
        while (reader.hasNext()) {
            Entry entry = reader.readEntry();
            byte[][] bEntry = Ldif.encodeEntry(entry);
            entries.put(bEntry[0], bEntry[1]);
        }
        return entries;
    }

    private static Entry decodeEntry(byte[] asn1EntryFormat) {
        try {
            return Ldap.readEntry(Asn1.getReader(asn1EntryFormat), new DecodeOptions());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static byte[] toNormalizedByteArray(Dn dn) {
        return dn.toNormalizedByteString().toByteArray();
    }

    private static byte[][] encodeEntry(Entry entry) {
        byte[][] bEntry = new byte[2][];
        bEntry[0] = Ldif.toNormalizedByteArray(entry.getName());
        try {
            ByteStringBuilder bsb = new ByteStringBuilder();
            Ldap.writeEntry(Asn1.getWriter(bsb), entry);
            bEntry[1] = bsb.toByteArray();
            return bEntry;
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    private Ldif() {
    }

    private static final class EntryIteratorReader
    implements EntryReader {
        private final Iterator<Entry> iterator;

        private EntryIteratorReader(Iterator<Entry> iterator) {
            this.iterator = iterator;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Entry readEntry() {
            return this.iterator.next();
        }
    }
}

