/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.Attributes;
import org.forgerock.opendj.ldap.Ava;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.Entries;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.Rdn;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.CoreSchemaImpl;
import org.forgerock.opendj.ldap.schema.DelayedSchema;
import org.forgerock.opendj.ldap.schema.DitContentRule;
import org.forgerock.opendj.ldap.schema.DitStructureRule;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.MatchingRuleUse;
import org.forgerock.opendj.ldap.schema.NameForm;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.ObjectClassType;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaElement;
import org.forgerock.opendj.ldap.schema.SchemaValidationPolicy;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;
import org.forgerock.util.Function;
import org.forgerock.util.Option;
import org.forgerock.util.Options;
import org.forgerock.util.Reject;

public final class Schema {
    static final String ATTR_ATTRIBUTE_TYPES = "attributeTypes";
    static final String ATTR_DIT_CONTENT_RULES = "dITContentRules";
    static final String ATTR_DIT_STRUCTURE_RULES = "dITStructureRules";
    static final String ATTR_LDAP_SYNTAXES = "ldapSyntaxes";
    static final String ATTR_MATCHING_RULE_USE = "matchingRuleUse";
    static final String ATTR_MATCHING_RULES = "matchingRules";
    static final String ATTR_NAME_FORMS = "nameForms";
    static final String ATTR_OBJECT_CLASSES = "objectClasses";
    private final Impl impl;

    public static Schema getCoreSchema() {
        return CoreSchemaImpl.getInstance();
    }

    public static Schema getDefaultSchema() {
        return DelayedSchema.defaultSchema;
    }

    public static Schema getEmptySchema() {
        return DelayedSchema.EMPTY_SCHEMA;
    }

    public static Schema readSchema(Connection connection, Dn name) throws LdapException {
        return new SchemaBuilder().addSchema(connection, name, true).toSchema();
    }

    public static LdapPromise<Schema> readSchemaAsync(Connection connection, Dn name) {
        SchemaBuilder builder = new SchemaBuilder();
        return builder.addSchemaAsync(connection, name, true).then(new Function<SchemaBuilder, Schema, LdapException>(){

            @Override
            public Schema apply(SchemaBuilder builder) throws LdapException {
                return builder.toSchema();
            }
        });
    }

    public static Schema readSchemaForEntry(Connection connection, Dn name) throws LdapException {
        return new SchemaBuilder().addSchemaForEntry(connection, name, true).toSchema();
    }

    public static LdapPromise<Schema> readSchemaForEntryAsync(Connection connection, Dn name) {
        SchemaBuilder builder = new SchemaBuilder();
        return builder.addSchemaForEntryAsync(connection, name, true).then(new Function<SchemaBuilder, Schema, LdapException>(){

            @Override
            public Schema apply(SchemaBuilder builder) throws LdapException {
                return builder.toSchema();
            }
        });
    }

    public static void setDefaultSchema(Schema schema) {
        Reject.ifNull(schema);
        DelayedSchema.defaultSchema = schema;
    }

    public static Schema valueOf(Entry entry) {
        return new SchemaBuilder(entry).toSchema();
    }

    Schema(Impl impl) {
        this.impl = impl;
    }

    public Schema asNonStrictSchema() {
        return this.impl.asNonStrictSchema();
    }

    public Schema asStrictSchema() {
        return this.impl.asStrictSchema();
    }

    MatchingRule getDefaultMatchingRule() {
        return this.impl.getDefaultMatchingRule();
    }

    Syntax getDefaultSyntax() {
        return this.impl.getDefaultSyntax();
    }

    public AttributeType getAttributeType(String nameOrOid) {
        return this.impl.getAttributeType(this, nameOrOid);
    }

    public AttributeType getAttributeType(String nameOrOid, Syntax syntax) {
        return this.impl.getAttributeType(nameOrOid, syntax);
    }

    public Collection<AttributeType> getAttributeTypes() {
        return this.impl.getAttributeTypes();
    }

    public DitContentRule getDitContentRule(ObjectClass structuralClass) {
        return this.impl.getDitContentRule(structuralClass);
    }

    public DitContentRule getDitContentRule(String nameOrOid) {
        return this.impl.getDitContentRule(nameOrOid);
    }

    public Collection<DitContentRule> getDitContentRules() {
        return this.impl.getDitContentRules();
    }

    public DitStructureRule getDitStructureRule(int ruleId) {
        return this.impl.getDitStructureRule(ruleId);
    }

    public DitStructureRule getDitStructureRule(String nameOrOid) {
        return this.impl.getDitStructureRule(nameOrOid);
    }

    public Collection<DitStructureRule> getDitStructureRules(NameForm nameForm) {
        return this.impl.getDitStructureRules(nameForm);
    }

    public Collection<DitStructureRule> getDitStuctureRules() {
        return this.impl.getDitStuctureRules();
    }

    public MatchingRule getMatchingRule(String nameOrOid) {
        return this.impl.getMatchingRule(nameOrOid);
    }

    public Collection<MatchingRule> getMatchingRules() {
        return this.impl.getMatchingRules();
    }

    public MatchingRuleUse getMatchingRuleUse(MatchingRule matchingRule) {
        return this.getMatchingRuleUse(matchingRule.getOid());
    }

    public MatchingRuleUse getMatchingRuleUse(String nameOrOid) {
        return this.impl.getMatchingRuleUse(nameOrOid);
    }

    public Collection<MatchingRuleUse> getMatchingRuleUses() {
        return this.impl.getMatchingRuleUses();
    }

    public NameForm getNameForm(String nameOrOid) {
        return this.impl.getNameForm(nameOrOid);
    }

    public Collection<NameForm> getNameForms() {
        return this.impl.getNameForms();
    }

    public Collection<NameForm> getNameForms(ObjectClass structuralClass) {
        return this.impl.getNameForms(structuralClass);
    }

    public ObjectClass getObjectClass(String nameOrOid) {
        return this.impl.getObjectClass(nameOrOid);
    }

    public Collection<ObjectClass> getObjectClasses() {
        return this.impl.getObjectClasses();
    }

    public <T> T getOption(Option<T> option) {
        return this.getOptions().get(option);
    }

    Options getOptions() {
        return this.impl.getOptions();
    }

    public String getSchemaName() {
        return this.impl.getSchemaName();
    }

    public Syntax getSyntax(String numericOid) {
        return this.impl.getSyntax(this, numericOid);
    }

    public Collection<Syntax> getSyntaxes() {
        return this.impl.getSyntaxes();
    }

    public Collection<LocalizableMessage> getWarnings() {
        return this.impl.getWarnings();
    }

    public boolean hasAttributeType(String nameOrOid) {
        return this.impl.hasAttributeType(nameOrOid);
    }

    public boolean hasDitContentRule(String nameOrOid) {
        return this.impl.hasDitContentRule(nameOrOid);
    }

    public boolean hasDitStructureRule(int ruleId) {
        return this.impl.hasDitStructureRule(ruleId);
    }

    public boolean hasMatchingRule(String nameOrOid) {
        return this.impl.hasMatchingRule(nameOrOid);
    }

    public boolean hasMatchingRuleUse(String nameOrOid) {
        return this.impl.hasMatchingRuleUse(nameOrOid);
    }

    public boolean hasNameForm(String nameOrOid) {
        return this.impl.hasNameForm(nameOrOid);
    }

    public boolean hasObjectClass(String nameOrOid) {
        return this.impl.hasObjectClass(nameOrOid);
    }

    public boolean hasSyntax(String numericOid) {
        return this.impl.hasSyntax(numericOid);
    }

    public boolean isStrict() {
        return this.impl.isStrict();
    }

    public Entry toEntry(Entry entry) {
        this.addAttribute(entry, ATTR_LDAP_SYNTAXES, this.getSyntaxes());
        this.addAttribute(entry, ATTR_ATTRIBUTE_TYPES, this.getAttributeTypes());
        this.addAttribute(entry, ATTR_OBJECT_CLASSES, this.getObjectClasses());
        this.addAttribute(entry, ATTR_MATCHING_RULE_USE, this.getMatchingRuleUses());
        this.addAttribute(entry, ATTR_MATCHING_RULES, this.getMatchingRules());
        this.addAttribute(entry, ATTR_DIT_CONTENT_RULES, this.getDitContentRules());
        this.addAttribute(entry, ATTR_DIT_STRUCTURE_RULES, this.getDitStuctureRules());
        this.addAttribute(entry, ATTR_NAME_FORMS, this.getNameForms());
        return entry;
    }

    private void addAttribute(Entry entry, String attrName, Collection<? extends SchemaElement> schemaElements) {
        LinkedAttribute attr = new LinkedAttribute(attrName);
        for (SchemaElement schemaElement : schemaElements) {
            attr.add(new Object[]{schemaElement.toString()});
        }
        if (!attr.isEmpty()) {
            entry.addAttribute(attr);
        }
    }

    public boolean validateEntry(Entry entry, SchemaValidationPolicy policy, Collection<LocalizableMessage> errorMessages) {
        ObjectClass structuralObjectClass = null;
        Attribute objectClassAttribute = entry.getAttribute(AttributeDescription.objectClass());
        LinkedList<ObjectClass> objectClasses = new LinkedList<ObjectClass>();
        if (objectClassAttribute != null) {
            for (ByteString v : objectClassAttribute) {
                ObjectClass objectClass;
                String objectClassName = v.toString();
                try {
                    objectClass = this.asStrictSchema().getObjectClass(objectClassName);
                    objectClasses.add(objectClass);
                }
                catch (UnknownSchemaElementException e) {
                    if (!policy.checkAttributesAndObjectClasses().needsChecking()) continue;
                    if (errorMessages != null) {
                        errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_UNKNOWN_OBJECT_CLASS.get(entry.getName(), objectClassName));
                    }
                    if (!policy.checkAttributesAndObjectClasses().isReject()) continue;
                    return false;
                }
                if (objectClass.getObjectClassType() != ObjectClassType.STRUCTURAL) continue;
                if (structuralObjectClass == null || objectClass.isDescendantOf(structuralObjectClass)) {
                    structuralObjectClass = objectClass;
                    continue;
                }
                if (structuralObjectClass.isDescendantOf(objectClass) || !policy.requireSingleStructuralObjectClass().needsChecking()) continue;
                if (errorMessages != null) {
                    errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_MULTIPLE_STRUCTURAL_CLASSES.get(entry.getName(), structuralObjectClass.getNameOrOid(), objectClassName));
                }
                if (!policy.requireSingleStructuralObjectClass().isReject()) continue;
                return false;
            }
        }
        Collection<Object> ditStructureRules = Collections.emptyList();
        DitContentRule ditContentRule = null;
        if (structuralObjectClass == null) {
            if (policy.requireSingleStructuralObjectClass().needsChecking()) {
                if (errorMessages != null) {
                    errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_NO_STRUCTURAL_CLASS.get(entry.getName()));
                }
                if (policy.requireSingleStructuralObjectClass().isReject()) {
                    return false;
                }
            }
        } else {
            ditContentRule = this.getDitContentRule(structuralObjectClass);
            if (ditContentRule != null && ditContentRule.isObsolete()) {
                ditContentRule = null;
            }
        }
        if (!this.checkAttributesAndObjectClasses(entry, policy, errorMessages, objectClasses, ditContentRule)) {
            return false;
        }
        if (policy.checkNameForms().needsChecking() && structuralObjectClass != null) {
            boolean foundMatchingNameForms = false;
            NameForm nameForm = null;
            LinkedList<LocalizableMessage> nameFormWarnings = errorMessages != null ? new LinkedList<LocalizableMessage>() : null;
            for (NameForm nf : this.getNameForms(structuralObjectClass)) {
                if (nf.isObsolete()) continue;
                foundMatchingNameForms = true;
                if (!this.checkNameForm(entry, nameFormWarnings, nf)) continue;
                nameForm = nf;
                break;
            }
            if (foundMatchingNameForms) {
                if (nameForm != null) {
                    ditStructureRules = this.getDitStructureRules(nameForm);
                } else {
                    if (errorMessages != null) {
                        errorMessages.addAll(nameFormWarnings);
                    }
                    if (policy.checkNameForms().isReject()) {
                        return false;
                    }
                }
            }
        }
        if (policy.checkDitStructureRules().needsChecking() && !entry.getName().isRootDn()) {
            boolean foundMatchingRules = false;
            boolean foundValidRule = false;
            LinkedList<LocalizableMessage> ruleWarnings = errorMessages != null ? new LinkedList<LocalizableMessage>() : null;
            ObjectClass parentStructuralObjectClass = null;
            boolean parentEntryHasBeenRead = false;
            for (DitStructureRule rule : ditStructureRules) {
                if (rule.isObsolete()) continue;
                foundMatchingRules = true;
                if (rule.getSuperiorRules().isEmpty()) {
                    foundValidRule = true;
                    break;
                }
                if (!parentEntryHasBeenRead) {
                    parentStructuralObjectClass = this.getParentStructuralObjectClass(entry, policy, ruleWarnings);
                    parentEntryHasBeenRead = true;
                }
                if (parentStructuralObjectClass == null || !this.checkDitStructureRule(entry, ruleWarnings, rule, structuralObjectClass, parentStructuralObjectClass)) continue;
                foundValidRule = true;
                break;
            }
            if (foundMatchingRules) {
                if (!foundValidRule) {
                    if (errorMessages != null) {
                        errorMessages.addAll(ruleWarnings);
                    }
                    if (policy.checkDitStructureRules().isReject()) {
                        return false;
                    }
                }
            } else {
                parentStructuralObjectClass = this.getParentStructuralObjectClass(entry, policy, ruleWarnings);
                if (parentStructuralObjectClass == null) {
                    if (errorMessages != null) {
                        errorMessages.addAll(ruleWarnings);
                    }
                    if (policy.checkDitStructureRules().isReject()) {
                        return false;
                    }
                } else {
                    for (NameForm nf : this.getNameForms(parentStructuralObjectClass)) {
                        if (nf.isObsolete()) continue;
                        for (DitStructureRule rule : this.getDitStructureRules(nf)) {
                            if (rule.isObsolete()) continue;
                            if (errorMessages != null) {
                                errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_DSR_MISSING_DSR.get(entry.getName(), rule.getNameOrRuleId()));
                            }
                            if (!policy.checkDitStructureRules().isReject()) continue;
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    private boolean checkAttributesAndObjectClasses(Entry entry, SchemaValidationPolicy policy, Collection<LocalizableMessage> errorMessages, List<ObjectClass> objectClasses, DitContentRule ditContentRule) {
        boolean checkDITContentRule = policy.checkDitContentRules().needsChecking() && ditContentRule != null;
        boolean checkObjectClasses = policy.checkAttributesAndObjectClasses().needsChecking();
        boolean checkAttributeValues = policy.checkAttributeValues().needsChecking();
        if (checkObjectClasses || checkDITContentRule) {
            for (ObjectClass objectClass : objectClasses) {
                if (checkDITContentRule && objectClass.getObjectClassType() == ObjectClassType.AUXILIARY && !ditContentRule.getAuxiliaryClasses().contains(objectClass)) {
                    if (errorMessages != null) {
                        errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_DCR_PROHIBITED_AUXILIARY_OC.get(entry.getName(), objectClass.getNameOrOid(), ditContentRule.getNameOrOid()));
                    }
                    if (policy.checkDitContentRules().isReject()) {
                        return false;
                    }
                }
                if (!checkObjectClasses) continue;
                for (AttributeType t : objectClass.getDeclaredRequiredAttributes()) {
                    Attribute a = Attributes.emptyAttribute(AttributeDescription.create(t));
                    if (entry.containsAttribute(a, null)) continue;
                    if (errorMessages != null) {
                        errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_OC_MISSING_MUST_ATTRIBUTES.get(entry.getName(), t.getNameOrOid(), objectClass.getNameOrOid()));
                    }
                    if (!policy.checkAttributesAndObjectClasses().isReject()) continue;
                    return false;
                }
            }
            if (checkDITContentRule) {
                Attribute a;
                for (AttributeType t : ditContentRule.getRequiredAttributes()) {
                    a = Attributes.emptyAttribute(AttributeDescription.create(t));
                    if (entry.containsAttribute(a, null)) continue;
                    if (errorMessages != null) {
                        errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_DCR_MISSING_MUST_ATTRIBUTES.get(entry.getName(), t.getNameOrOid(), ditContentRule.getNameOrOid()));
                    }
                    if (!policy.checkDitContentRules().isReject()) continue;
                    return false;
                }
                for (AttributeType t : ditContentRule.getProhibitedAttributes()) {
                    a = Attributes.emptyAttribute(AttributeDescription.create(t));
                    if (!entry.containsAttribute(a, null)) continue;
                    if (errorMessages != null) {
                        errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_DCR_PROHIBITED_ATTRIBUTES.get(entry.getName(), t.getNameOrOid(), ditContentRule.getNameOrOid()));
                    }
                    if (!policy.checkDitContentRules().isReject()) continue;
                    return false;
                }
            }
        }
        if (checkObjectClasses || checkDITContentRule || checkAttributeValues) {
            for (Attribute attribute : entry.getAllAttributes()) {
                AttributeType t = attribute.getAttributeDescription().getAttributeType();
                if (!t.isOperational() && (checkObjectClasses || checkDITContentRule)) {
                    boolean isAllowed = this.isRequiredOrOptional(objectClasses, t);
                    if (!isAllowed && ditContentRule != null && ditContentRule.isRequiredOrOptional(t)) {
                        isAllowed = true;
                    }
                    if (!isAllowed) {
                        if (errorMessages != null) {
                            LocalizableMessage message = ditContentRule != null ? CoreMessages.ERR_ENTRY_SCHEMA_DCR_DISALLOWED_ATTRIBUTES.get(entry.getName(), t.getNameOrOid(), ditContentRule.getNameOrOid()) : CoreMessages.ERR_ENTRY_SCHEMA_OC_DISALLOWED_ATTRIBUTES.get(entry.getName(), t.getNameOrOid());
                            errorMessages.add(message);
                        }
                        if (policy.checkAttributesAndObjectClasses().isReject() || policy.checkDitContentRules().isReject()) {
                            return false;
                        }
                    }
                }
                if (!checkAttributeValues) continue;
                int sz = attribute.size();
                if (sz == 0) {
                    if (errorMessages != null) {
                        errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_AT_EMPTY_ATTRIBUTE.get(entry.getName(), t.getNameOrOid()));
                    }
                    if (!policy.checkAttributeValues().isReject()) continue;
                    return false;
                }
                if (sz <= 1 || !t.isSingleValue()) continue;
                if (errorMessages != null) {
                    errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_AT_SINGLE_VALUED_ATTRIBUTE.get(entry.getName(), t.getNameOrOid()));
                }
                if (!policy.checkAttributeValues().isReject()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isRequiredOrOptional(List<ObjectClass> objectClasses, AttributeType t) {
        for (ObjectClass objectClass : objectClasses) {
            if (!objectClass.isRequiredOrOptional(t)) continue;
            return true;
        }
        return false;
    }

    private boolean checkDitStructureRule(Entry entry, List<LocalizableMessage> ruleWarnings, DitStructureRule rule, ObjectClass structuralObjectClass, ObjectClass parentStructuralObjectClass) {
        boolean matchFound = false;
        for (DitStructureRule parentRule : rule.getSuperiorRules()) {
            if (!parentRule.getNameForm().getStructuralClass().equals(parentStructuralObjectClass)) continue;
            matchFound = true;
        }
        if (!matchFound) {
            if (ruleWarnings != null) {
                ruleWarnings.add(CoreMessages.ERR_ENTRY_SCHEMA_DSR_ILLEGAL_OC.get(entry.getName(), rule.getNameOrRuleId(), structuralObjectClass.getNameOrOid(), parentStructuralObjectClass.getNameOrOid()));
            }
            return false;
        }
        return true;
    }

    private boolean checkNameForm(Entry entry, List<LocalizableMessage> nameFormWarnings, NameForm nameForm) {
        Rdn rdn = entry.getName().rdn();
        if (rdn != null) {
            for (AttributeType t : nameForm.getRequiredAttributes()) {
                if (rdn.getAttributeValue(t) != null) continue;
                if (nameFormWarnings != null) {
                    nameFormWarnings.add(CoreMessages.ERR_ENTRY_SCHEMA_NF_MISSING_MUST_ATTRIBUTES.get(entry.getName(), t.getNameOrOid(), nameForm.getNameOrOid()));
                }
                return false;
            }
            for (Ava ava : rdn) {
                AttributeType t = ava.getAttributeType();
                if (nameForm.isRequiredOrOptional(t)) continue;
                if (nameFormWarnings != null) {
                    nameFormWarnings.add(CoreMessages.ERR_ENTRY_SCHEMA_NF_DISALLOWED_ATTRIBUTES.get(entry.getName(), t.getNameOrOid(), nameForm.getNameOrOid()));
                }
                return false;
            }
        }
        return true;
    }

    private ObjectClass getParentStructuralObjectClass(Entry entry, SchemaValidationPolicy policy, List<LocalizableMessage> ruleWarnings) {
        Entry parentEntry;
        try {
            parentEntry = policy.checkDitStructureRulesEntryResolver().getEntry(entry.getName().parent());
        }
        catch (LdapException e) {
            if (ruleWarnings != null) {
                ruleWarnings.add(CoreMessages.ERR_ENTRY_SCHEMA_DSR_PARENT_NOT_FOUND.get(entry.getName(), e.getResult().getDiagnosticMessage()));
            }
            return null;
        }
        ObjectClass parentStructuralObjectClass = Entries.getStructuralObjectClass(parentEntry, this);
        if (parentStructuralObjectClass == null) {
            if (ruleWarnings != null) {
                ruleWarnings.add(CoreMessages.ERR_ENTRY_SCHEMA_DSR_NO_PARENT_OC.get(entry.getName()));
            }
            return null;
        }
        return parentStructuralObjectClass;
    }

    public String toString() {
        return "Schema " + this.getSchemaName() + " mr=" + this.getMatchingRules().size() + " syntaxes=" + this.getSyntaxes().size() + " at=" + this.getAttributeTypes().size();
    }

    static final class StrictImpl
    implements Impl {
        private final Map<Integer, DitStructureRule> id2StructureRules;
        private final Map<String, AttributeType> name2AttributeTypes;
        private final Map<String, DitContentRule> name2ContentRules;
        private final Map<String, MatchingRule> name2MatchingRules;
        private final Map<String, MatchingRuleUse> name2MatchingRuleUses;
        private final Map<String, NameForm> name2NameForms;
        private final Map<String, ObjectClass> name2ObjectClasses;
        private final Map<String, DitStructureRule> name2StructureRules;
        private final Map<String, List<DitStructureRule>> nameForm2StructureRules;
        private final Map<String, AttributeType> numericOid2AttributeTypes;
        private final Map<String, DitContentRule> numericOid2ContentRules;
        private final Map<String, MatchingRule> numericOid2MatchingRules;
        private final Map<String, MatchingRuleUse> numericOid2MatchingRuleUses;
        private final Map<String, NameForm> numericOid2NameForms;
        private final Map<String, ObjectClass> numericOid2ObjectClasses;
        private final Map<String, Syntax> numericOid2Syntaxes;
        private final Map<String, List<NameForm>> objectClass2NameForms;
        private final List<LocalizableMessage> warnings;
        private final String schemaName;
        private final Options options;
        private final Syntax defaultSyntax;
        private final MatchingRule defaultMatchingRule;
        private final Schema strictSchema;
        private final Schema nonStrictSchema;

        StrictImpl(String schemaName, Options options, Syntax defaultSyntax, MatchingRule defaultMatchingRule, Map<String, Syntax> numericOid2Syntaxes, Map<String, MatchingRule> numericOid2MatchingRules, Map<String, MatchingRuleUse> numericOid2MatchingRuleUses, Map<String, AttributeType> numericOid2AttributeTypes, Map<String, ObjectClass> numericOid2ObjectClasses, Map<String, NameForm> numericOid2NameForms, Map<String, DitContentRule> numericOid2ContentRules, Map<Integer, DitStructureRule> id2StructureRules, Map<String, MatchingRule> name2MatchingRules, Map<String, MatchingRuleUse> name2MatchingRuleUses, Map<String, AttributeType> name2AttributeTypes, Map<String, ObjectClass> name2ObjectClasses, Map<String, NameForm> name2NameForms, Map<String, DitContentRule> name2ContentRules, Map<String, DitStructureRule> name2StructureRules, Map<String, List<NameForm>> objectClass2NameForms, Map<String, List<DitStructureRule>> nameForm2StructureRules, List<LocalizableMessage> warnings) {
            this.schemaName = schemaName;
            this.options = options;
            this.defaultSyntax = defaultSyntax;
            this.defaultMatchingRule = defaultMatchingRule;
            this.numericOid2Syntaxes = Collections.unmodifiableMap(numericOid2Syntaxes);
            this.numericOid2MatchingRules = Collections.unmodifiableMap(numericOid2MatchingRules);
            this.numericOid2MatchingRuleUses = Collections.unmodifiableMap(numericOid2MatchingRuleUses);
            this.numericOid2AttributeTypes = Collections.unmodifiableMap(numericOid2AttributeTypes);
            this.numericOid2ObjectClasses = Collections.unmodifiableMap(numericOid2ObjectClasses);
            this.numericOid2NameForms = Collections.unmodifiableMap(numericOid2NameForms);
            this.numericOid2ContentRules = Collections.unmodifiableMap(numericOid2ContentRules);
            this.id2StructureRules = Collections.unmodifiableMap(id2StructureRules);
            this.name2MatchingRules = Collections.unmodifiableMap(name2MatchingRules);
            this.name2MatchingRuleUses = Collections.unmodifiableMap(name2MatchingRuleUses);
            this.name2AttributeTypes = Collections.unmodifiableMap(name2AttributeTypes);
            this.name2ObjectClasses = Collections.unmodifiableMap(name2ObjectClasses);
            this.name2NameForms = Collections.unmodifiableMap(name2NameForms);
            this.name2ContentRules = Collections.unmodifiableMap(name2ContentRules);
            this.name2StructureRules = Collections.unmodifiableMap(name2StructureRules);
            this.objectClass2NameForms = Collections.unmodifiableMap(objectClass2NameForms);
            this.nameForm2StructureRules = Collections.unmodifiableMap(nameForm2StructureRules);
            this.warnings = Collections.unmodifiableList(warnings);
            this.strictSchema = new Schema(this);
            this.nonStrictSchema = new Schema(new NonStrictImpl(this));
        }

        @Override
        public Schema asNonStrictSchema() {
            return this.nonStrictSchema;
        }

        @Override
        public Schema asStrictSchema() {
            return this.strictSchema;
        }

        @Override
        public Options getOptions() {
            return this.options;
        }

        @Override
        public Syntax getDefaultSyntax() {
            return this.defaultSyntax;
        }

        @Override
        public MatchingRule getDefaultMatchingRule() {
            return this.defaultMatchingRule;
        }

        @Override
        public AttributeType getAttributeType(String nameOrOid, Syntax syntax) {
            return this.getAttributeType(null, nameOrOid);
        }

        @Override
        public AttributeType getAttributeType(Schema schema, String nameOrOid) {
            AttributeType type = this.getAttributeType0(nameOrOid);
            if (type != null) {
                return type;
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_ATTR_TYPE_UNKNOWN.get(nameOrOid));
        }

        @Override
        public Collection<AttributeType> getAttributeTypes() {
            return this.numericOid2AttributeTypes.values();
        }

        @Override
        public DitContentRule getDitContentRule(ObjectClass structuralClass) {
            return this.numericOid2ContentRules.get(structuralClass.getOid());
        }

        @Override
        public DitContentRule getDitContentRule(String nameOrOid) {
            DitContentRule rule = this.numericOid2ContentRules.get(nameOrOid);
            if (rule != null) {
                return rule;
            }
            DitContentRule rule2 = this.name2ContentRules.get(StaticUtils.toLowerCase(nameOrOid));
            if (rule2 != null) {
                return rule2;
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_DCR_UNKNOWN.get(nameOrOid));
        }

        @Override
        public Collection<DitContentRule> getDitContentRules() {
            return this.numericOid2ContentRules.values();
        }

        @Override
        public DitStructureRule getDitStructureRule(int ruleId) {
            DitStructureRule rule = this.id2StructureRules.get(ruleId);
            if (rule == null) {
                throw new UnknownSchemaElementException(CoreMessages.WARN_DSR_UNKNOWN.get(String.valueOf(ruleId)));
            }
            return rule;
        }

        @Override
        public Collection<DitStructureRule> getDitStructureRules(NameForm nameForm) {
            List<DitStructureRule> rules = this.nameForm2StructureRules.get(nameForm.getOid());
            if (rules != null) {
                return rules;
            }
            return Collections.emptyList();
        }

        @Override
        public DitStructureRule getDitStructureRule(String name) {
            DitStructureRule rule = this.name2StructureRules.get(StaticUtils.toLowerCase(name));
            if (rule != null) {
                return rule;
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_DIT_SR_UNKNOWN.get(name));
        }

        @Override
        public Collection<DitStructureRule> getDitStuctureRules() {
            return this.id2StructureRules.values();
        }

        @Override
        public MatchingRule getMatchingRule(String nameOrOid) {
            MatchingRule rule = this.numericOid2MatchingRules.get(nameOrOid);
            if (rule != null) {
                return rule;
            }
            MatchingRule rule2 = this.name2MatchingRules.get(StaticUtils.toLowerCase(nameOrOid));
            if (rule2 != null) {
                return rule2;
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_MR_UNKNOWN.get(nameOrOid));
        }

        @Override
        public Collection<MatchingRule> getMatchingRules() {
            return this.numericOid2MatchingRules.values();
        }

        @Override
        public MatchingRuleUse getMatchingRuleUse(MatchingRule matchingRule) {
            return this.numericOid2MatchingRuleUses.get(matchingRule.getOid());
        }

        @Override
        public MatchingRuleUse getMatchingRuleUse(String nameOrOid) {
            MatchingRuleUse use = this.numericOid2MatchingRuleUses.get(nameOrOid);
            if (use != null) {
                return use;
            }
            MatchingRuleUse use2 = this.name2MatchingRuleUses.get(StaticUtils.toLowerCase(nameOrOid));
            if (use2 != null) {
                return use2;
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_MRU_UNKNOWN.get(nameOrOid));
        }

        @Override
        public Collection<MatchingRuleUse> getMatchingRuleUses() {
            return this.numericOid2MatchingRuleUses.values();
        }

        @Override
        public NameForm getNameForm(String nameOrOid) {
            NameForm form = this.numericOid2NameForms.get(nameOrOid);
            if (form != null) {
                return form;
            }
            NameForm form2 = this.name2NameForms.get(StaticUtils.toLowerCase(nameOrOid));
            if (form2 != null) {
                return form2;
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_NAMEFORM_UNKNOWN.get(nameOrOid));
        }

        @Override
        public Collection<NameForm> getNameForms() {
            return this.numericOid2NameForms.values();
        }

        @Override
        public Collection<NameForm> getNameForms(ObjectClass structuralClass) {
            List<NameForm> forms = this.objectClass2NameForms.get(structuralClass.getOid());
            if (forms != null) {
                return forms;
            }
            return Collections.emptyList();
        }

        @Override
        public ObjectClass getObjectClass(String nameOrOid) {
            ObjectClass result = this.getObjectClass0(nameOrOid);
            if (result != null) {
                return result;
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_OBJECTCLASS_UNKNOWN.get(nameOrOid));
        }

        private ObjectClass getObjectClass0(String nameOrOid) {
            ObjectClass oc = this.numericOid2ObjectClasses.get(nameOrOid);
            if (oc != null) {
                return oc;
            }
            ObjectClass oc2 = this.name2ObjectClasses.get(StaticUtils.toLowerCase(nameOrOid));
            if (oc2 != null) {
                return oc2;
            }
            return null;
        }

        @Override
        public Collection<ObjectClass> getObjectClasses() {
            return this.numericOid2ObjectClasses.values();
        }

        @Override
        public String getSchemaName() {
            return this.schemaName;
        }

        @Override
        public Syntax getSyntax(Schema schema, String numericOid) {
            Syntax syntax = this.numericOid2Syntaxes.get(numericOid);
            if (syntax == null) {
                throw new UnknownSchemaElementException(CoreMessages.WARN_SYNTAX_UNKNOWN.get(numericOid));
            }
            return syntax;
        }

        @Override
        public Collection<Syntax> getSyntaxes() {
            return this.numericOid2Syntaxes.values();
        }

        @Override
        public Collection<LocalizableMessage> getWarnings() {
            return this.warnings;
        }

        @Override
        public boolean hasAttributeType(String nameOrOid) {
            return this.numericOid2AttributeTypes.containsKey(nameOrOid) || this.name2AttributeTypes.containsKey(StaticUtils.toLowerCase(nameOrOid));
        }

        @Override
        public boolean hasDitContentRule(String nameOrOid) {
            return this.numericOid2ContentRules.containsKey(nameOrOid) || this.name2ContentRules.containsKey(StaticUtils.toLowerCase(nameOrOid));
        }

        @Override
        public boolean hasDitStructureRule(int ruleId) {
            return this.id2StructureRules.containsKey(ruleId);
        }

        @Override
        public boolean hasMatchingRule(String nameOrOid) {
            return this.numericOid2MatchingRules.containsKey(nameOrOid) || this.name2MatchingRules.containsKey(StaticUtils.toLowerCase(nameOrOid));
        }

        @Override
        public boolean hasMatchingRuleUse(String nameOrOid) {
            return this.numericOid2MatchingRuleUses.containsKey(nameOrOid) || this.name2MatchingRuleUses.containsKey(StaticUtils.toLowerCase(nameOrOid));
        }

        @Override
        public boolean hasNameForm(String nameOrOid) {
            return this.numericOid2NameForms.containsKey(nameOrOid) || this.name2NameForms.containsKey(StaticUtils.toLowerCase(nameOrOid));
        }

        @Override
        public boolean hasObjectClass(String nameOrOid) {
            return this.numericOid2ObjectClasses.containsKey(nameOrOid) || this.name2ObjectClasses.containsKey(StaticUtils.toLowerCase(nameOrOid));
        }

        @Override
        public boolean hasSyntax(String numericOid) {
            return this.numericOid2Syntaxes.containsKey(numericOid);
        }

        @Override
        public boolean isStrict() {
            return true;
        }

        AttributeType getAttributeType0(String nameOrOid) {
            AttributeType type = this.numericOid2AttributeTypes.get(nameOrOid);
            if (type != null) {
                return type;
            }
            return this.name2AttributeTypes.get(StaticUtils.toLowerCase(nameOrOid));
        }
    }

    private static final class NonStrictImpl
    implements Impl {
        private final StrictImpl strictImpl;

        private NonStrictImpl(StrictImpl strictImpl) {
            this.strictImpl = strictImpl;
        }

        @Override
        public Schema asNonStrictSchema() {
            return this.strictImpl.asNonStrictSchema();
        }

        @Override
        public Schema asStrictSchema() {
            return this.strictImpl.asStrictSchema();
        }

        @Override
        public Options getOptions() {
            return this.strictImpl.getOptions();
        }

        @Override
        public Syntax getDefaultSyntax() {
            return this.strictImpl.getDefaultSyntax();
        }

        @Override
        public MatchingRule getDefaultMatchingRule() {
            return this.strictImpl.getDefaultMatchingRule();
        }

        @Override
        public AttributeType getAttributeType(Schema schema, String nameOrOid) {
            return this.getAttributeType0(nameOrOid, schema.getDefaultSyntax(), schema.getDefaultMatchingRule());
        }

        @Override
        public AttributeType getAttributeType(String nameOrOid, Syntax syntax) {
            return this.getAttributeType0(nameOrOid, syntax, syntax.getEqualityMatchingRule());
        }

        private AttributeType getAttributeType0(String nameOrOid, Syntax syntax, MatchingRule equalityMatchingRule) {
            AttributeType type = this.strictImpl.getAttributeType0(nameOrOid);
            return type != null ? type : AttributeType.newPlaceHolder(nameOrOid, syntax, equalityMatchingRule);
        }

        @Override
        public Collection<AttributeType> getAttributeTypes() {
            return this.strictImpl.getAttributeTypes();
        }

        @Override
        public DitContentRule getDitContentRule(ObjectClass structuralClass) {
            return this.strictImpl.getDitContentRule(structuralClass);
        }

        @Override
        public DitContentRule getDitContentRule(String nameOrOid) {
            return this.strictImpl.getDitContentRule(nameOrOid);
        }

        @Override
        public Collection<DitContentRule> getDitContentRules() {
            return this.strictImpl.getDitContentRules();
        }

        @Override
        public DitStructureRule getDitStructureRule(int ruleId) {
            return this.strictImpl.getDitStructureRule(ruleId);
        }

        @Override
        public DitStructureRule getDitStructureRule(String name) {
            return this.strictImpl.getDitStructureRule(name);
        }

        @Override
        public Collection<DitStructureRule> getDitStructureRules(NameForm nameForm) {
            return this.strictImpl.getDitStructureRules(nameForm);
        }

        @Override
        public Collection<DitStructureRule> getDitStuctureRules() {
            return this.strictImpl.getDitStuctureRules();
        }

        @Override
        public MatchingRule getMatchingRule(String nameOrOid) {
            return this.strictImpl.getMatchingRule(nameOrOid);
        }

        @Override
        public Collection<MatchingRule> getMatchingRules() {
            return this.strictImpl.getMatchingRules();
        }

        @Override
        public MatchingRuleUse getMatchingRuleUse(MatchingRule matchingRule) {
            return this.strictImpl.getMatchingRuleUse(matchingRule);
        }

        @Override
        public MatchingRuleUse getMatchingRuleUse(String nameOrOid) {
            return this.strictImpl.getMatchingRuleUse(nameOrOid);
        }

        @Override
        public Collection<MatchingRuleUse> getMatchingRuleUses() {
            return this.strictImpl.getMatchingRuleUses();
        }

        @Override
        public NameForm getNameForm(String nameOrOid) {
            return this.strictImpl.getNameForm(nameOrOid);
        }

        @Override
        public Collection<NameForm> getNameForms() {
            return this.strictImpl.getNameForms();
        }

        @Override
        public Collection<NameForm> getNameForms(ObjectClass structuralClass) {
            return this.strictImpl.getNameForms(structuralClass);
        }

        @Override
        public ObjectClass getObjectClass(String nameOrOid) {
            ObjectClass result = this.strictImpl.getObjectClass0(nameOrOid);
            return result != null ? result : ObjectClass.newPlaceHolder(nameOrOid);
        }

        @Override
        public Collection<ObjectClass> getObjectClasses() {
            return this.strictImpl.getObjectClasses();
        }

        @Override
        public String getSchemaName() {
            return this.strictImpl.getSchemaName();
        }

        @Override
        public Syntax getSyntax(Schema schema, String numericOid) {
            if (!this.strictImpl.hasSyntax(numericOid)) {
                return new Syntax(schema, numericOid);
            }
            return this.strictImpl.getSyntax(schema, numericOid);
        }

        @Override
        public Collection<Syntax> getSyntaxes() {
            return this.strictImpl.getSyntaxes();
        }

        @Override
        public Collection<LocalizableMessage> getWarnings() {
            return this.strictImpl.getWarnings();
        }

        @Override
        public boolean hasAttributeType(String nameOrOid) {
            return this.strictImpl.hasAttributeType(nameOrOid);
        }

        @Override
        public boolean hasDitContentRule(String nameOrOid) {
            return this.strictImpl.hasDitContentRule(nameOrOid);
        }

        @Override
        public boolean hasDitStructureRule(int ruleId) {
            return this.strictImpl.hasDitStructureRule(ruleId);
        }

        @Override
        public boolean hasMatchingRule(String nameOrOid) {
            return this.strictImpl.hasMatchingRule(nameOrOid);
        }

        @Override
        public boolean hasMatchingRuleUse(String nameOrOid) {
            return this.strictImpl.hasMatchingRuleUse(nameOrOid);
        }

        @Override
        public boolean hasNameForm(String nameOrOid) {
            return this.strictImpl.hasNameForm(nameOrOid);
        }

        @Override
        public boolean hasObjectClass(String nameOrOid) {
            return this.strictImpl.hasObjectClass(nameOrOid);
        }

        @Override
        public boolean hasSyntax(String numericOid) {
            return this.strictImpl.hasSyntax(numericOid);
        }

        @Override
        public boolean isStrict() {
            return false;
        }
    }

    private static interface Impl {
        public Schema asNonStrictSchema();

        public Schema asStrictSchema();

        public Options getOptions();

        public MatchingRule getDefaultMatchingRule();

        public Syntax getDefaultSyntax();

        public AttributeType getAttributeType(Schema var1, String var2);

        public AttributeType getAttributeType(String var1, Syntax var2);

        public Collection<AttributeType> getAttributeTypes();

        public DitContentRule getDitContentRule(ObjectClass var1);

        public DitContentRule getDitContentRule(String var1);

        public Collection<DitContentRule> getDitContentRules();

        public DitStructureRule getDitStructureRule(int var1);

        public DitStructureRule getDitStructureRule(String var1);

        public Collection<DitStructureRule> getDitStructureRules(NameForm var1);

        public Collection<DitStructureRule> getDitStuctureRules();

        public MatchingRule getMatchingRule(String var1);

        public Collection<MatchingRule> getMatchingRules();

        public MatchingRuleUse getMatchingRuleUse(MatchingRule var1);

        public MatchingRuleUse getMatchingRuleUse(String var1);

        public Collection<MatchingRuleUse> getMatchingRuleUses();

        public NameForm getNameForm(String var1);

        public Collection<NameForm> getNameForms();

        public Collection<NameForm> getNameForms(ObjectClass var1);

        public ObjectClass getObjectClass(String var1);

        public Collection<ObjectClass> getObjectClasses();

        public String getSchemaName();

        public Syntax getSyntax(Schema var1, String var2);

        public Collection<Syntax> getSyntaxes();

        public Collection<LocalizableMessage> getWarnings();

        public boolean hasAttributeType(String var1);

        public boolean hasDitContentRule(String var1);

        public boolean hasDitStructureRule(int var1);

        public boolean hasMatchingRule(String var1);

        public boolean hasMatchingRuleUse(String var1);

        public boolean hasNameForm(String var1);

        public boolean hasObjectClass(String var1);

        public boolean hasSyntax(String var1);

        public boolean isStrict();
    }
}

