/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.AbstractOrderingMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.AbstractSubstringMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.MatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.spi.IndexQueryFactory;
import org.forgerock.opendj.ldap.spi.Indexer;
import org.forgerock.opendj.ldap.spi.IndexingOptions;

final class CollationMatchingRulesImpl {
    private static final String INDEX_ID_SHARED = "shared";
    private static final String INDEX_ID_SUBSTRING = "substring";

    private CollationMatchingRulesImpl() {
    }

    static MatchingRuleImpl collationEqualityMatchingRule(Locale locale) {
        return new CollationEqualityMatchingRuleImpl(locale);
    }

    static MatchingRuleImpl collationSubstringMatchingRule(Locale locale) {
        return new CollationSubstringMatchingRuleImpl(locale);
    }

    static MatchingRuleImpl collationLessThanMatchingRule(Locale locale) {
        return new CollationLessThanMatchingRuleImpl(locale);
    }

    static MatchingRuleImpl collationLessThanOrEqualMatchingRule(Locale locale) {
        return new CollationLessThanOrEqualToMatchingRuleImpl(locale);
    }

    static MatchingRuleImpl collationGreaterThanMatchingRule(Locale locale) {
        return new CollationGreaterThanMatchingRuleImpl(locale);
    }

    static MatchingRuleImpl collationGreaterThanOrEqualToMatchingRule(Locale locale) {
        return new CollationGreaterThanOrEqualToMatchingRuleImpl(locale);
    }

    private static final class CollationGreaterThanOrEqualToMatchingRuleImpl
    extends CollationOrderingMatchingRuleImpl {
        CollationGreaterThanOrEqualToMatchingRuleImpl(Locale locale) {
            super(locale);
        }

        @Override
        public Assertion getAssertion(Schema schema, ByteSequence assertionValue) throws DecodeException {
            return this.orderingMatchingRule.getGreaterOrEqualAssertion(schema, assertionValue);
        }
    }

    private static final class CollationGreaterThanMatchingRuleImpl
    extends CollationOrderingMatchingRuleImpl {
        CollationGreaterThanMatchingRuleImpl(Locale locale) {
            super(locale);
        }

        @Override
        public Assertion getAssertion(Schema schema, ByteSequence assertionValue) throws DecodeException {
            final ByteString normAssertion = this.normalizeAttributeValue(schema, assertionValue);
            return new Assertion(){

                @Override
                public ConditionResult matches(ByteSequence attributeValue) {
                    return ConditionResult.valueOf(attributeValue.compareTo(normAssertion) > 0);
                }

                @Override
                public <T> T createIndexQuery(IndexQueryFactory<T> factory) throws DecodeException {
                    return factory.createRangeMatchQuery(CollationGreaterThanMatchingRuleImpl.this.indexName, normAssertion, ByteString.empty(), false, false);
                }
            };
        }
    }

    private static final class CollationLessThanOrEqualToMatchingRuleImpl
    extends CollationOrderingMatchingRuleImpl {
        CollationLessThanOrEqualToMatchingRuleImpl(Locale locale) {
            super(locale);
        }

        @Override
        public Assertion getAssertion(Schema schema, ByteSequence assertionValue) throws DecodeException {
            return this.orderingMatchingRule.getLessOrEqualAssertion(schema, assertionValue);
        }
    }

    private static final class CollationLessThanMatchingRuleImpl
    extends CollationOrderingMatchingRuleImpl {
        CollationLessThanMatchingRuleImpl(Locale locale) {
            super(locale);
        }

        @Override
        public Assertion getAssertion(Schema schema, ByteSequence assertionValue) throws DecodeException {
            return this.orderingMatchingRule.getAssertion(schema, assertionValue);
        }
    }

    private static abstract class CollationOrderingMatchingRuleImpl
    extends AbstractCollationMatchingRuleImpl {
        final AbstractOrderingMatchingRuleImpl orderingMatchingRule;

        CollationOrderingMatchingRuleImpl(Locale locale) {
            super(locale);
            this.orderingMatchingRule = new AbstractOrderingMatchingRuleImpl(this.indexName){

                @Override
                public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
                    return CollationOrderingMatchingRuleImpl.this.normalizeAttributeValue(schema, value);
                }
            };
        }
    }

    private static final class CollationSubstringMatchingRuleImpl
    extends AbstractCollationMatchingRuleImpl {
        private final AbstractSubstringMatchingRuleImpl substringMatchingRule;

        CollationSubstringMatchingRuleImpl(Locale locale) {
            super(locale);
            this.substringMatchingRule = new AbstractSubstringMatchingRuleImpl(this.getPrefixIndexName() + "." + CollationMatchingRulesImpl.INDEX_ID_SUBSTRING, this.indexName){

                @Override
                public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
                    return CollationSubstringMatchingRuleImpl.this.normalizeAttributeValue(schema, value);
                }
            };
        }

        @Override
        public Assertion getAssertion(Schema schema, ByteSequence assertionValue) throws DecodeException {
            return this.substringMatchingRule.getAssertion(schema, assertionValue);
        }

        @Override
        public Assertion getSubstringAssertion(Schema schema, ByteSequence subInitial, List<? extends ByteSequence> subAnyElements, ByteSequence subFinal) throws DecodeException {
            return this.substringMatchingRule.getSubstringAssertion(schema, subInitial, subAnyElements, subFinal);
        }

        @Override
        public final Collection<? extends Indexer> createIndexers(IndexingOptions options) {
            ArrayList<? extends Indexer> indexers = new ArrayList<Indexer>(this.substringMatchingRule.createIndexers(options));
            indexers.add(this.indexer);
            return indexers;
        }
    }

    private static final class CollationEqualityMatchingRuleImpl
    extends AbstractCollationMatchingRuleImpl {
        CollationEqualityMatchingRuleImpl(Locale locale) {
            super(locale);
        }

        @Override
        public Assertion getAssertion(Schema schema, ByteSequence assertionValue) throws DecodeException {
            return CollationEqualityMatchingRuleImpl.named(this.indexName, this.normalizeAttributeValue(schema, assertionValue));
        }
    }

    private static abstract class AbstractCollationMatchingRuleImpl
    extends AbstractMatchingRuleImpl {
        private final Locale locale;
        final Collator collator;
        final String indexName;
        final Indexer indexer;

        AbstractCollationMatchingRuleImpl(Locale locale) {
            this.locale = locale;
            this.collator = this.createCollator(locale);
            this.indexName = this.getPrefixIndexName() + "." + CollationMatchingRulesImpl.INDEX_ID_SHARED;
            this.indexer = new AbstractMatchingRuleImpl.DefaultIndexer(this.indexName);
        }

        private Collator createCollator(Locale locale) {
            Collator collator = Collator.getInstance(locale);
            collator.setStrength(0);
            collator.setDecomposition(2);
            return collator;
        }

        String getPrefixIndexName() {
            String language = this.locale.getLanguage();
            String country = this.locale.getCountry();
            String variant = this.locale.getVariant();
            StringBuilder builder = new StringBuilder(language);
            if (country != null && country.length() > 0) {
                builder.append("_");
                builder.append(country);
            }
            if (variant != null && variant.length() > 0) {
                builder.append("_");
                builder.append(variant);
            }
            return builder.toString();
        }

        @Override
        public Collection<? extends Indexer> createIndexers(IndexingOptions options) {
            return Collections.singletonList(this.indexer);
        }

        @Override
        public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
            try {
                byte[] byteArray = this.collator.getCollationKey(value.toString()).toByteArray();
                return ByteString.wrap(byteArray).subSequence(0, byteArray.length - 4);
            }
            catch (LocalizedIllegalArgumentException e) {
                throw DecodeException.error(e.getMessageObject());
            }
        }
    }
}

