/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.AuthPasswordSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class AuthPasswordExactEqualityMatchingRuleImpl
extends AbstractEqualityMatchingRuleImpl {
    AuthPasswordExactEqualityMatchingRuleImpl() {
        super("authPasswordExactMatch");
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        String[] authPWComponents = AuthPasswordSyntaxImpl.decodeAuthPassword(value.toString());
        StringBuilder normalizedValue = new StringBuilder(2 + authPWComponents[0].length() + authPWComponents[1].length() + authPWComponents[2].length());
        normalizedValue.append(authPWComponents[0]);
        normalizedValue.append('$');
        normalizedValue.append(authPWComponents[1]);
        normalizedValue.append('$');
        normalizedValue.append(authPWComponents[2]);
        return ByteString.valueOfUtf8(normalizedValue);
    }
}

