/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.ReferenceCountedObject;
import com.forgerock.opendj.util.StaticUtils;
import java.io.Closeable;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.AbstractAsynchronousConnection;
import org.forgerock.opendj.ldap.CancelledResultException;
import org.forgerock.opendj.ldap.CommonLdapOptions;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.ConnectionException;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.LdapResultHandler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.SslOptions;
import org.forgerock.opendj.ldap.TimeoutResultException;
import org.forgerock.opendj.ldap.messages.AbandonRequest;
import org.forgerock.opendj.ldap.messages.AddRequest;
import org.forgerock.opendj.ldap.messages.BindRequest;
import org.forgerock.opendj.ldap.messages.BindResult;
import org.forgerock.opendj.ldap.messages.CompareRequest;
import org.forgerock.opendj.ldap.messages.CompareResult;
import org.forgerock.opendj.ldap.messages.DeleteRequest;
import org.forgerock.opendj.ldap.messages.ExtendedRequest;
import org.forgerock.opendj.ldap.messages.ExtendedResult;
import org.forgerock.opendj.ldap.messages.ModifyDnRequest;
import org.forgerock.opendj.ldap.messages.ModifyRequest;
import org.forgerock.opendj.ldap.messages.Requests;
import org.forgerock.opendj.ldap.messages.Responses;
import org.forgerock.opendj.ldap.messages.Result;
import org.forgerock.opendj.ldap.messages.SearchRequest;
import org.forgerock.opendj.ldap.messages.SearchResultEntry;
import org.forgerock.opendj.ldap.messages.SearchResultReference;
import org.forgerock.opendj.ldap.messages.UnbindRequest;
import org.forgerock.opendj.ldap.spi.ConnectionState;
import org.forgerock.opendj.ldap.spi.LdapConnectionFactoryImpl;
import org.forgerock.opendj.ldap.spi.LdapConnectionImpl;
import org.forgerock.opendj.ldap.spi.LdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.LdapPromises;
import org.forgerock.opendj.ldap.spi.TransportProvider;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Option;
import org.forgerock.util.Options;
import org.forgerock.util.Reject;
import org.forgerock.util.Utils;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.promise.ResultHandler;
import org.forgerock.util.time.Duration;
import org.forgerock.util.time.TimeService;

public final class LdapConnectionFactory
extends CommonLdapOptions
implements ConnectionFactory {
    private static final String CONNECT_TIMEOUT_PROPERTY = "org.forgerock.opendj.io.connectTimeout";
    private static final String REQUEST_TIMEOUT_PROPERTY = "org.forgerock.opendj.io.requestTimeout";
    private static final String TIMEOUT_PROPERTY = "org.forgerock.opendj.io.timeout";
    public static final Option<BindRequest> AUTHN_BIND_REQUEST = Option.of(BindRequest.class, null);
    public static final Option<Duration> CONNECT_TIMEOUT = Option.withDefault(Duration.duration(LdapConnectionFactory.getIntProperty("org.forgerock.opendj.io.connectTimeout", 10000), TimeUnit.MILLISECONDS));
    public static final Option<Boolean> HEARTBEAT_ENABLED = Option.withDefault(false);
    public static final Option<Duration> HEARTBEAT_INTERVAL = Option.withDefault(Duration.duration(10L, TimeUnit.SECONDS));
    public static final Option<ScheduledExecutorService> HEARTBEAT_SCHEDULER = Option.of(ScheduledExecutorService.class, null);
    public static final Option<Duration> HEARTBEAT_TIMEOUT = Option.withDefault(Duration.duration(3L, TimeUnit.SECONDS));
    public static final Option<Duration> REQUEST_TIMEOUT = Option.withDefault(Duration.duration(LdapConnectionFactory.getIntProperty("org.forgerock.opendj.io.requestTimeout", LdapConnectionFactory.getIntProperty("org.forgerock.opendj.io.timeout", 0)), TimeUnit.MILLISECONDS));
    public static final Option<Boolean> SSL_USE_STARTTLS = Option.withDefault(false);
    private static final SearchRequest DEFAULT_HEARTBEAT = Requests.unmodifiableSearchRequest(Requests.newSearchRequest(Dn.rootDn(), SearchScope.BASE_OBJECT).addAttribute("1.1"));
    public static final Option<SearchRequest> HEARTBEAT_SEARCH_REQUEST = Option.of(SearchRequest.class, DEFAULT_HEARTBEAT);
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private final long connectTimeoutMs;
    private final long heartBeatDelayMs;
    private final Boolean heartBeatEnabled;
    private final SearchRequest heartBeatRequest;
    private final long heartBeatTimeoutMs;
    private final long heartBeatintervalMs;
    private final LdapConnectionFactoryImpl impl;
    private final BindRequest initialBindRequest;
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final Options options;
    private final TransportProvider provider;
    private final AtomicInteger referenceCount = new AtomicInteger(1);
    private final ReferenceCountedObject.Reference<ScheduledExecutorService> scheduler;
    private final SslOptions sslOptions;
    private final boolean sslUseStartTls;
    private final List<ConnectionImpl> validConnections = new LinkedList<ConnectionImpl>();
    TimeService timeService = TimeService.SYSTEM;
    private final Runnable sendHeartBeatRunnable = new Runnable(){

        @Override
        public void run() {
            boolean heartBeatSent = false;
            for (ConnectionImpl connection : LdapConnectionFactory.this.getValidConnections()) {
                heartBeatSent |= connection.sendHeartBeat();
            }
            if (heartBeatSent) {
                ((ScheduledExecutorService)LdapConnectionFactory.this.scheduler.get()).schedule(LdapConnectionFactory.this.checkHeartBeatRunnable, LdapConnectionFactory.this.heartBeatTimeoutMs, TimeUnit.MILLISECONDS);
            }
        }
    };
    private final Runnable checkHeartBeatRunnable = new Runnable(){

        @Override
        public void run() {
            for (ConnectionImpl connection : LdapConnectionFactory.this.getValidConnections()) {
                connection.checkForHeartBeat();
            }
        }
    };
    private ScheduledFuture<?> heartBeatFuture;

    public LdapConnectionFactory(String host, int port) {
        this(host, port, Options.defaultOptions());
    }

    public LdapConnectionFactory(String host, int port, Options options) {
        Reject.ifNull(host, options);
        this.connectTimeoutMs = options.get(CONNECT_TIMEOUT).to(TimeUnit.MILLISECONDS);
        Reject.ifTrue(this.connectTimeoutMs < 0L, "connect timeout must be >= 0");
        Reject.ifTrue(options.get(REQUEST_TIMEOUT).getValue() < 0L, "request timeout must be >= 0");
        this.heartBeatEnabled = options.get(HEARTBEAT_ENABLED);
        this.heartBeatintervalMs = options.get(HEARTBEAT_INTERVAL).to(TimeUnit.MILLISECONDS);
        this.heartBeatTimeoutMs = options.get(HEARTBEAT_TIMEOUT).to(TimeUnit.MILLISECONDS);
        this.heartBeatDelayMs = this.heartBeatintervalMs / 2L;
        this.heartBeatRequest = options.get(HEARTBEAT_SEARCH_REQUEST);
        if (this.heartBeatEnabled.booleanValue()) {
            Reject.ifTrue(this.heartBeatintervalMs <= 0L, "heart-beat interval must be positive");
            Reject.ifTrue(this.heartBeatTimeoutMs <= 0L, "heart-beat timeout must be positive");
        }
        this.provider = LdapConnectionFactory.getTransportProvider(options);
        this.scheduler = StaticUtils.DEFAULT_SCHEDULER.acquireIfNull(options.get(HEARTBEAT_SCHEDULER));
        this.impl = this.provider.getLdapConnectionFactory(host, port, options);
        this.initialBindRequest = options.get(AUTHN_BIND_REQUEST);
        this.sslOptions = (SslOptions)options.get(SSL_OPTIONS);
        this.sslUseStartTls = options.get(SSL_USE_STARTTLS);
        this.options = Options.copyOf(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            List<ConnectionImpl> list = this.validConnections;
            synchronized (list) {
                if (!this.validConnections.isEmpty()) {
                    logger.debug(LocalizableMessage.raw("LDAPConnectionFactory '%s' is closing while %d active connections remain", this, this.validConnections.size()));
                }
            }
            this.releaseScheduler();
            this.impl.close();
        }
    }

    @Override
    public Connection getConnection() throws LdapException {
        return this.getConnectionAsync().getOrThrowUninterruptibly();
    }

    @Override
    public Promise<Connection, LdapException> getConnectionAsync() {
        this.acquireScheduler();
        final PromiseImpl<Connection, LdapException> promise = PromiseImpl.create();
        final AtomicReference<LdapConnectionImpl> connectionHolder = new AtomicReference<LdapConnectionImpl>();
        final ScheduledFuture<?> timeoutFuture = this.connectTimeoutMs > 0L ? this.scheduler.get().schedule(new Runnable(){

            @Override
            public void run() {
                if (promise.tryHandleException(LdapConnectionFactory.this.newConnectTimeoutError())) {
                    Utils.closeSilently((Closeable)connectionHolder.get());
                    LdapConnectionFactory.this.releaseScheduler();
                }
            }
        }, this.connectTimeoutMs, TimeUnit.MILLISECONDS) : null;
        this.impl.getConnectionAsync().then(new Function<LdapConnectionImpl, LdapConnectionImpl, LdapException>(){

            @Override
            public LdapConnectionImpl apply(LdapConnectionImpl connection) throws LdapException {
                connectionHolder.set(connection);
                return connection;
            }
        }).thenAsync(this.performStartTlsIfNeeded()).thenAsync(this.performSslHandShakeIfNeeded(connectionHolder)).thenAsync(this.performInitialBindIfNeeded(connectionHolder)).thenAsync(this.performInitialHeartBeatIfNeeded(connectionHolder)).thenOnResult(new ResultHandler<Result>(){

            @Override
            public void handleResult(Result result) {
                LdapConnectionImpl connection;
                ConnectionImpl connectionImpl;
                if (timeoutFuture != null) {
                    timeoutFuture.cancel(false);
                }
                if (!promise.tryHandleResult(LdapConnectionFactory.this.registerConnection(connectionImpl = new ConnectionImpl(connection = (LdapConnectionImpl)connectionHolder.get())))) {
                    connectionImpl.close();
                }
            }
        }).thenOnException(new ExceptionHandler<LdapException>(){

            @Override
            public void handleException(LdapException e) {
                LdapException connectException;
                if (timeoutFuture != null) {
                    timeoutFuture.cancel(false);
                }
                if (promise.tryHandleException(connectException = e instanceof TimeoutResultException ? LdapConnectionFactory.this.newHeartBeatTimeoutError() : e)) {
                    Utils.closeSilently((Closeable)connectionHolder.get());
                    LdapConnectionFactory.this.releaseScheduler();
                }
            }
        });
        return promise;
    }

    public String getHostName() {
        return this.impl.getHostName();
    }

    public int getPort() {
        return this.impl.getPort();
    }

    public String getProviderName() {
        return this.provider.getName();
    }

    public String toString() {
        return "LDAPConnectionFactory(provider=`" + this.getProviderName() + ", host='" + this.getHostName() + "', port=" + this.getPort() + ", options=" + this.options + ")";
    }

    private void acquireScheduler() {
        this.referenceCount.incrementAndGet();
        if (this.isClosed.get()) {
            this.releaseScheduler();
            throw new IllegalStateException("Attempted to get a connection on closed factory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionImpl[] getValidConnections() {
        List<ConnectionImpl> list = this.validConnections;
        synchronized (list) {
            return this.validConnections.toArray(new ConnectionImpl[this.validConnections.size()]);
        }
    }

    private LdapException newConnectTimeoutError() {
        LocalizableMessage msg = CoreMessages.LDAP_CONNECTION_CONNECT_TIMEOUT.get(this.impl.getSocketAddress(), this.connectTimeoutMs);
        return LdapException.newLdapException(ResultCode.CLIENT_SIDE_CONNECT_ERROR, msg.toString());
    }

    private LdapException newHeartBeatTimeoutError() {
        return LdapException.newLdapException(ResultCode.CLIENT_SIDE_SERVER_DOWN, CoreMessages.HBCF_HEARTBEAT_TIMEOUT.get(this.heartBeatTimeoutMs));
    }

    private AsyncFunction<Void, BindResult, LdapException> performInitialBindIfNeeded(final AtomicReference<LdapConnectionImpl> connectionHolder) {
        return new AsyncFunction<Void, BindResult, LdapException>(){

            @Override
            public Promise<BindResult, LdapException> apply(Void ignored) throws LdapException {
                if (LdapConnectionFactory.this.initialBindRequest != null) {
                    return ((LdapConnectionImpl)connectionHolder.get()).bindAsync(LdapConnectionFactory.this.initialBindRequest, null);
                }
                return Promises.newResultPromise(Responses.newBindResult(ResultCode.SUCCESS));
            }
        };
    }

    private AsyncFunction<BindResult, Result, LdapException> performInitialHeartBeatIfNeeded(final AtomicReference<LdapConnectionImpl> connectionHolder) {
        return new AsyncFunction<BindResult, Result, LdapException>(){

            @Override
            public Promise<Result, LdapException> apply(BindResult ignored) throws LdapException {
                if (LdapConnectionFactory.this.heartBeatEnabled.booleanValue() && LdapConnectionFactory.this.sslOptions == null && LdapConnectionFactory.this.initialBindRequest == null) {
                    return ((LdapConnectionImpl)connectionHolder.get()).searchAsync(LdapConnectionFactory.this.heartBeatRequest, null, null);
                }
                return Promises.newResultPromise(Responses.newResult(ResultCode.SUCCESS));
            }
        };
    }

    private AsyncFunction<ExtendedResult, Void, LdapException> performSslHandShakeIfNeeded(final AtomicReference<LdapConnectionImpl> connectionHolder) {
        return new AsyncFunction<ExtendedResult, Void, LdapException>(){

            @Override
            public Promise<Void, LdapException> apply(ExtendedResult extendedResult) throws LdapException {
                if (LdapConnectionFactory.this.sslOptions != null && !LdapConnectionFactory.this.sslUseStartTls) {
                    return ((LdapConnectionImpl)connectionHolder.get()).enableTls(LdapConnectionFactory.this.sslOptions);
                }
                return Promises.newResultPromise(null);
            }
        };
    }

    private AsyncFunction<LdapConnectionImpl, ExtendedResult, LdapException> performStartTlsIfNeeded() {
        return new AsyncFunction<LdapConnectionImpl, ExtendedResult, LdapException>(){

            @Override
            public Promise<ExtendedResult, LdapException> apply(LdapConnectionImpl connection) throws LdapException {
                if (LdapConnectionFactory.this.sslOptions != null && LdapConnectionFactory.this.sslUseStartTls) {
                    return connection.extendedRequestAsync(Requests.newStartTlsExtendedRequest(LdapConnectionFactory.this.sslOptions), null);
                }
                return Promises.newResultPromise(Responses.newGenericExtendedResult(ResultCode.SUCCESS));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection registerConnection(ConnectionImpl heartBeatConnection) {
        List<ConnectionImpl> list = this.validConnections;
        synchronized (list) {
            if (this.heartBeatEnabled.booleanValue() && this.validConnections.isEmpty()) {
                this.heartBeatFuture = this.scheduler.get().scheduleWithFixedDelay(this.sendHeartBeatRunnable, 0L, this.heartBeatintervalMs, TimeUnit.MILLISECONDS);
            }
            this.validConnections.add(heartBeatConnection);
        }
        return heartBeatConnection;
    }

    private void releaseScheduler() {
        if (this.referenceCount.decrementAndGet() == 0) {
            this.scheduler.release();
        }
    }

    private final class ConnectionImpl
    extends AbstractAsynchronousConnection
    implements ConnectionEventListener {
        private final LdapConnectionImpl connectionImpl;
        private final Queue<Runnable> pendingBindOrStartTlsRequests = new ConcurrentLinkedQueue<Runnable>();
        private final Queue<LdapResultHandler<?>> pendingResults = new ConcurrentLinkedQueue();
        private final ConnectionState state = new ConnectionState();
        private final Sync sync = new Sync();
        private volatile long lastResponseTimestamp;

        private ConnectionImpl(LdapConnectionImpl connectionImpl) {
            this.lastResponseTimestamp = LdapConnectionFactory.this.timeService.now();
            this.connectionImpl = connectionImpl;
            connectionImpl.addConnectionEventListener(this);
        }

        @Override
        public LdapPromise<Void> abandonAsync(AbandonRequest request) {
            return this.connectionImpl.abandonAsync(request);
        }

        @Override
        public LdapPromise<Result> addAsync(AddRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            if (this.hasConnectionErrorOccurred()) {
                return this.newConnectionErrorPromise();
            }
            return this.timestampPromise(this.connectionImpl.addAsync(request, intermediateResponseHandler));
        }

        @Override
        public void addConnectionEventListener(ConnectionEventListener listener) {
            this.state.addConnectionEventListener(listener);
        }

        @Override
        public LdapPromise<BindResult> bindAsync(final BindRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            if (this.hasConnectionErrorOccurred()) {
                return this.newConnectionErrorPromise();
            }
            if (this.sync.tryLockShared()) {
                return this.timestampBindOrStartTlsPromise(this.connectionImpl.bindAsync(request, intermediateResponseHandler));
            }
            return this.enqueueBindOrStartTlsPromise(new AsyncFunction<Void, BindResult, LdapException>(){

                @Override
                public Promise<BindResult, LdapException> apply(Void value) throws LdapException {
                    return ConnectionImpl.this.timestampBindOrStartTlsPromise(ConnectionImpl.this.connectionImpl.bindAsync(request, intermediateResponseHandler));
                }
            });
        }

        @Override
        public void close() {
            this.handleConnectionClosed();
            this.connectionImpl.close();
        }

        @Override
        public void close(UnbindRequest request, String reason) {
            this.handleConnectionClosed();
            this.connectionImpl.close(request, reason);
        }

        @Override
        public LdapPromise<CompareResult> compareAsync(CompareRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            if (this.hasConnectionErrorOccurred()) {
                return this.newConnectionErrorPromise();
            }
            return this.timestampPromise(this.connectionImpl.compareAsync(request, intermediateResponseHandler));
        }

        @Override
        public LdapPromise<Result> deleteAsync(DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            if (this.hasConnectionErrorOccurred()) {
                return this.newConnectionErrorPromise();
            }
            return this.timestampPromise(this.connectionImpl.deleteAsync(request, intermediateResponseHandler));
        }

        @Override
        public <R extends ExtendedResult> LdapPromise<R> extendedRequestAsync(final ExtendedRequest<R> request, final IntermediateResponseHandler intermediateResponseHandler) {
            if (this.hasConnectionErrorOccurred()) {
                return this.newConnectionErrorPromise();
            }
            if (!this.isStartTlsRequest(request)) {
                return this.timestampPromise(this.connectionImpl.extendedRequestAsync(request, intermediateResponseHandler));
            }
            if (this.sync.tryLockShared()) {
                return this.timestampBindOrStartTlsPromise(this.connectionImpl.extendedRequestAsync(request, intermediateResponseHandler));
            }
            return this.enqueueBindOrStartTlsPromise(new AsyncFunction<Void, R, LdapException>(){

                @Override
                public Promise<R, LdapException> apply(Void value) throws LdapException {
                    return ConnectionImpl.this.timestampBindOrStartTlsPromise(ConnectionImpl.this.connectionImpl.extendedRequestAsync(request, intermediateResponseHandler));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleConnectionClosed() {
            if (this.state.notifyConnectionClosed()) {
                this.failPendingResults(LdapException.newLdapException(ResultCode.CLIENT_SIDE_USER_CANCELLED, CoreMessages.HBCF_CONNECTION_CLOSED_BY_CLIENT.get()));
                List list = LdapConnectionFactory.this.validConnections;
                synchronized (list) {
                    this.connectionImpl.removeConnectionEventListener(this);
                    LdapConnectionFactory.this.validConnections.remove(this);
                    if (LdapConnectionFactory.this.heartBeatEnabled.booleanValue() && LdapConnectionFactory.this.validConnections.isEmpty()) {
                        LdapConnectionFactory.this.heartBeatFuture.cancel(false);
                    }
                }
                LdapConnectionFactory.this.releaseScheduler();
            }
        }

        @Override
        public void handleConnectionError(boolean isDisconnectNotification, LdapException error) {
            if (this.state.notifyConnectionError(isDisconnectNotification, error)) {
                this.failPendingResults(error);
            }
        }

        @Override
        public void handleUnsolicitedNotification(ExtendedResult notification) {
            this.timestamp(notification);
            this.state.notifyUnsolicitedNotification(notification);
        }

        @Override
        public boolean isClosed() {
            return this.state.isClosed();
        }

        @Override
        public boolean isValid() {
            return this.state.isValid() && this.connectionImpl.isValid();
        }

        @Override
        public LdapPromise<Result> modifyAsync(ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            if (this.hasConnectionErrorOccurred()) {
                return this.newConnectionErrorPromise();
            }
            return this.timestampPromise(this.connectionImpl.modifyAsync(request, intermediateResponseHandler));
        }

        @Override
        public LdapPromise<Result> modifyDnAsync(ModifyDnRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            if (this.hasConnectionErrorOccurred()) {
                return this.newConnectionErrorPromise();
            }
            return this.timestampPromise(this.connectionImpl.modifyDnAsync(request, intermediateResponseHandler));
        }

        @Override
        public void removeConnectionEventListener(ConnectionEventListener listener) {
            this.state.removeConnectionEventListener(listener);
        }

        @Override
        public LdapPromise<Result> searchAsync(SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, final SearchResultHandler searchHandler) {
            if (this.hasConnectionErrorOccurred()) {
                return this.newConnectionErrorPromise();
            }
            final AtomicBoolean searchDone = new AtomicBoolean();
            SearchResultHandler entryHandler = new SearchResultHandler(){

                @Override
                public synchronized boolean handleEntry(SearchResultEntry entry) {
                    if (!searchDone.get()) {
                        ConnectionImpl.this.timestamp(entry);
                        if (searchHandler != null) {
                            searchHandler.handleEntry(entry);
                        }
                    }
                    return true;
                }

                @Override
                public synchronized boolean handleReference(SearchResultReference reference) {
                    if (!searchDone.get()) {
                        ConnectionImpl.this.timestamp(reference);
                        if (searchHandler != null) {
                            searchHandler.handleReference(reference);
                        }
                    }
                    return true;
                }
            };
            return this.timestampPromise(this.connectionImpl.searchAsync(request, intermediateResponseHandler, entryHandler).thenOnResultOrException(new Runnable(){

                @Override
                public void run() {
                    searchDone.getAndSet(true);
                }
            }));
        }

        @Override
        public String toString() {
            return this.connectionImpl.toString();
        }

        private void checkForHeartBeat() {
            long currentTimeMillis;
            if (this.sync.isHeld() && this.lastResponseTimestamp < (currentTimeMillis = LdapConnectionFactory.this.timeService.now()) - LdapConnectionFactory.this.heartBeatTimeoutMs) {
                logger.warn(LocalizableMessage.raw("No heartbeat detected for connection '%s'", this.connectionImpl));
                this.handleConnectionError(false, LdapConnectionFactory.this.newHeartBeatTimeoutError());
            }
        }

        private boolean hasConnectionErrorOccurred() {
            return this.state.getConnectionError() != null;
        }

        private <R extends Result> LdapPromise<R> enqueueBindOrStartTlsPromise(AsyncFunction<Void, R, LdapException> doRequest) {
            final LdapPromiseImpl promise = LdapPromiseImpl.newLdapPromiseImpl();
            final LdapPromise result = promise.thenAsync(doRequest);
            this.pendingBindOrStartTlsRequests.offer(new Runnable(){

                @Override
                public void run() {
                    if (!result.isCancelled()) {
                        ConnectionImpl.this.sync.lockShared();
                        promise.handleResult(null);
                    }
                }
            });
            this.flushPendingBindOrStartTlsRequests();
            return result;
        }

        private void failPendingResults(LdapException error) {
            LdapResultHandler<?> pendingResult;
            while ((pendingResult = this.pendingResults.peek()) != null) {
                pendingResult.handleException(error);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushPendingBindOrStartTlsRequests() {
            if (!this.pendingBindOrStartTlsRequests.isEmpty() && this.sync.tryLockShared()) {
                try {
                    Runnable pendingRequest;
                    while ((pendingRequest = this.pendingBindOrStartTlsRequests.poll()) != null) {
                        pendingRequest.run();
                    }
                }
                finally {
                    this.sync.unlockShared();
                }
            }
        }

        private boolean isStartTlsRequest(ExtendedRequest<?> request) {
            return request.getOid().equals("1.3.6.1.4.1.1466.20037");
        }

        private <R> LdapPromise<R> newConnectionErrorPromise() {
            return LdapPromises.newFailedLdapPromise(this.state.getConnectionError());
        }

        private void releaseBindOrStartTlsLock() {
            this.sync.unlockShared();
        }

        private void releaseHeartBeatLock() {
            this.sync.unlockExclusively();
            this.flushPendingBindOrStartTlsRequests();
        }

        private boolean sendHeartBeat() {
            if (!this.state.isValid()) {
                return false;
            }
            long currentTimeMillis = LdapConnectionFactory.this.timeService.now();
            if (currentTimeMillis < this.lastResponseTimestamp + LdapConnectionFactory.this.heartBeatDelayMs) {
                return false;
            }
            if (this.sync.tryLockExclusively()) {
                try {
                    this.connectionImpl.searchAsync(LdapConnectionFactory.this.heartBeatRequest, null, new SearchResultHandler(){

                        @Override
                        public boolean handleEntry(SearchResultEntry entry) {
                            ConnectionImpl.this.timestamp(entry);
                            return true;
                        }

                        @Override
                        public boolean handleReference(SearchResultReference reference) {
                            ConnectionImpl.this.timestamp(reference);
                            return true;
                        }
                    }).thenOnResult(new ResultHandler<Result>(){

                        @Override
                        public void handleResult(Result result) {
                            ConnectionImpl.this.timestamp(result);
                            ConnectionImpl.this.releaseHeartBeatLock();
                        }
                    }).thenOnException(new ExceptionHandler<LdapException>(){

                        @Override
                        public void handleException(LdapException exception) {
                            if (!(exception instanceof CancelledResultException)) {
                                logger.debug(LocalizableMessage.raw("Heartbeat failed for connection factory '%s'", LdapConnectionFactory.this, exception));
                                ConnectionImpl.this.timestamp(exception);
                            }
                            ConnectionImpl.this.releaseHeartBeatLock();
                        }
                    });
                }
                catch (IllegalStateException e) {
                    this.releaseHeartBeatLock();
                }
            }
            return true;
        }

        private <R> R timestamp(R response) {
            if (!(response instanceof ConnectionException)) {
                this.lastResponseTimestamp = LdapConnectionFactory.this.timeService.now();
            }
            return response;
        }

        private <R extends Result> LdapPromise<R> timestampBindOrStartTlsPromise(LdapPromise<R> wrappedPromise) {
            return this.timestampPromise(wrappedPromise).thenOnResultOrException(new Runnable(){

                @Override
                public void run() {
                    ConnectionImpl.this.releaseBindOrStartTlsLock();
                }
            });
        }

        private <R extends Result> LdapPromise<R> timestampPromise(LdapPromise<R> wrappedPromise) {
            final LdapPromiseImplWrapper<R> outerPromise = new LdapPromiseImplWrapper<R>(wrappedPromise);
            this.pendingResults.add(outerPromise);
            wrappedPromise.thenOnResult(new ResultHandler<R>(){

                @Override
                public void handleResult(R result) {
                    outerPromise.handleResult(result);
                    ConnectionImpl.this.timestamp(result);
                }
            }).thenOnException(new ExceptionHandler<LdapException>(){

                @Override
                public void handleException(LdapException exception) {
                    outerPromise.handleException(exception);
                    ConnectionImpl.this.timestamp(exception);
                }
            });
            outerPromise.thenOnResultOrException(new Runnable(){

                @Override
                public void run() {
                    ConnectionImpl.this.pendingResults.remove(outerPromise);
                }
            });
            if (this.hasConnectionErrorOccurred()) {
                outerPromise.handleException(this.state.getConnectionError());
            }
            return outerPromise;
        }

        private class LdapPromiseImplWrapper<R>
        extends LdapPromiseImpl<R> {
            protected LdapPromiseImplWrapper(final LdapPromise<R> wrappedPromise) {
                super(new PromiseImpl<R, LdapException>(){

                    @Override
                    protected LdapException tryCancel(boolean mayInterruptIfRunning) {
                        wrappedPromise.cancel(mayInterruptIfRunning);
                        return null;
                    }
                }, wrappedPromise.getRequestId());
            }
        }
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        private static final int LOCKED_EXCLUSIVELY = -1;
        private static final int UNLOCKED = 0;
        private static final long serialVersionUID = -3590428415442668336L;

        private Sync() {
        }

        boolean isHeld() {
            return this.getState() != 0;
        }

        void lockShared() {
            this.acquireShared(1);
        }

        boolean tryLockExclusively() {
            return this.tryAcquire(0);
        }

        boolean tryLockShared() {
            return this.tryAcquireShared(1) > 0;
        }

        void unlockExclusively() {
            this.release(0);
        }

        void unlockShared() {
            this.releaseShared(0);
        }

        @Override
        protected boolean isHeldExclusively() {
            return this.getState() == -1;
        }

        @Override
        protected boolean tryAcquire(int ignored) {
            if (this.compareAndSetState(0, -1)) {
                this.setExclusiveOwnerThread(Thread.currentThread());
                return true;
            }
            return false;
        }

        @Override
        protected int tryAcquireShared(int readers) {
            int newState;
            int state;
            do {
                if ((state = this.getState()) != -1) continue;
                return -1;
            } while (!this.compareAndSetState(state, newState = state + readers));
            return newState;
        }

        @Override
        protected boolean tryRelease(int ignored) {
            if (this.getState() != -1) {
                throw new IllegalMonitorStateException();
            }
            this.setExclusiveOwnerThread(null);
            this.setState(0);
            return true;
        }

        @Override
        protected boolean tryReleaseShared(int ignored) {
            int newState;
            int state;
            do {
                if ((state = this.getState()) != 0 && state != -1) continue;
                throw new IllegalMonitorStateException();
            } while (!this.compareAndSetState(state, newState = state - 1));
            return newState == 0;
        }
    }
}

