/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

public enum ConnectionSecurity {
    NONE{

        @Override
        public boolean isSecure() {
            return false;
        }

        @Override
        public String getProtocolScheme() {
            return "ldap";
        }
    }
    ,
    STARTTLS{

        @Override
        public boolean isSecure() {
            return true;
        }

        @Override
        public String getProtocolScheme() {
            return "ldap";
        }
    }
    ,
    SSL{

        @Override
        public boolean isSecure() {
            return true;
        }

        @Override
        public String getProtocolScheme() {
            return "ldaps";
        }
    };


    public abstract boolean isSecure();

    public abstract String getProtocolScheme();

    public static ConnectionSecurity connectionSecurity(boolean useSsl, boolean useStartTls) {
        if (useSsl) {
            return SSL;
        }
        if (useStartTls) {
            return STARTTLS;
        }
        return NONE;
    }
}

