/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.grizzly.Asn1BufferReader;
import org.forgerock.opendj.grizzly.Asn1BufferWriter;
import org.forgerock.opendj.grizzly.SaslFilter;
import org.forgerock.opendj.io.Ldap;
import org.forgerock.opendj.io.LdapReader;
import org.forgerock.opendj.io.LdapWriter;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.LdapConnectionFactory;
import org.forgerock.opendj.ldap.SslOptions;
import org.forgerock.util.Options;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainEnabledTransport;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.nio.transport.TCPNIOConnection;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;

final class GrizzlyUtils {
    private static final ThreadCache.CachedTypeIndex<LdapWriter> WRITER_INDEX = ThreadCache.obtainIndex(LdapWriter.class, 1);
    private static final ThreadCache.CachedTypeIndex<LdapWriter> WRITER_INDEX_V2 = ThreadCache.obtainIndex(LdapWriter.class.getName() + ".ldapV2", LdapWriter.class, 1);

    static SSLEngineConfigurator newSslEngineConfiguration(SslOptions sslOptions) {
        return new SSLEngineConfigurator(sslOptions.getSslContext()).setClientMode(sslOptions.useClientMode()).setNeedClientAuth(sslOptions.needClientAuth()).setWantClientAuth(sslOptions.wantClientAuth()).setEnabledCipherSuites(sslOptions.getEnabledCipherSuites()).setEnabledProtocols(sslOptions.getEnabledProtocols());
    }

    static FilterChain buildFilterChain(Processor<?> processor, Filter ... filters) {
        if (processor instanceof FilterChain) {
            return FilterChainBuilder.stateless().addAll((FilterChain)processor).addAll(filters).build();
        }
        if (processor instanceof FilterChainEnabledTransport) {
            return FilterChainBuilder.stateless().add(((FilterChainEnabledTransport)((Object)processor)).getTransportFilter()).addAll(filters).build();
        }
        return FilterChainBuilder.stateless().add(new TransportFilter()).addAll(filters).build();
    }

    static void addFilterToConnection(Filter filter, Connection<?> connection) {
        FilterChain currentChain = (FilterChain)connection.getProcessor();
        FilterChain newChain = GrizzlyUtils.addFilterToChain(filter, currentChain);
        connection.setProcessor(newChain);
    }

    static FilterChain addFilterToChain(Filter filter, FilterChain chain) {
        if (filter instanceof SSLFilter) {
            return FilterChainBuilder.stateless().addAll(chain).add(1, filter).build();
        }
        if (filter instanceof SaslFilter) {
            int pos = chain.get(1) instanceof SSLFilter ? 2 : 1;
            return FilterChainBuilder.stateless().addAll(chain).add(pos, filter).build();
        }
        return FilterChainBuilder.stateless().addAll(chain).add(chain.size() - 1, filter).build();
    }

    static LdapReader<Asn1BufferReader> createReader(DecodeOptions decodeOptions, int maxAsn1ElementSize) {
        return Ldap.getReader(new Asn1BufferReader(maxAsn1ElementSize), decodeOptions);
    }

    static LdapWriter<Asn1BufferWriter> getWriter(MemoryManager memoryManager, int protocolVersion) {
        LdapWriter<Asn1BufferWriter> writer;
        LdapWriter<Asn1BufferWriter> ldapWriter = writer = protocolVersion >= 3 ? ThreadCache.takeFromCache(WRITER_INDEX) : ThreadCache.takeFromCache(WRITER_INDEX_V2);
        if (writer == null) {
            writer = Ldap.getWriter(new Asn1BufferWriter(), protocolVersion);
        }
        ((Asn1BufferWriter)writer.getAsn1Writer()).reset(memoryManager);
        return writer;
    }

    static void recycleWriter(LdapWriter<Asn1BufferWriter> writer) {
        writer.getAsn1Writer().recycle();
        ThreadCache.putToCache(writer.getProtocolVersion() >= 3 ? WRITER_INDEX : WRITER_INDEX_V2, writer);
    }

    static void configureConnection(Connection<?> connection, LocalizedLogger logger, Options options) {
        connection.configureBlocking(true);
        SocketChannel channel = (SocketChannel)((TCPNIOConnection)connection).getChannel();
        Socket socket = channel.socket();
        boolean tcpNoDelay = (Boolean)options.get(LdapConnectionFactory.TCP_NO_DELAY);
        boolean keepAlive = (Boolean)options.get(LdapConnectionFactory.SO_KEEPALIVE);
        boolean reuseAddress = (Boolean)options.get(LdapConnectionFactory.SO_REUSE_ADDRESS);
        int linger = (Integer)options.get(LdapConnectionFactory.SO_LINGER_IN_SECONDS);
        try {
            socket.setTcpNoDelay(tcpNoDelay);
        }
        catch (SocketException e) {
            logger.traceException((Throwable)e, "Unable to set TCP_NODELAY to %d on client connection", (Object)tcpNoDelay);
        }
        try {
            socket.setKeepAlive(keepAlive);
        }
        catch (SocketException e) {
            logger.traceException((Throwable)e, "Unable to set SO_KEEPALIVE to %d on client connection", (Object)keepAlive);
        }
        try {
            socket.setReuseAddress(reuseAddress);
        }
        catch (SocketException e) {
            logger.traceException((Throwable)e, "Unable to set SO_REUSEADDR to %d on client connection", (Object)reuseAddress);
        }
        try {
            if (linger < 0) {
                socket.setSoLinger(false, 0);
            } else {
                socket.setSoLinger(true, linger);
            }
        }
        catch (SocketException e) {
            logger.traceException((Throwable)e, "Unable to set SO_LINGER to %d on client connection", (Object)linger);
        }
    }

    private GrizzlyUtils() {
    }
}

