/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.Comparator;
import java.util.List;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.SortKey;
import org.forgerock.util.Utils;

public class SortKeyComparator
implements Comparator<JsonValue> {
    private final List<SortKey> sortKeys;

    public SortKeyComparator(List<SortKey> sortKeys) {
        this.sortKeys = sortKeys;
    }

    @Override
    public int compare(JsonValue left, JsonValue right) {
        if (left == right || left.isNull() && right.isNull()) {
            return 0;
        }
        if (left.isNull()) {
            return -1;
        }
        if (right.isNull()) {
            return 1;
        }
        for (SortKey sortKey : this.sortKeys) {
            int orderMultiplier = sortKey.isAscendingOrder() ? 1 : -1;
            JsonValue leftValue = left.get(sortKey.getField());
            JsonValue rightValue = right.get(sortKey.getField());
            if (null == leftValue && null == rightValue) continue;
            if (null == leftValue) {
                return -1 * orderMultiplier;
            }
            if (null == rightValue) {
                return orderMultiplier;
            }
            int compareTo = Utils.compareValues(leftValue.getObject(), rightValue.getObject());
            if (compareTo == 0) continue;
            return compareTo * orderMultiplier;
        }
        return 0;
    }
}

