/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.Collection;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.Connection;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.services.context.Context;

public abstract class AbstractAsynchronousConnection
implements Connection {
    protected AbstractAsynchronousConnection() {
    }

    @Override
    public ActionResponse action(Context context, ActionRequest request) throws ResourceException {
        try {
            return this.actionAsync(context, request).getOrThrow();
        }
        catch (InterruptedException e) {
            throw this.newTimeoutException(e);
        }
    }

    @Override
    public ResourceResponse create(Context context, CreateRequest request) throws ResourceException {
        try {
            return this.createAsync(context, request).getOrThrow();
        }
        catch (InterruptedException e) {
            throw this.newTimeoutException(e);
        }
    }

    @Override
    public ResourceResponse delete(Context context, DeleteRequest request) throws ResourceException {
        try {
            return this.deleteAsync(context, request).getOrThrow();
        }
        catch (InterruptedException e) {
            throw this.newTimeoutException(e);
        }
    }

    @Override
    public ResourceResponse patch(Context context, PatchRequest request) throws ResourceException {
        try {
            return this.patchAsync(context, request).getOrThrow();
        }
        catch (InterruptedException e) {
            throw this.newTimeoutException(e);
        }
    }

    @Override
    public QueryResponse query(Context context, QueryRequest request, QueryResourceHandler handler) throws ResourceException {
        try {
            return this.queryAsync(context, request, handler).getOrThrow();
        }
        catch (InterruptedException e) {
            throw this.newTimeoutException(e);
        }
    }

    @Override
    public QueryResponse query(Context context, QueryRequest request, Collection<? super ResourceResponse> results) throws ResourceException {
        return this.query(context, request, (ResourceResponse resource) -> {
            results.add(resource);
            return true;
        });
    }

    @Override
    public ResourceResponse read(Context context, ReadRequest request) throws ResourceException {
        try {
            return this.readAsync(context, request).getOrThrow();
        }
        catch (InterruptedException e) {
            throw this.newTimeoutException(e);
        }
    }

    @Override
    public ResourceResponse update(Context context, UpdateRequest request) throws ResourceException {
        try {
            return this.updateAsync(context, request).getOrThrow();
        }
        catch (InterruptedException e) {
            throw this.newTimeoutException(e);
        }
    }

    private ResourceException newTimeoutException(Exception cause) {
        return ResourceException.newResourceException(503, "Request was interrupted", cause);
    }
}

