/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jws;

import org.forgerock.json.jose.jws.JwsAlgorithmType;
import org.forgerock.json.jose.jwt.Algorithm;

public enum JwsAlgorithm implements Algorithm
{
    NONE("none", null, null, JwsAlgorithmType.NONE),
    HS256("HS256", "HmacSHA256", "SHA-256", JwsAlgorithmType.HMAC),
    HS384("HS384", "HmacSHA384", "SHA-384", JwsAlgorithmType.HMAC),
    HS512("HS512", "HmacSHA512", "SHA-512", JwsAlgorithmType.HMAC),
    RS256("RS256", "SHA256withRSA", "SHA-256", JwsAlgorithmType.RSA),
    ES256("ES256", "SHA256WithECDSA", "SHA-256", JwsAlgorithmType.ECDSA),
    ES384("ES384", "SHA384WithECDSA", "SHA-384", JwsAlgorithmType.ECDSA),
    ES512("ES512", "SHA512WithECDSA", "SHA-512", JwsAlgorithmType.ECDSA);

    private final String jwaAlgorithmName;
    private final String algorithm;
    private final String mdAlgorithm;
    private final JwsAlgorithmType algorithmType;

    private JwsAlgorithm(String jwaAlgorithmName, String algorithm, String mdAlgorithm, JwsAlgorithmType algorithmType) {
        this.jwaAlgorithmName = jwaAlgorithmName;
        this.algorithm = algorithm;
        this.mdAlgorithm = mdAlgorithm;
        this.algorithmType = algorithmType;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getJwaAlgorithmName() {
        return this.jwaAlgorithmName;
    }

    public String getMdAlgorithm() {
        return this.mdAlgorithm;
    }

    public String getEllipticCurveName() {
        switch (this) {
            case ES256: {
                return "P-256";
            }
            case ES384: {
                return "P-384";
            }
            case ES512: {
                return "P-521";
            }
        }
        return null;
    }

    public JwsAlgorithmType getAlgorithmType() {
        return this.algorithmType;
    }

    @Deprecated
    public static JwsAlgorithm getJwsAlgorithm(String algorithm) {
        return JwsAlgorithm.parseCryptographicAlgorithm(algorithm);
    }

    public static JwsAlgorithm parseCryptographicAlgorithm(String algorithm) {
        for (JwsAlgorithm jwsAlgorithm : JwsAlgorithm.values()) {
            if (!algorithm.equalsIgnoreCase(jwsAlgorithm.getAlgorithm())) continue;
            return jwsAlgorithm;
        }
        throw new IllegalArgumentException("Unknown Signing Algorithm");
    }

    public static JwsAlgorithm parseAlgorithm(String algorithm) {
        for (JwsAlgorithm alg : JwsAlgorithm.values()) {
            if (!alg.getJwaAlgorithmName().equals(algorithm)) continue;
            return alg;
        }
        throw new IllegalArgumentException("Unknown Signing Algorithm");
    }

    public String toString() {
        return super.toString();
    }
}

