/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwk;

import java.io.IOException;
import java.net.URL;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import org.forgerock.json.jose.exceptions.FailedToLoadJWKException;
import org.forgerock.json.jose.jwk.JWK;
import org.forgerock.json.jose.jwk.JWKLookup;
import org.forgerock.json.jose.jwk.JWKSet;
import org.forgerock.util.SimpleHTTPClient;

public class JWKSetParser {
    private SimpleHTTPClient simpleHTTPClient;
    private JWKLookup jwkLookup;

    public JWKSetParser(int readTimeout, int connTimeout) {
        this(new SimpleHTTPClient(readTimeout, connTimeout));
    }

    public JWKSetParser(SimpleHTTPClient simpleHTTPClient) {
        this(simpleHTTPClient, new JWKLookup());
    }

    public JWKSetParser(SimpleHTTPClient simpleHTTPClient, JWKLookup jwkLookup) {
        this.simpleHTTPClient = simpleHTTPClient;
        this.jwkLookup = jwkLookup;
    }

    public Map<String, Key> generateMapFromJWK(URL url) throws FailedToLoadJWKException {
        return this.jwkSetToMap(this.jwkSet(url));
    }

    private String gatherHttpContents(URL url) throws FailedToLoadJWKException {
        try {
            return this.simpleHTTPClient.get(url);
        }
        catch (IOException e) {
            throw new FailedToLoadJWKException("Unable to load the JWK location over HTTP", e);
        }
    }

    public JWKSet jwkSet(URL url) throws FailedToLoadJWKException {
        String jwksContents = this.gatherHttpContents(url);
        return JWKSet.parse(jwksContents);
    }

    public Map<String, Key> jwkSetToMap(JWKSet jwkSet) throws FailedToLoadJWKException {
        HashMap<String, Key> keyMap = new HashMap<String, Key>();
        for (JWK jwk : jwkSet.getJWKsAsList()) {
            Key key = this.jwkLookup.lookup(jwk.toJsonString(), jwk.getKeyType());
            keyMap.put(jwk.getKeyId(), key);
        }
        return keyMap;
    }
}

