/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwk;

import java.security.Key;
import org.forgerock.json.JsonException;
import org.forgerock.json.jose.exceptions.FailedToLoadJWKException;
import org.forgerock.json.jose.jwk.EcJWK;
import org.forgerock.json.jose.jwk.KeyType;
import org.forgerock.json.jose.jwk.OctJWK;
import org.forgerock.json.jose.jwk.RsaJWK;

public class JWKLookup {
    public Key lookup(String json, KeyType keyType) throws FailedToLoadJWKException {
        try {
            switch (keyType) {
                case RSA: {
                    RsaJWK rsaJWK = RsaJWK.parse(json);
                    return rsaJWK.toRSAPublicKey();
                }
                case EC: {
                    EcJWK ecJWK = EcJWK.parse(json);
                    return ecJWK.toECPublicKey();
                }
                case OCT: {
                    OctJWK octJWK = OctJWK.parse(json);
                    return octJWK.toSecretKey();
                }
            }
            throw new FailedToLoadJWKException("Unable to find handler for Key Type");
        }
        catch (JsonException je) {
            throw new FailedToLoadJWKException("Unable to generate Key from provided JSON", je);
        }
    }
}

