/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwe;

import org.forgerock.json.jose.exceptions.JweException;
import org.forgerock.json.jose.jwe.EncryptionMethod;
import org.forgerock.json.jose.jwe.JweAlgorithm;
import org.forgerock.json.jose.jwe.JweHeader;
import org.forgerock.json.jose.jwe.handlers.encryption.AESKeyWrapEncryptionHandler;
import org.forgerock.json.jose.jwe.handlers.encryption.DirectEncryptionHandler;
import org.forgerock.json.jose.jwe.handlers.encryption.ECDHEncryptionHandler;
import org.forgerock.json.jose.jwe.handlers.encryption.EncryptionHandler;
import org.forgerock.json.jose.jwe.handlers.encryption.RSAEncryptionHandler;

public class EncryptionManager {
    public EncryptionHandler getEncryptionHandler(JweHeader header) {
        switch (header.getAlgorithm().getAlgorithmType()) {
            case RSA: {
                return this.getEncryptionHandler(header.getAlgorithm(), header.getEncryptionMethod());
            }
            case DIRECT: {
                return this.getEncryptionHandler(header.getAlgorithm(), header.getEncryptionMethod());
            }
            case AES_KEYWRAP: {
                return this.getEncryptionHandler(header.getAlgorithm(), header.getEncryptionMethod());
            }
            case ECDH_ES: {
                JweAlgorithm keyWrappingAlgorithm = header.getAlgorithm().getKeyWrappingAlgorithm();
                EncryptionHandler keyWrappingHandler = this.getEncryptionHandler(keyWrappingAlgorithm, header.getEncryptionMethod());
                return ECDHEncryptionHandler.getInstance(keyWrappingHandler, header.getAlgorithm(), header.getEncryptionMethod());
            }
        }
        throw new JweException("No Encryption Handler for unknown encryption algorithm, " + header.getAlgorithm() + ".");
    }

    private EncryptionHandler getEncryptionHandler(JweAlgorithm algorithm, EncryptionMethod encryptionMethod) {
        switch (algorithm) {
            case RSAES_PKCS1_V1_5: 
            case RSA_OAEP: 
            case RSA_OAEP_256: {
                return new RSAEncryptionHandler(encryptionMethod, algorithm);
            }
            case DIRECT: {
                return new DirectEncryptionHandler(encryptionMethod);
            }
            case A128KW: 
            case A192KW: 
            case A256KW: {
                return new AESKeyWrapEncryptionHandler(encryptionMethod);
            }
        }
        throw new JweException("No Encryption Handler for unknown encryption method, " + (Object)((Object)encryptionMethod) + ", with algorithm,  " + algorithm + ".");
    }
}

