/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.forgerock.json.JsonException;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueException;
import org.forgerock.json.JsonValueTraverseFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;
import org.forgerock.util.Utils;
import org.forgerock.util.time.Duration;

public final class JsonValueFunctions {
    private JsonValueFunctions() {
    }

    public static Function<JsonValue, Charset, JsonValueException> charset() {
        return value -> {
            try {
                return value.isNull() ? null : Charset.forName(value.asString());
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                throw new JsonValueException((JsonValue)value, (Throwable)e);
            }
        };
    }

    public static Function<JsonValue, Duration, JsonValueException> duration() {
        return value -> {
            try {
                return value.isNull() ? null : Duration.duration(value.asString());
            }
            catch (IllegalArgumentException iae) {
                throw new JsonValueException((JsonValue)value, (Throwable)iae);
            }
        };
    }

    public static <T extends Enum<T>> Function<JsonValue, T, JsonValueException> enumConstant(Class<T> type) {
        return value -> Utils.asEnum(value.asString(), type);
    }

    public static Function<JsonValue, File, JsonValueException> file() {
        return value -> value.isNull() ? null : new File(value.asString());
    }

    public static Function<JsonValue, Pattern, JsonValueException> pattern() {
        return value -> {
            try {
                return value.isNull() ? null : Pattern.compile(value.asString());
            }
            catch (PatternSyntaxException pse) {
                throw new JsonValueException((JsonValue)value, (Throwable)pse);
            }
        };
    }

    public static Function<JsonValue, JsonPointer, JsonValueException> pointer() {
        return value -> {
            try {
                return value.isNull() ? null : new JsonPointer(value.asString());
            }
            catch (JsonValueException jve) {
                throw jve;
            }
            catch (JsonException je) {
                throw new JsonValueException((JsonValue)value, (Throwable)je);
            }
        };
    }

    public static Function<JsonValue, URI, JsonValueException> uri() {
        return value -> {
            try {
                return value.isNull() ? null : new URI(value.asString());
            }
            catch (URISyntaxException use) {
                throw new JsonValueException((JsonValue)value, (Throwable)use);
            }
        };
    }

    public static Function<JsonValue, URL, JsonValueException> url() {
        return value -> {
            try {
                return value.isNull() ? null : new URL(value.asString());
            }
            catch (MalformedURLException e) {
                throw new JsonValueException((JsonValue)value, (Throwable)e);
            }
        };
    }

    public static Function<JsonValue, UUID, JsonValueException> uuid() {
        return value -> {
            try {
                return value.isNull() ? null : UUID.fromString(value.asString());
            }
            catch (IllegalArgumentException iae) {
                throw new JsonValueException((JsonValue)value, (Throwable)iae);
            }
        };
    }

    public static <V, E extends Exception> Function<JsonValue, List<V>, E> listOf(Function<JsonValue, V, E> transformFunction) {
        Reject.ifNull(transformFunction);
        return value -> {
            if (value.isCollection()) {
                ArrayList list = new ArrayList(value.size());
                for (JsonValue elem : value) {
                    list.add(elem.as(transformFunction));
                }
                return list;
            }
            return null;
        };
    }

    public static <V, E extends Exception> Function<JsonValue, Set<V>, E> setOf(Function<JsonValue, V, E> transformFunction) {
        Reject.ifNull(transformFunction);
        return value -> {
            if (value.isCollection()) {
                LinkedHashSet set = new LinkedHashSet(value.size());
                for (JsonValue elem : value) {
                    set.add(elem.as(transformFunction));
                }
                return set;
            }
            return null;
        };
    }

    public static <V> Function<JsonValue, Set<V>, JsonValueException> setOf(Class<V> type) {
        Reject.checkNotNull(type);
        return JsonValueFunctions.setOf((JsonValue value) -> {
            if (value.isNull()) {
                return null;
            }
            Object object = value.getObject();
            if (type.isInstance(object)) {
                return type.cast(object);
            }
            throw new JsonValueException((JsonValue)value, "Expecting an element of type " + type.getName());
        });
    }

    public static Function<JsonValue, JsonValue, JsonValueException> deepTransformBy(Function<JsonValue, ?, JsonValueException> function) {
        return new JsonValueTraverseFunction(function);
    }

    public static Function<JsonValue, JsonValue, JsonValueException> identity() {
        return JsonValue::copy;
    }
}

