/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.transform;

import io.swagger.models.properties.ObjectProperty;
import java.util.Objects;
import org.forgerock.api.transform.LocalizableProperty;
import org.forgerock.util.i18n.LocalizableString;

class LocalizableObjectProperty
extends ObjectProperty
implements LocalizableProperty<ObjectProperty> {
    private LocalizableString title;
    private LocalizableString description;
    private Object defaultValue;

    LocalizableObjectProperty() {
    }

    @Override
    public LocalizableObjectProperty title(LocalizableString title) {
        this.title = title;
        return this;
    }

    @Override
    public LocalizableObjectProperty description(LocalizableString desc) {
        this.description = desc;
        return this;
    }

    @Override
    public LocalizableObjectProperty title(String title) {
        this.setTitle(title);
        return this;
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        this.title = new LocalizableString(title);
    }

    @Override
    public LocalizableObjectProperty description(String description) {
        this.setDescription(description);
        return this;
    }

    @Override
    public void setDescription(String description) {
        super.setDescription(description);
        this.description = new LocalizableString(description);
    }

    @Override
    public LocalizableString getLocalizableTitle() {
        return this.title;
    }

    @Override
    public LocalizableString getLocalizableDescription() {
        return this.description;
    }

    public void setDefault(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Object getDefault() {
        return this.defaultValue;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof LocalizableObjectProperty)) {
            return false;
        }
        LocalizableObjectProperty other = (LocalizableObjectProperty)o;
        if (!Objects.equals(this.defaultValue, other.defaultValue)) {
            return false;
        }
        if (!Objects.equals(this.title, other.title)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        return Objects.equals(this.getProperties(), other.getProperties());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.title, this.description, this.defaultValue);
    }
}

