/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.jackson;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.module.jsonSchema.types.BooleanSchema;
import javax.validation.ValidationException;
import org.forgerock.api.enums.ReadPolicy;
import org.forgerock.api.enums.WritePolicy;
import org.forgerock.api.jackson.CrestReadWritePoliciesSchema;
import org.forgerock.api.jackson.OrderedFieldSchema;
import org.forgerock.api.jackson.ValidatableSchema;
import org.forgerock.api.jackson.WithExampleSchema;
import org.forgerock.json.JsonValue;

public class CrestBooleanSchema
extends BooleanSchema
implements CrestReadWritePoliciesSchema,
OrderedFieldSchema,
ValidatableSchema,
WithExampleSchema<Boolean> {
    private WritePolicy writePolicy;
    private ReadPolicy readPolicy;
    private Boolean errorOnWritePolicyFailure;
    private Boolean returnOnDemand;
    private Integer propertyOrder;
    private Boolean example;

    @Override
    public WritePolicy getWritePolicy() {
        return this.writePolicy;
    }

    @Override
    public void setWritePolicy(WritePolicy policy) {
        this.writePolicy = policy;
    }

    @Override
    public ReadPolicy getReadPolicy() {
        return this.readPolicy;
    }

    @Override
    public void setReadPolicy(ReadPolicy readPolicy) {
        this.readPolicy = readPolicy;
    }

    @Override
    public Boolean getErrorOnWritePolicyFailure() {
        return this.errorOnWritePolicyFailure;
    }

    @Override
    public void setErrorOnWritePolicyFailure(Boolean errorOnWritePolicyFailure) {
        this.errorOnWritePolicyFailure = errorOnWritePolicyFailure;
    }

    @Override
    public Boolean getReturnOnDemand() {
        return this.returnOnDemand;
    }

    @Override
    public void setReturnOnDemand(Boolean returnOnDemand) {
        this.returnOnDemand = returnOnDemand;
    }

    @Override
    public Integer getPropertyOrder() {
        return this.propertyOrder;
    }

    @Override
    public void setPropertyOrder(Integer order) {
        this.propertyOrder = order;
    }

    @Override
    public void validate(JsonValue object) throws ValidationException {
        if (!object.isBoolean()) {
            throw new ValidationException("Expected boolean, but got " + object.getObject());
        }
    }

    @Override
    @JsonProperty(value="readOnly")
    public Boolean getReadonly() {
        return super.getReadonly();
    }

    @Override
    public Boolean getExample() {
        return this.example;
    }

    @Override
    public void setExample(String example) {
        this.example = Boolean.valueOf(example);
    }
}

