/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.repackaged.org.glassfish.jersey.client;

import com.inwebo.repackaged.com.google.common.base.Function;
import com.inwebo.repackaged.com.google.common.collect.Lists;
import com.inwebo.repackaged.javax.inject.Inject;
import com.inwebo.repackaged.javax.inject.Provider;
import com.inwebo.repackaged.javax.ws.rs.ext.ReaderInterceptor;
import com.inwebo.repackaged.javax.ws.rs.ext.WriterInterceptor;
import com.inwebo.repackaged.org.glassfish.hk2.api.ServiceLocator;
import com.inwebo.repackaged.org.glassfish.jersey.client.ClientRequest;
import com.inwebo.repackaged.org.glassfish.jersey.internal.inject.Providers;
import com.inwebo.repackaged.org.glassfish.jersey.internal.util.collection.Ref;
import com.inwebo.repackaged.org.glassfish.jersey.message.MessageBodyWorkers;
import com.inwebo.repackaged.org.glassfish.jersey.model.internal.RankedComparator;
import java.util.Collections;

public class RequestProcessingInitializationStage
implements Function<ClientRequest, ClientRequest> {
    private final Provider<Ref<ClientRequest>> requestRefProvider;
    private final Provider<MessageBodyWorkers> workersProvider;
    private final Iterable<WriterInterceptor> writerInterceptors;
    private final Iterable<ReaderInterceptor> readerInterceptors;

    @Inject
    public RequestProcessingInitializationStage(Provider<Ref<ClientRequest>> requestRefProvider, Provider<MessageBodyWorkers> workersProvider, ServiceLocator locator) {
        this.requestRefProvider = requestRefProvider;
        this.workersProvider = workersProvider;
        this.writerInterceptors = Collections.unmodifiableList(Lists.newArrayList(Providers.getAllProviders(locator, WriterInterceptor.class, new RankedComparator())));
        this.readerInterceptors = Collections.unmodifiableList(Lists.newArrayList(Providers.getAllProviders(locator, ReaderInterceptor.class, new RankedComparator())));
    }

    @Override
    public ClientRequest apply(ClientRequest requestContext) {
        this.requestRefProvider.get().set(requestContext);
        requestContext.setWorkers(this.workersProvider.get());
        requestContext.setWriterInterceptors(this.writerInterceptors);
        requestContext.setReaderInterceptors(this.readerInterceptors);
        return requestContext;
    }
}

