/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import java.io.Closeable;

public abstract class ReferenceCountedObject<T> {
    private T instance;
    private final Object lock = new Object();
    private int refCount;

    protected ReferenceCountedObject() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Reference<T> acquire() {
        Object object = this.lock;
        synchronized (object) {
            if (this.refCount++ == 0) {
                assert (this.instance == null);
                this.instance = this.newInstance();
            }
            assert (this.instance != null);
            return new Reference(this, this.instance);
        }
    }

    public final Reference<T> acquireIfNull(T value) {
        return value != null ? new Reference<T>(this, value) : this.acquire();
    }

    protected abstract void destroyInstance(T var1);

    protected abstract T newInstance();

    public static final class Reference<T>
    implements Closeable {
        private volatile T value;
        private final ReferenceCountedObject<T> container;

        private Reference(ReferenceCountedObject<T> container, T value) {
            this.container = container;
            this.value = value;
        }

        public T get() {
            if (this.value == null) {
                throw new NullPointerException();
            }
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            Object instanceToRelease = null;
            Object object = ((ReferenceCountedObject)this.container).lock;
            synchronized (object) {
                if (this.value != null) {
                    if (((ReferenceCountedObject)this.container).instance == this.value && --((ReferenceCountedObject)this.container).refCount == 0) {
                        instanceToRelease = this.value;
                        ((ReferenceCountedObject)this.container).instance = null;
                    }
                    this.value = null;
                }
            }
            if (instanceToRelease != null) {
                this.container.destroyInstance(instanceToRelease);
            }
        }

        protected void finalize() {
            this.release();
        }

        @Override
        public void close() {
            this.release();
        }
    }
}

