/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public final class PackedLong {
    public static final int MAX_COMPACT_SIZE = 8;
    private static final int[] DECODE_SIZE = new int[256];
    public static final long COMPACTED_MAX_VALUE = 0xFFFFFFFFFFFFFFL;

    private PackedLong() {
    }

    public static int writeCompactUnsigned(OutputStream os, long value) throws IOException {
        int size = PackedLong.getEncodedSize(value);
        switch (size) {
            case 1: {
                os.write((int)value);
                break;
            }
            case 2: {
                os.write((int)(value >>> 8 | 0x80L));
                os.write((int)value);
                break;
            }
            case 3: {
                os.write((int)(value >>> 16 | 0xC0L));
                os.write((int)(value >>> 8));
                os.write((int)value);
                break;
            }
            case 4: {
                os.write((int)(value >>> 24 | 0xE0L));
                os.write((int)(value >>> 16));
                os.write((int)(value >>> 8));
                os.write((int)value);
                break;
            }
            case 5: {
                os.write((int)(value >>> 32 | 0xF0L));
                os.write((int)(value >>> 24));
                os.write((int)(value >>> 16));
                os.write((int)(value >>> 8));
                os.write((int)value);
                break;
            }
            case 6: {
                os.write((int)(value >>> 40 | 0xF8L));
                os.write((int)(value >>> 32));
                os.write((int)(value >>> 24));
                os.write((int)(value >>> 16));
                os.write((int)(value >>> 8));
                os.write((int)value);
                break;
            }
            case 7: {
                os.write((int)(value >>> 48 | 0xFCL));
                os.write((int)(value >>> 40));
                os.write((int)(value >>> 32));
                os.write((int)(value >>> 24));
                os.write((int)(value >>> 16));
                os.write((int)(value >>> 8));
                os.write((int)value);
                break;
            }
            case 8: {
                os.write(254);
                os.write((int)(value >>> 48));
                os.write((int)(value >>> 40));
                os.write((int)(value >>> 32));
                os.write((int)(value >>> 24));
                os.write((int)(value >>> 16));
                os.write((int)(value >>> 8));
                os.write((int)value);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return size;
    }

    public static int getEncodedSize(long value) {
        if (value < 128L) {
            return 1;
        }
        if (value < 16384L) {
            return 2;
        }
        if (value < 0x200000L) {
            return 3;
        }
        if (value < 0x10000000L) {
            return 4;
        }
        if (value < 0x800000000L) {
            return 5;
        }
        if (value < 0x40000000000L) {
            return 6;
        }
        if (value < 0x2000000000000L) {
            return 7;
        }
        if (value < 0x100000000000000L) {
            return 8;
        }
        throw new IllegalArgumentException("value out of range: " + value);
    }

    public static long readCompactUnsignedLong(InputStream is) throws IOException {
        long value;
        int b0 = PackedLong.checkNotEndOfStream(is.read());
        int size = PackedLong.decodeSize(b0);
        switch (size) {
            case 1: {
                value = PackedLong.b2l((byte)b0);
                break;
            }
            case 2: {
                value = ((long)b0 & 0x3FL) << 8;
                value |= (long)PackedLong.checkNotEndOfStream(is.read());
                break;
            }
            case 3: {
                value = ((long)b0 & 0x1FL) << 16;
                value |= (long)PackedLong.checkNotEndOfStream(is.read()) << 8;
                value |= (long)PackedLong.checkNotEndOfStream(is.read());
                break;
            }
            case 4: {
                value = ((long)b0 & 0xFL) << 24;
                value |= (long)PackedLong.checkNotEndOfStream(is.read()) << 16;
                value |= (long)PackedLong.checkNotEndOfStream(is.read()) << 8;
                value |= (long)is.read();
                break;
            }
            case 5: {
                value = ((long)b0 & 7L) << 32;
                value |= (long)PackedLong.checkNotEndOfStream(is.read()) << 24;
                value |= (long)PackedLong.checkNotEndOfStream(is.read()) << 16;
                value |= (long)PackedLong.checkNotEndOfStream(is.read()) << 8;
                value |= (long)is.read();
                break;
            }
            case 6: {
                value = ((long)b0 & 3L) << 40;
                value |= (long)PackedLong.checkNotEndOfStream(is.read()) << 32;
                value |= (long)PackedLong.checkNotEndOfStream(is.read()) << 24;
                value |= (long)PackedLong.checkNotEndOfStream(is.read()) << 16;
                value |= (long)PackedLong.checkNotEndOfStream(is.read()) << 8;
                value |= (long)is.read();
                break;
            }
            case 7: {
                value = ((long)b0 & 1L) << 48;
                value |= (long)PackedLong.checkNotEndOfStream(is.read()) << 40;
                value |= (long)PackedLong.checkNotEndOfStream(is.read()) << 32;
                value |= (long)PackedLong.checkNotEndOfStream(is.read()) << 24;
                value |= (long)PackedLong.checkNotEndOfStream(is.read()) << 16;
                value |= (long)PackedLong.checkNotEndOfStream(is.read()) << 8;
                value |= (long)is.read();
                break;
            }
            default: {
                value = (long)PackedLong.checkNotEndOfStream(is.read()) << 48;
                value |= (long)PackedLong.checkNotEndOfStream(is.read()) << 40;
                value |= (long)PackedLong.checkNotEndOfStream(is.read()) << 32;
                value |= (long)PackedLong.checkNotEndOfStream(is.read()) << 24;
                value |= (long)PackedLong.checkNotEndOfStream(is.read()) << 16;
                value |= (long)PackedLong.checkNotEndOfStream(is.read()) << 8;
                value |= (long)is.read();
            }
        }
        return value;
    }

    private static int checkNotEndOfStream(int byteValue) {
        if (byteValue == -1) {
            throw new IllegalArgumentException("End of stream reached.");
        }
        return byteValue;
    }

    private static int decodeSize(int b) {
        return DECODE_SIZE[b & 0xFF];
    }

    private static long b2l(byte b) {
        return (long)b & 0xFFL;
    }

    static {
        Arrays.fill(DECODE_SIZE, 0, 128, 1);
        Arrays.fill(DECODE_SIZE, 128, 192, 2);
        Arrays.fill(DECODE_SIZE, 192, 224, 3);
        Arrays.fill(DECODE_SIZE, 224, 240, 4);
        Arrays.fill(DECODE_SIZE, 240, 248, 5);
        Arrays.fill(DECODE_SIZE, 248, 252, 6);
        Arrays.fill(DECODE_SIZE, 252, 254, 7);
        Arrays.fill(DECODE_SIZE, 254, 256, 8);
    }
}

