/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.CliMessages;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.i18n.LocalizableMessageBuilder;

public final class MultiChoiceArgument<V>
extends Argument {
    private final Collection<V> allowedValues;

    public static <V> Builder<V> builder(String longIdentifier) {
        return new Builder(longIdentifier);
    }

    private <V1> MultiChoiceArgument(Builder<V1> builder, Collection<V> allowedValues) {
        super(builder);
        this.allowedValues = allowedValues;
    }

    public V getTypedValue() throws ArgumentException {
        String v = super.getValue();
        if (v == null) {
            return null;
        }
        for (V allowedValue : this.allowedValues) {
            if (!allowedValue.toString().equalsIgnoreCase(v)) continue;
            return allowedValue;
        }
        throw new IllegalStateException("This MultiChoiceArgument value is not part of the allowed values.");
    }

    @Override
    public boolean valueIsAcceptable(String valueString, LocalizableMessageBuilder invalidReason) {
        for (V allowedValue : this.allowedValues) {
            if (!allowedValue.toString().equalsIgnoreCase(valueString)) continue;
            return true;
        }
        invalidReason.append(CliMessages.ERR_MCARG_VALUE_NOT_ALLOWED.get(this.longIdentifier, valueString));
        return false;
    }

    public static final class Builder<V>
    extends Argument.ArgumentBuilder<Builder<V>, V, MultiChoiceArgument<V>> {
        private final List<V> allowedValues = new LinkedList<V>();

        private Builder(String longIdentifier) {
            super(longIdentifier);
        }

        @Override
        Builder<V> getThis() {
            return this;
        }

        public Builder<V> allowedValues(Collection<V> allowedValues) {
            this.allowedValues.addAll(allowedValues);
            return this.getThis();
        }

        public final Builder<V> allowedValues(V ... allowedValues) {
            this.allowedValues.addAll(Arrays.asList(allowedValues));
            return this.getThis();
        }

        @Override
        public MultiChoiceArgument<V> buildArgument() {
            return new MultiChoiceArgument(this, this.allowedValues);
        }
    }
}

