/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ArgumentsBuilder {
    private final List<String> args = new ArrayList<String>();

    public static ArgumentsBuilder arguments(String ... args) {
        ArgumentsBuilder argumentsBuilder = new ArgumentsBuilder();
        for (String arg : args) {
            argumentsBuilder.add(arg);
        }
        return argumentsBuilder;
    }

    public ArgumentsBuilder add(String arg) {
        this.args.add(arg);
        return this;
    }

    public ArgumentsBuilder add(String arg, Object value) {
        this.args.add(arg);
        this.args.add(value.toString());
        return this;
    }

    public ArgumentsBuilder addIfNotNull(String arg, Object value) {
        if (value != null) {
            this.add(arg, value);
        }
        return this;
    }

    public ArgumentsBuilder addAllowEmptyValue(String argument, Object argumentValue) {
        if (argumentValue == null || argumentValue.toString().isEmpty()) {
            this.add(argument);
        } else {
            this.add(argument, argumentValue);
        }
        return this;
    }

    public ArgumentsBuilder addAll(String ... args) {
        Collections.addAll(this.args, args);
        return this;
    }

    public ArgumentsBuilder addAll(ArgumentsBuilder args) {
        this.args.addAll(args.args);
        return this;
    }

    public String[] toArray() {
        return this.args.toArray(new String[0]);
    }

    public List<String> toList() {
        return new ArrayList<String>(this.args);
    }

    public String toString() {
        return this.args.toString();
    }
}

