package com.inwebo.demo_android.utils;

import org.junit.Assert;
import org.junit.Test;

public class InweboUtilsTest {

    @Test
    public void test_is_empty_returns_true_if_string_empty() {
        boolean isEmpty = InweboUtils.isEmpty("");
        Assert.assertTrue(isEmpty);
    }

    @Test
    public void test_is_empty_returns_true_if_string_null() {
        boolean isEmpty = InweboUtils.isEmpty(null);
        Assert.assertTrue(isEmpty);
    }

    @Test
    public void test_is_empty_returns_false_if_string_not_empty() {
        boolean isEmpty = InweboUtils.isEmpty("not empty");
        Assert.assertFalse(isEmpty);
    }

    @Test
    public void test_is_pin_valid_returns_false_if_string_is_null() {
        boolean isEmpty = InweboUtils.isPinValid(null);
        Assert.assertFalse(isEmpty);
    }

    @Test
    public void test_is_pin_valid_returns_false_if_string_is_too_short() {
        boolean isEmpty = InweboUtils.isPinValid("0");
        Assert.assertFalse(isEmpty);
    }

    @Test
    public void test_is_pin_valid_returns_false_if_string_is_too_long() {
        boolean isEmpty = InweboUtils.isPinValid("1234567");
        Assert.assertFalse(isEmpty);
    }

    @Test
    public void test_is_pin_valid_returns_true_if_string_is_correct_size() {
        boolean isEmpty = InweboUtils.isPinValid("12345");
        Assert.assertTrue(isEmpty);
    }
}
