package com.inwebo.demo_android.ui;

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.inwebo.demo_android.R;

import java.util.List;

public class MenuAdapter extends ArrayAdapter<MenuItem> {

    private final Context context;

    public MenuAdapter(List<MenuItem> items, @NonNull Context context) {
        super(context, R.layout.service_list_item, items);
        this.context = context;
    }

    @NonNull
    @Override
    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        super.getView(position, convertView, parent);

        MenuItem menuItem = getItem(position);

        if (convertView == null) {
            convertView = LayoutInflater.from(getContext()).inflate(R.layout.service_list_item, parent, false);
        }

        TextView title = convertView.findViewById(R.id.menu_title);
        title.setText(menuItem.getTitle());

        convertView.setOnClickListener(v -> {
            Intent synchronizeIntent = new Intent(context, menuItem.getClazz());
            context.startActivity(synchronizeIntent);
        });

        return convertView;
    }
}
