package com.inwebo.demo_android.firebase;

import android.util.Log;

import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;

import java.util.Map;

import androidx.annotation.NonNull;
import androidx.lifecycle.MutableLiveData;

public class IWFirebaseMessagingService extends FirebaseMessagingService {
    private final String TAG = IWFirebaseMessagingService.class.getSimpleName();

    private static final MutableLiveData<Map<String, String>> IN_APP_MESSAGE = new MutableLiveData<>();
    public static MutableLiveData<Map<String, String>> getInAppMessage() {
        return IN_APP_MESSAGE;
    }

    private static final MutableLiveData<String> TOKEN = new MutableLiveData<>();
    public static MutableLiveData<String> getNewToken() {
        return TOKEN;
    }

    @Override
    public void onMessageReceived(RemoteMessage remoteMessage) {
        // Not getting messages here? See why this may be: https://goo.gl/39bRNJ
        Log.d(TAG, "From: " + remoteMessage.getFrom());

        // Check if message contains a notification payload.
        if (remoteMessage.getNotification() != null) {
            Log.d(TAG, "Message Notification Body: " + remoteMessage.getNotification().getBody());
        }

        handleMessage(remoteMessage);
    }

    @Override
    public void onNewToken(@NonNull String token) {
        super.onNewToken(token);
        TOKEN.postValue(token);
    }

    public void handleMessage(RemoteMessage message) {
        IN_APP_MESSAGE.postValue(message.getData());
    }
}
