/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.iwlib;

import com.inwebo.iwlib.Data;
import com.inwebo.iwlib.IW;
import com.inwebo.iwlib.Stack;
import com.inwebo.iwlib.Util;
import com.inwebo.iwlib.security.SecureRandom;
import com.inwebo.iwlib.security.Sha256;

public class Otp {
    long option;
    SecureRandom rnd;
    int serviceid;
    String secret;
    String ksc;
    String secure;
    String lastJ;
    String lastK;
    String lastH;
    long lastTref;
    long retry;
    static long Fi = 97841L;
    static long Fj = 88813L;
    static long Fk = 77263L;
    static long delta2 = 45L;
    static String[] base36 = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};

    private static long s4a() {
        return 5L * delta2;
    }

    private static long s4b() {
        return 13L * delta2;
    }

    private static long s4c() {
        return 20L * delta2;
    }

    public static long displayTime() {
        return delta2 - 5L;
    }

    public Otp(Data data, int srvid, long time70) {
        this.secure = data.iwsrvsecure[srvid];
        this.ksc = data.iwsrvksc[srvid];
        this.option = this.secure.substring(0, 1).compareTo("b") != 0 ? 1L : 2L;
        this.serviceid = srvid;
        this.secret = data.getSecret(data.iwsrvid[srvid]);
        this.rnd = new SecureRandom();
        this.lastJ = data.iwJ;
        this.lastK = data.iwK;
        this.lastH = data.iwH;
        this.lastTref = data.iwTref;
        if (data.iwcancelpin == 1L && this.option == 1L) {
            this.option = 2L;
        }
        if (data.iwnboka >= 5L && this.option == 1L) {
            this.option = 2L;
        }
        this.retry = 0L;
        if (time70 - data.iwlastt1 < Otp.s4a()) {
            this.retry = 1L;
        }
        if (time70 - data.iwlastt2 < Otp.s4b()) {
            this.retry = 1L;
        }
        if (time70 - data.iwlastt3 < Otp.s4c()) {
            this.retry = 1L;
        }
        if (this.retry == 1L) {
            if (this.option == 1L) {
                this.option = 3L;
            } else if (this.option == 2L) {
                this.option = 4L;
            }
            if (data.iwlastbp > 0L) {
                this.option = 4L;
            }
            if (this.option == 3L || this.option == 4L) {
                Stack stack = new Stack("", 4, 0L);
                data.iwstack = stack.tostring();
            }
        }
        data.dataTouch();
    }

    public boolean getPinrequired() {
        return this.option != 1L;
    }

    public static String tobase36(long x, int n) {
        String res = "";
        for (int i = 0; i < n; ++i) {
            long q = x / 36L;
            long d = x - q * 36L;
            res = res + base36[(int)d];
            x = q;
        }
        return res;
    }

    public static String tobase10(long x, int n) {
        String res = "" + x;
        while (res.length() < n) {
            res = "0" + res;
        }
        return res;
    }

    long _nrfromformat(String format) {
        if (format.compareTo("6LC") == 0) {
            return 11L;
        }
        if (format.compareTo("7LC") == 0) {
            return 15L;
        }
        if (format.compareTo("8LC") == 0) {
            return 18L;
        }
        if (format.compareTo("7C") == 0) {
            return 9L;
        }
        if (format.compareTo("8C") == 0) {
            return 9L;
        }
        return 11L;
    }

    long _n1fromformat(String format) {
        if (format.compareTo("6LC") == 0) {
            return 9L;
        }
        if (format.compareTo("7LC") == 0) {
            return 10L;
        }
        if (format.compareTo("8LC") == 0) {
            return 12L;
        }
        if (format.compareTo("7C") == 0) {
            return 7L;
        }
        if (format.compareTo("8C") == 0) {
            return 7L;
        }
        return 9L;
    }

    long _n2fromformat(String format) {
        if (format.compareTo("6LC") == 0) {
            return 11L;
        }
        if (format.compareTo("7LC") == 0) {
            return 11L;
        }
        if (format.compareTo("8LC") == 0) {
            return 11L;
        }
        if (format.compareTo("7C") == 0) {
            return 7L;
        }
        if (format.compareTo("8C") == 0) {
            return 10L;
        }
        return 11L;
    }

    String _encodefromformat(String format, long res) {
        if (format.compareTo("6LC") == 0) {
            return Otp.tobase36(res, 6);
        }
        if (format.compareTo("7LC") == 0) {
            return Otp.tobase36(res, 7);
        }
        if (format.compareTo("8LC") == 0) {
            return Otp.tobase36(res, 8);
        }
        if (format.compareTo("7C") == 0) {
            return Otp.tobase10(res, 7);
        }
        if (format.compareTo("8C") == 0) {
            return Otp.tobase10(res, 8);
        }
        return Otp.tobase36(res, 6);
    }

    long otprand(long n) {
        long v = this.rnd.nextInt();
        return v &= (long)((1 << (int)n) - 1);
    }

    long E_x(String K1, long rand, long option, long n) {
        String src = K1 + ":" + rand + ":" + option;
        long v = Sha256.sha256int(src);
        IW.log("M1=" + (v &= (long)((1 << (int)n) - 1)) + "]" + src);
        return v;
    }

    String F_x(String J, String K, String K1, long rand, long option, String pin, long constant) {
        String v = "" + K1 + ":" + rand + ":" + constant;
        v = option != 1L ? v + ":" + pin : v + ":" + J;
        if (option != 4L) {
            v = v + ":" + K;
        }
        IW.log("F_x]" + v);
        return Sha256.sha256_128(v);
    }

    long G_x(String I, String J, String K, long rand, long option, long rhodt, String secret, String h, long n) {
        String src = I + ":" + J + ":" + K + ":" + secret + ":" + rhodt + ":" + h;
        long v = Sha256.sha256int(src);
        IW.log("M2=" + (v &= (long)((1 << (int)n) - 1)) + "]" + src);
        return v;
    }

    long rho(long dt) {
        long lambda = dt / 45L;
        return lambda;
    }

    long concat(long M1, long M2, long rand, long n2, long nr) {
        long res = M1;
        long k = 1 << (int)n2;
        res *= k;
        res += M2;
        k = 1 << (int)nr;
        res *= k;
        return res += rand;
    }

    long randselect(String K1, long nr, Stack stackrand, long n1) {
        boolean nok = true;
        long rand = 0L;
        while (nok) {
            nok = false;
            rand = this.otprand(nr);
            if (rand == 0L || stackrand.contains(rand)) {
                nok = true;
            }
            if (nok) continue;
            long M1A = this.E_x(K1, rand, 1L, n1);
            long M1B1 = this.E_x(K1, rand, 2L, n1);
            long M1B2 = this.E_x(K1, rand, 3L, n1);
            long M1Bp = this.E_x(K1, rand, 4L, n1);
            if (M1B1 == M1A) {
                nok = true;
            }
            if (M1B2 == M1A) {
                nok = true;
            }
            if (M1B2 == M1B1) {
                nok = true;
            }
            if (M1Bp == M1A) {
                nok = true;
            }
            if (M1Bp == M1B1) {
                nok = true;
            }
            if (M1Bp != M1B2) continue;
            nok = true;
        }
        return rand;
    }

    public long generateUsingFormat(IW iw, String pin, long time70, String format, String Kma) {
        Data data = iw.data;
        String unsync = this.secure.substring(1, 2);
        long nr = this._nrfromformat(format);
        long n1 = this._n1fromformat(format);
        long n2 = this._n2fromformat(format);
        Stack stackrand = new Stack(data.iwstackrand, 10, 0L);
        Stack stack = new Stack(data.iwstack, 4, 0L);
        String tJ = data.iwJ;
        String tK = data.iwK;
        if (this.option != 1L) {
            tJ = Util.decodeAesFromHex128(tJ, Kma);
            tK = Util.decodeAesFromHex128(tK, Kma);
            this.secret = Util.decodeAesFromHex128(this.secret, Kma);
        }
        long rand = this.randselect(data.iwK1, nr, stackrand, n1);
        stackrand.push(rand);
        data.iwstackrand = stackrand.tostring();
        stack.push(rand);
        data.iwstack = stack.tostring();
        long randh = stack.last();
        if (randh != 0L) {
            String src = "" + data.iwH + ":" + randh;
            data.iwH = "" + Sha256.sha256_128(src);
            IW.log("H from " + src);
        }
        long M1 = this.E_x(data.iwK1, rand, this.option, n1);
        String ttI = this.F_x(tJ, tK, data.iwK1, rand, this.option, pin, Fi);
        String ttJ = tJ;
        if (this.option != 1L) {
            ttJ = this.F_x(tJ, tK, data.iwK1, rand, this.option, pin, Fj);
        }
        String ttK = tK;
        if (this.option == 4L) {
            ttK = this.F_x(tJ, tK, data.iwK1, rand, this.option, pin, Fk);
        }
        long nt = time70;
        long dt = nt - data.iwTref;
        IW.log("nr " + nr);
        IW.log("n1 " + n1);
        IW.log("n2 " + n2);
        IW.log("nt " + nt);
        IW.log("dt " + dt);
        long rhodt = this.rho(dt);
        rhodt += (long)iw.deltarhodt;
        if (this.retry == 1L && unsync.compareTo("U") == 0 && !iw.nounsync) {
            rhodt = -99L;
        }
        long M2 = this.G_x(ttI, ttJ, ttK, rand, this.option, rhodt, this.secret, data.iwH, n2);
        if (this.option != 1L) {
            tJ = Util.encodeAesFromHex(ttJ, Kma);
            tK = Util.encodeAesFromHex(ttK, Kma);
        }
        data.iwJ = tJ;
        data.iwK = tK;
        data.iwTref = nt;
        long res = this.concat(M1, M2, rand, n2, nr);
        IW.log("rhodt=" + rhodt);
        IW.log("option=" + this.option);
        IW.log("rand=" + rand);
        IW.log("m1=" + M1);
        IW.log("m2=" + M2);
        IW.log("res=" + res);
        data.iwlastt3 = data.iwlastt2;
        data.iwlastt2 = data.iwlastt1;
        data.iwlastt1 = time70;
        data.iwlastbp = this.option == 4L ? 3L : --data.iwlastbp;
        if (data.iwlastbp < 0L) {
            data.iwlastbp = 0L;
        }
        data.dataTouch();
        return res;
    }

    public String generate(IW iw, String pin, long time70) {
        String format = this.secure.substring(3);
        String Kma = iw.generateKma(pin);
        long res = this.generateUsingFormat(iw, pin, time70, format, Kma);
        return this._encodefromformat(format, res);
    }

    public void result(Data d, long result) {
        d.iwcancelpin = 0L;
        d.iwcancelpin = result == 1L && this.option != 1L ? 1L : 0L;
        d.iwnboka = result != 1L && this.option == 1L ? ++d.iwnboka : 0L;
        if (result == 1L) {
            Stack stack = new Stack(d.iwstack, 4, 0L);
            stack.clearfirst();
            d.iwstack = stack.tostring();
            d.iwJ = this.lastJ;
            d.iwK = this.lastK;
            d.iwTref = this.lastTref;
            d.iwH = this.lastH;
        }
        d.dataTouch();
    }
}

