/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.iwlib.security;

import com.inwebo.iwlib.security.crypto.digests.SHA1Digest;
import com.inwebo.iwlib.security.crypto.digests.SHA256Digest;
import com.inwebo.iwlib.security.crypto.prng.DigestRandomGenerator;
import com.inwebo.iwlib.security.crypto.prng.RandomGenerator;
import java.util.Random;

public class SecureRandom
extends Random {
    private static final RandomGenerator sha1Generator = new DigestRandomGenerator(new SHA1Digest());
    private static final RandomGenerator sha256Generator = new DigestRandomGenerator(new SHA256Digest());
    protected RandomGenerator generator;

    public SecureRandom() {
        this(sha1Generator);
        this.setSeed(System.currentTimeMillis());
    }

    public SecureRandom(byte[] inSeed) {
        this(sha1Generator);
        this.setSeed(inSeed);
    }

    protected SecureRandom(RandomGenerator generator) {
        super(0L);
        this.generator = generator;
    }

    public static SecureRandom getInstance(String algorithm) {
        if (algorithm.equals("SHA1PRNG")) {
            return new SecureRandom(sha1Generator);
        }
        if (algorithm.equals("SHA256PRNG")) {
            return new SecureRandom(sha256Generator);
        }
        return new SecureRandom();
    }

    public static SecureRandom getInstance(String algorithm, String provider) {
        return SecureRandom.getInstance(algorithm);
    }

    public static byte[] getSeed(int numBytes) {
        byte[] rv = new byte[numBytes];
        sha1Generator.addSeedMaterial(System.currentTimeMillis());
        sha1Generator.nextBytes(rv);
        return rv;
    }

    public byte[] generateSeed(int numBytes) {
        byte[] rv = new byte[numBytes];
        this.nextBytes(rv);
        return rv;
    }

    public void setSeed(byte[] inSeed) {
        this.generator.addSeedMaterial(inSeed);
    }

    @Override
    public void nextBytes(byte[] bytes) {
        this.generator.nextBytes(bytes);
    }

    @Override
    public void setSeed(long rSeed) {
        if (rSeed != 0L) {
            this.generator.addSeedMaterial(rSeed);
        }
    }

    @Override
    public int nextInt() {
        byte[] intBytes = new byte[4];
        this.nextBytes(intBytes);
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result = (result << 8) + (intBytes[i] & 0xFF);
        }
        return result;
    }

    @Override
    protected final int next(int numBits) {
        int size = (numBits + 7) / 8;
        byte[] bytes = new byte[size];
        this.nextBytes(bytes);
        int result = 0;
        for (int i = 0; i < size; ++i) {
            result = (result << 8) + (bytes[i] & 0xFF);
        }
        return result & (1 << numBits) - 1;
    }
}

