package com.inwebo.demo_android.network;

import android.app.Activity;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * InweboPromise was designed to handle webservices calls from Inwebo
 * These calls always return a long response ID
 * The activity parameter is needed to act on the UI Thread depending on the webservice result
 * It also overrides fulfillInAsync because we always need to use a singleThread
 */
public class InweboPromise extends Promise<Long> {

    private final Activity activity;

    private InweboPromise(Activity activity) {
        this.activity = activity;
    }

    public static InweboPromise with(Activity activity) {
        return new InweboPromise(activity);
    }

    public Promise<Long> fulfillInAsync(Callable<Long> task) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Promise<Long> promise = super.fulfillInAsync(task, executorService);
        executorService.shutdown();
        return promise;
    }

    @Override
    protected void handleException(Exception exception) {
        this.activity.runOnUiThread(() -> super.handleException(exception));
    }

    @Override
    protected void postFulfillment() {
        this.activity.runOnUiThread(super::postFulfillment);
    }
}
