/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.iwlib.security;

import com.inwebo.iwlib.IW;
import com.inwebo.iwlib.Util;
import com.inwebo.iwlib.security.crypto.digests.SHA256Digest;
import java.io.UnsupportedEncodingException;

public class Sha256 {
    public static String sha256(String src) {
        byte[] tsrc = src.getBytes();
        SHA256Digest digest = new SHA256Digest();
        digest.reset();
        digest.update(tsrc, 0, tsrc.length);
        byte[] shaResult = new byte[digest.getDigestSize()];
        digest.doFinal(shaResult, 0);
        return Util.byteToHex(shaResult);
    }

    public static String sha256_128(String src) {
        return Sha256.sha256(src).substring(0, 32);
    }

    public static int sha256int(String src) {
        byte[] tsrc;
        try {
            tsrc = src.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            IW.log("unsupported UTF-8");
            tsrc = src.getBytes();
        }
        SHA256Digest digest = new SHA256Digest();
        digest.reset();
        digest.update(tsrc, 0, tsrc.length);
        byte[] shaResult = new byte[digest.getDigestSize()];
        digest.doFinal(shaResult, 0);
        int val = 0;
        for (int i = 0; i < 4; ++i) {
            int x = shaResult[i] & 0xFF;
            val = (val << 8) + x;
        }
        return val & Integer.MAX_VALUE;
    }
}

