/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.iwlib;

import com.inwebo.iwlib.IW;
import com.inwebo.iwlib.security.Aes128;
import com.inwebo.iwlib.security.SecureRandom;
import com.inwebo.iwlib.security.crypto.digests.SHA256Digest;
import com.inwebo.iwlib.security.util.encoders.Hex;
import java.io.UnsupportedEncodingException;

public class Util {
    public static long time70() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long atoi(String s) {
        try {
            if (s == null) {
                return 0L;
            }
            if (s.length() == 0) {
                return 0L;
            }
            long x = Integer.parseInt(s);
            return x;
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    public static String byteToHex(byte[] src) {
        StringBuffer dst = new StringBuffer();
        for (int i = 0; i < src.length; ++i) {
            String s = Integer.toHexString(src[i]);
            if (s.length() > 2) {
                s = s.substring(s.length() - 2);
            } else if (s.length() < 2) {
                s = "0" + s;
            }
            dst.append(s);
        }
        return dst.toString();
    }

    public static String urlencode(String src) {
        byte[] buf = src.getBytes();
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            byte c = buf[i];
            byte[] b = new byte[]{c};
            if (c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90) {
                res.append(new String(b));
                continue;
            }
            if (c == 32) {
                res.append("+");
                continue;
            }
            res.append("%");
            res.append(Util.byteToHex(b));
        }
        return res.toString();
    }

    public static String encodeAesFromHex(String val, String key) {
        if (val == null || val.length() == 0) {
            return "";
        }
        if (val.length() % 32 != 0) {
            return "";
        }
        byte[] data = Hex.decode(val);
        Aes128 aes = new Aes128(key);
        byte[] out = aes.crypt(data);
        return new String(Hex.encode(out));
    }

    private static String decodeAesFromHex(String val, String key, int n) {
        if (val == null || val.length() == 0) {
            return "";
        }
        Aes128 aes = new Aes128(key);
        byte[] data = Hex.decode(val);
        byte[] out = aes.uncrypt(data);
        if (out == null) {
            return null;
        }
        String res = new String(Hex.encode(out));
        return res.substring(0, n / 4);
    }

    public static String decodeAesFromHex128(String val, String key) {
        return Util.decodeAesFromHex(val, key, 128);
    }

    public static String rand128(SecureRandom r) {
        if (r == null) {
            r = new SecureRandom();
        }
        byte[] tK1 = new byte[16];
        for (int i = 0; i < tK1.length; ++i) {
            tK1[i] = (byte)(r.nextInt(256) - 128);
        }
        return Util.byteToHex(tK1);
    }

    public static boolean checkPin(IW iw, String pin) {
        int i;
        if (iw.IsMac()) {
            return true;
        }
        if (pin.isEmpty() && iw.PinMode() == 0L) {
            return true;
        }
        if (pin.length() < 4 || pin.length() > 6) {
            return false;
        }
        for (i = 0; i < pin.length(); ++i) {
            if (pin.charAt(i) >= '0' && pin.charAt(i) <= '9') continue;
            return false;
        }
        for (i = 1; i < pin.length(); ++i) {
            if (pin.charAt(i) == pin.charAt(0)) continue;
            return true;
        }
        return false;
    }

    public static long sha256int38(String src) {
        byte[] tsrc = src.getBytes();
        SHA256Digest digest = new SHA256Digest();
        digest.reset();
        digest.update(tsrc, 0, tsrc.length);
        byte[] shaResult = new byte[digest.getDigestSize()];
        digest.doFinal(shaResult, 0);
        long val28 = 0L;
        for (int i = 0; i < 4; ++i) {
            long x = shaResult[i] & 0xFF;
            val28 = (val28 << 8) + x;
        }
        long val10 = 0L;
        for (int i = 0; i < 4; ++i) {
            long x = shaResult[i + 4] & 0xFF;
            val10 = (val10 << 8) + x;
        }
        return (val28 &= 0xFFFFFFFL) * 1024L + (val10 &= 0x3FFL);
    }

    public static long sha256int64(String src) {
        byte[] tsrc;
        try {
            tsrc = src.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            IW.log("unsupported UTF-8");
            tsrc = src.getBytes();
        }
        SHA256Digest digest = new SHA256Digest();
        digest.reset();
        digest.update(tsrc, 0, tsrc.length);
        byte[] shaResult = new byte[digest.getDigestSize()];
        digest.doFinal(shaResult, 0);
        long valhi = 0L;
        for (int i = 0; i < 4; ++i) {
            long x = shaResult[i] & 0xFF;
            valhi = (valhi << 8) + x;
        }
        long vallo = 0L;
        for (int i = 0; i < 4; ++i) {
            long x = shaResult[i + 4] & 0xFF;
            vallo = (vallo << 8) + x;
        }
        long shift = 0x100000000L;
        return valhi * shift + vallo;
    }
}

