package com.inwebo.demo_android.utils;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.TextView;

import com.inwebo.demo_android.MenuActivity;
import com.inwebo.demo_android.R;
import com.inwebo.iwlib.IW;

/**
 * InweboUiUtils defines methods that act with the UI and used in the majority of the classes
 */
public class InweboUiUtils {
    private InweboUiUtils() {
        // empty constructor to hide the implicit one
    }

    public static void hideKeyboard(Context context, View view) {
        InputMethodManager imm = (InputMethodManager) context.getSystemService(Context.INPUT_METHOD_SERVICE);
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static TextView.OnEditorActionListener performClickOnUserBlur(Button actionButton) {
        return (v, actionId, event) -> {
            if ((event != null && (event.getKeyCode() == KeyEvent.KEYCODE_ENTER))
                    || (actionId == EditorInfo.IME_ACTION_DONE)
                    || (actionId == EditorInfo.IME_ACTION_NEXT)) {
                actionButton.performClick();
            }
            return false;
        };
    }

    public static void showErrorDialogFromResponseId(Context context, long responseId) {
        showErrorDialog(context, errorStringIdFromErrorId(responseId));
    }

    public static void showChoiceDialog(Context context, String title, String message, Runnable onYes, Runnable onNo) {
        AlertDialog alertDialog = new AlertDialog.Builder(context).create();
        alertDialog.setTitle(title);
        alertDialog.setMessage(message);
        alertDialog.setButton(
                AlertDialog.BUTTON_POSITIVE,
                "YES",
                (dialog, which) -> {
                    onYes.run();
                    dialog.dismiss();
                }
        );
        alertDialog.setButton(
                AlertDialog.BUTTON_NEGATIVE,
                "NO",
                (dialog, which) -> {
                    onNo.run();
                    dialog.dismiss();
                }
        );
        alertDialog.show();
    }

    public static void showChoiceDialog(Context context, String message, Runnable onYes, Runnable onNo) {
        showChoiceDialog(context, context.getString(R.string.iw_err), message, onYes, onNo);
    }

    public static void showChoiceDialog(Context context, int messageCode, Runnable onYes, Runnable onNo) {
        showChoiceDialog(context, context.getResources().getString(messageCode), onYes, onNo);
    }

    public static void showInfoDialog(Context context, String title, String text) {
        AlertDialog alertDialog = new AlertDialog.Builder(context).create();
        alertDialog.setTitle(title);
        alertDialog.setMessage(text);
        alertDialog.setButton(
                AlertDialog.BUTTON_POSITIVE,
                "OK",
                (dialog, which) -> {
                    dialog.dismiss();
                }
        );
        alertDialog.show();
    }

    public static void showErrorDialog(Context context, int messageCode) {
        AlertDialog alertDialog = new AlertDialog.Builder(context).create();
        alertDialog.setTitle(R.string.iw_err);
        alertDialog.setMessage(context.getResources().getString(messageCode));
        alertDialog.setButton(
                AlertDialog.BUTTON_NEUTRAL,
                "OK",
                (dialog, which) -> dialog.dismiss()
        );
        alertDialog.show();
    }
    public static void showNetworkErrorDialog(Activity activity) {
        showErrorDialogAndExitActivity(activity, errorStringIdFromErrorId(IW.ERR_NETWORK));
    }

    public static void showErrorDialogAndExitActivity(Activity activity, int messageId) {
        AlertDialog alertDialog = new AlertDialog.Builder(activity).create();
        alertDialog.setTitle(R.string.iw_err);
        alertDialog.setCanceledOnTouchOutside(false);
        alertDialog.setMessage(activity.getResources().getString(messageId));
        alertDialog.setButton(
                AlertDialog.BUTTON_NEUTRAL,
                "OK",
                (dialog, which) -> {
                    dialog.dismiss();
                    Intent mainIntent = new Intent(activity, MenuActivity.class);
                    activity.startActivity(mainIntent);
                    activity.finish();
                }
        );
        alertDialog.show();
    }

    public static int errorStringIdFromErrorId(long err) {
        if (err == IW.ERR_NETWORK) {
            return R.string.iw_err_network;
        } else if (err == IW.ERR_CODE) {
            return R.string.iw_err_code;
        } else if (err == IW.ERR_SN) {
            return R.string.iw_err_sn;
        } else if (err == IW.ERR_ACCESS) {
            return R.string.iw_err_access;
        } else if (err == IW.ERR_VERSION) {
            return R.string.iw_err_version;
        } else if (err == IW.ERR_BLOCKED) {
            return R.string.iw_err_blocked;
        } else if (err == IW.ERR_NODEVICE) {
            return R.string.iw_err_nodevice;
        } else if (err == IW.ERR_MAXNBTOOLS) {
            return R.string.iw_err_maxnbtools;
        } else if (err == IW.ERR_OTHER) {
            return R.string.iw_err_other;
        } else if (err == IW.ERR_FORBIDDEN) {
            return R.string.iw_err_forbidden;
        } else if (err == IW.ERR_BIOKEY) {
            return R.string.iw_err_biokey;
        }
        return R.string.iw_err_other;
    }

    public static void showAlertDialogAndExitApp(Activity activity, int messageId) {
        AlertDialog alertDialog = new AlertDialog.Builder(activity).create();
        alertDialog.setTitle("Alert");
        alertDialog.setMessage(activity.getResources().getString(messageId));
        alertDialog.setButton(
                AlertDialog.BUTTON_NEUTRAL,
                "OK",
                (dialog, which) -> {
                    dialog.dismiss();
                    Intent intent = new Intent(Intent.ACTION_MAIN);
                    intent.addCategory(Intent.CATEGORY_HOME);
                    intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                    activity.startActivity(intent);
                    activity.finish();
                });

        alertDialog.show();
    }
}
