package com.inwebo.demo_android.utils;

import android.content.Context;
import android.os.Build;
import android.provider.Settings;

import java.io.File;
import java.io.IOException;
import java.util.Map;

/**
 * Utils used in the majority of the activities
 */
public class InweboUtils {
    private InweboUtils() {
        // empty constructor to hide the implicit one
    }

    public static boolean isEmpty(String code) {
        return code == null || code.length() == 0;
    }

    public static boolean isPinValid(String pin) {
        return (pin != null) && (pin.length() >= 4) && (pin.length() <= 6);
    }

    public static String phoneName() {
        String modelName = Build.MODEL;
        String manufacturerName = Build.MANUFACTURER.toUpperCase();
        return modelName + " / " + manufacturerName;
    }

    public static String phoneUniqueId(Context context) {
        return Settings.System.getString(context.getContentResolver(), Settings.Secure.ANDROID_ID);
    }

    public static String mapToFormattedString(Map<String, String> map) {
        return map.entrySet().stream()
                .reduce("",
                        (acc, entry) -> acc + entry.getKey() + " : " + entry.getValue() + "\n",
                        String::concat
                );
    }

    public static boolean isDeviceRooted() {
        return isRooted1() || isRooted2() || isRooted3();
    }

    private static boolean isRooted1() {
        String[] paths = {
                "/system/app/Superuser.apk",
                "/sbin/su", "/system/bin/su",
                "/system/xbin/su",
                "/data/local/xbin/su",
                "/data/local/bin/su",
                "/system/sd/xbin/su",
                "/system/bin/failsafe/su",
                "/data/local/su",
                "/su/bin/su"
        };
        for (String path : paths) {
            if (new File(path).exists()) {
                return true;
            }
        }
        return false;
    }

    private static boolean isRooted2() {
        return canExecuteCommand("/system/xbin/which su")
                || canExecuteCommand("su");
    }

    private static boolean isRooted3() {
        String buildTags = android.os.Build.TAGS;
        return buildTags != null && buildTags.contains("test-keys");
    }

    private static boolean canExecuteCommand(String command) {
        try {
            Runtime.getRuntime().exec(command);
            return true;
        } catch (IOException e) {
            return false;
        }
    }
}
