package com.inwebo.demo_android.utils;

import android.content.Context;
import android.util.Log;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;

import static android.content.Context.MODE_PRIVATE;

/**
 * FileUtils implements methods to easily read and write a internal file
 */
public class FileUtils {
    private static final String TAG = "FileUtils";

    private FileUtils() {
        // private constructor to hide the implicit one
    }

    public static String readFile(Context context, String fileName) {
        FileInputStream fis = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;

        try {
            fis = context.openFileInput(fileName);
            inputStreamReader = new InputStreamReader(fis);
            bufferedReader = new BufferedReader(inputStreamReader);
            final StringBuilder sb = new StringBuilder();
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
            }
            return sb.toString();
        } catch (FileNotFoundException e) {
            Log.e(TAG, "File was not found. It may not have been created yet.");
        } catch (IOException e) {
            Log.e(TAG, "cannot load internal data", e);
        } finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                } catch (final Exception e) {
                    Log.e(TAG, "cannot load internal data", e);
                }
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                } catch (final Exception e) {
                    Log.e(TAG, "cannot load internal data", e);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                } catch (final Exception e) {
                    Log.e(TAG, "cannot load internal data", e);
                }
            }
        }
        return null;
    }

    public static void writeData(Context context, String fileName, String val) {
        try (FileOutputStream fos = context.openFileOutput(fileName, MODE_PRIVATE)) {
            fos.write(val.getBytes());
        } catch (final Exception e) {
            Log.e(TAG, "cannot save internal data", e);
        }
    }
}
