/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.iwlib.security;

import com.inwebo.iwlib.IW;
import com.inwebo.iwlib.security.BigInteger;
import com.inwebo.iwlib.security.crypto.encodings.OAEPEncoding;
import com.inwebo.iwlib.security.crypto.engines.RSAEngine;
import com.inwebo.iwlib.security.crypto.params.RSAKeyParameters;
import com.inwebo.iwlib.security.util.encoders.Hex;

public class Oaep {
    OAEPEncoding engine = new OAEPEncoding(new RSAEngine());
    BigInteger ipub;
    static String Kpub = "11";

    public Oaep(String exp) {
        this.ipub = new BigInteger(exp, 16);
    }

    private byte[] process(byte[] data) {
        int n = this.engine.getInputBlockSize();
        int nblock = (data.length + n - 1) / n;
        byte[] out = new byte[nblock * this.engine.getOutputBlockSize()];
        try {
            int j = 0;
            for (int i = 0; i < data.length; i += n) {
                int len = data.length - i;
                if (len > n) {
                    len = n;
                }
                byte[] buf = this.engine.processBlock(data, i, len);
                for (int k = 0; k < buf.length; ++k) {
                    out[j + k] = buf[k];
                }
                j += buf.length;
            }
            if (j != out.length) {
                byte[] out2 = new byte[j];
                for (int i = 0; i < j; ++i) {
                    out2[i] = out[i];
                }
                out = out2;
            }
        }
        catch (Exception e) {
            IW.println("OAEP: failed - exception " + e.toString());
            return null;
        }
        return out;
    }

    public byte[] cryptPub(String mod, byte[] data) {
        BigInteger imod = new BigInteger(mod, 16);
        RSAKeyParameters pubParameters = new RSAKeyParameters(false, imod, this.ipub);
        this.engine.init(true, pubParameters);
        return this.process(data);
    }

    public byte[] uncryptPub(String mod, byte[] data) {
        BigInteger imod = new BigInteger(mod, 16);
        RSAKeyParameters pubParameters = new RSAKeyParameters(false, imod, this.ipub);
        this.engine.init(false, pubParameters);
        return this.process(data);
    }

    public byte[] cryptPriv(String mod, String priv, byte[] data) {
        BigInteger imod = new BigInteger(mod, 16);
        BigInteger ipriv = new BigInteger(priv, 16);
        RSAKeyParameters privParameters = new RSAKeyParameters(true, imod, ipriv);
        this.engine.init(true, privParameters);
        return this.process(data);
    }

    public byte[] uncryptPriv(String mod, String priv, byte[] data) {
        BigInteger imod = new BigInteger(mod, 16);
        BigInteger ipriv = new BigInteger(priv, 16);
        RSAKeyParameters privParameters = new RSAKeyParameters(true, imod, ipriv);
        this.engine.init(false, privParameters);
        return this.process(data);
    }

    public static String KpubDecode(String val, String KpubFactory) {
        byte[] data = Hex.decode(val);
        Oaep oaep = new Oaep(Kpub);
        byte[] out = oaep.uncryptPub(KpubFactory, data);
        return new String(Hex.encode(out));
    }

    public static String KpubEncode(String val, String k) {
        byte[] data = Hex.decode(val);
        Oaep oaep = new Oaep(Kpub);
        byte[] out = oaep.cryptPub(k, data);
        return new String(Hex.encode(out));
    }

    public static String KpubEncodePin(String val, String k) {
        byte[] data = val.getBytes();
        Oaep oaep = new Oaep(Kpub);
        byte[] out = oaep.cryptPub(k, data);
        return new String(Hex.encode(out));
    }
}

