/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.iwlib;

import com.inwebo.iwlib.ActionSetup;
import com.inwebo.iwlib.Data;
import com.inwebo.iwlib.Ixml;
import com.inwebo.iwlib.Otp;
import com.inwebo.iwlib.ProjectInfo;
import com.inwebo.iwlib.Util;
import com.inwebo.iwlib.Warning;
import com.inwebo.iwlib.WebServiceCall;
import com.inwebo.iwlib.Ws;
import com.inwebo.iwlib.security.Oaep;
import com.inwebo.iwlib.security.Sha256;
import java.util.Vector;

public class IW {
    static boolean TRON = false;
    static String DEFAULT_DEVICE_OS = "android";
    static long MSGSYNC_DELAY = 604800L;
    static long OTPSYNC_DELAY = 120L;
    static final String ACTION_ACTIVATE = "activate";
    static final String ACTION_PASSWORD = "password";
    static final String ACTION_SYNCHRO = "synchro";
    static final String ACTION_ACTIVATETB = "activateTB";
    static final String ACTION_EXPORT = "export";
    static final String ACTION_ADDSERVICE = "addService";
    static final String ACTION_RESET = "reset";
    static final String ACTION_UPGRADE = "upgrade";
    static final String ACTION_MESSAGES = "messages";
    static final String ACTION_MS = "ms";
    static final String ACTION_PUSHREGISTRATION = "pushRegistration";
    static final String ACTION_PUSHACTIVATECA = "pushActivateCa";
    static final String ACTION_PUSHOTP = "pushOtp";
    static final String ACTION_CHECKPUSH = "checkPush";
    static final String ACTION_SETBIOKEY = "setBiokey";
    static final String ACTION_UNSETBIOKEYS = "unsetBiokeys";
    static final String ACTION_NEWSN = "newsn";
    static final String ACTION_DISCONNECT = "disconnect";
    static final String ACTION_STATUS = "status";
    static final String ACTION_OTP = "otp";
    static final String ACTION_SEAL = "seal";
    static final String NOK_VERSION = "NOK:VERSION";
    static final String NOK_CODE = "NOK:CODE";
    static final String NOK_SN = "NOK:SN";
    static final String NOK_BLOCKED = "NOK_BLOCKED";
    static final String NOK_ACCESS = "NOK:ACCESS";
    static final String NOK_SAT = "NOK:SAT";
    static final String NOK_STATE = "NOK:STATE";
    static final String NOK_URL = "NOK:URL";
    static final String NOK_NODEVICE = "NOK:NODEVICE";
    static final String NOK_NOCA = "NOK:NOCA";
    static final String NOK_NOSRV = "NOK:NOSRV";
    static final String NOK_FORBIDDEN = "NOK:FORBIDDEN";
    static final String NOK_PINREUSED = "NOK:PINREUSED";
    static final String NOK_PINREFUSED = "NOK:PINREFUSED";
    static final String NOK_TIMEOUT = "NOK:TIMEOUT";
    static final String NOK_SYNCHROFAILED = "NOK:SYNCHROFAILED";
    static final String NOK_NOPUSH = "NOK:NOPUSH";
    static final String NOK_MAXNBTOOLS = "NOK:MAXNBTOOLS";
    static final String NOK_BIOKEY = "NOK:BIOKEY";
    static final String NOK_ERR1 = "NOK:ERR1";
    static final String NOK = "NOK";
    static final String WARN_SRVLIMITED = "WRN:SRVLIMITED";
    static final String OK_BLOCKED = "OK:BLOCKED";
    public static final long ERR_OK = 0L;
    public static final long ERR_NETWORK = 1L;
    public static final long ERR_CODE = 2L;
    public static final long ERR_SN = 3L;
    public static final long ERR_ACCESS = 4L;
    public static final long ERR_VERSION = 5L;
    public static final long ERR_BLOCKED = 7L;
    public static final long ERR_STATE = 8L;
    public static final long ERR_NODEVICE = 9L;
    public static final long ERR_NOCA = 10L;
    public static final long ERR_NOSRV = 11L;
    public static final long ERR_PINREUSED = 12L;
    public static final long ERR_SYNCHROFAILED = 13L;
    public static final long ERR_FORBIDDEN = 14L;
    public static final long ERR_PINREFUSED = 15L;
    public static final long ERR_TIMEOUT = 16L;
    public static final long ERR_URL = 17L;
    public static final long ERR_CONCURRENCY = 19L;
    public static final long ERR_MAXNBTOOLS = 25L;
    public static final long ERR_BIOKEY = 26L;
    public static final long ERR_DESYNCHRONIZED = 27L;
    public static final long ERR_OTHER = 999L;
    public static final long PINMODE_NONE = 0L;
    public static final long PINMODE_CURRENT = 1L;
    public static final long PINMODE_NEW = 2L;
    public static final long PINMODE_BIO = 8L;
    public static final long MSK_OTP = 2L;
    public static final long MSK_SEAL = 3L;
    public static String OTP;
    public static final long OPTION_A = 1L;
    public static final long OPTION_B1 = 2L;
    public static final long OPTION_B2 = 3L;
    public static final long OPTION_Bp = 4L;
    public static final int STACKRAND_LEN = 10;
    public static final int STACK_LEN = 4;
    public static final long RESULT_USED = 0L;
    public static final long RESULT_CANCEL = 1L;
    Data data = null;
    Otp otp = null;
    Vector warnings = null;
    long otpRetryT0 = 0L;
    long otpRetryT1 = 0L;
    long otpRetryService = -1L;
    long tmpMinorPrompted = 0L;
    String iwaddr = "http://127.0.0.1:8080";
    long iwtimeout = 10000L;
    String iwhostversion = "";
    long synchroJustDone = 0L;
    String SN;
    String DataAppli;
    String lang = "fr";
    String Kiw;
    ActionSetup tmpAs;
    String code;
    long pinmode;
    int serviceindex;
    String macid;
    long mask;
    long defi;
    String format;
    String pushAlias = "";
    String pushAction = "";
    String pushContext = "";
    int deltarhodt = 0;
    boolean nounsync = false;
    String Device_OS = DEFAULT_DEVICE_OS;
    static String debug;
    public String log = "log";
    public WebServiceCall ws = null;

    public static boolean IsMa() {
        return ProjectInfo.isMac() == false;
    }

    public static boolean IsMac() {
        return ProjectInfo.isMac();
    }

    private static String LIBVERSION() {
        return ProjectInfo.getVersion();
    }

    public String WEBSERVICE() {
        return ProjectInfo.getWebServicePath();
    }

    public void Init(boolean ma, String SN, String DataAppli) {
        this.Init(SN, DataAppli);
    }

    public void Init(String SN, String DataAppli) {
        if (SN.length() > 64) {
            SN = SN.substring(0, 64);
        }
        if (DataAppli.length() > 64) {
            DataAppli = DataAppli.substring(0, 64);
        }
        this.SN = SN;
        this.DataAppli = DataAppli;
        this.macid = "0";
    }

    public void MaccessSet(String macid) {
        this.macid = macid;
    }

    public void WebServiceCallSet(WebServiceCall ws) {
        this.ws = ws;
    }

    public String getSerial() {
        return this.SN + "/" + this.DataAppli + "/" + this.data.iwalea;
    }

    public String generateKma(String pin) {
        return Sha256.sha256_128(pin + ";" + this.getSerial());
    }

    public void LangSet(String l) {
        this.lang = l;
    }

    public void HostVersionSet(String version) {
        this.iwhostversion = version + "/" + IW.LIBVERSION();
    }

    public void SetDeviceOS(String deviceOS) {
        this.Device_OS = deviceOS;
    }

    public static void log(String v) {
        if (TRON) {
            System.out.println(v);
        }
    }

    public static void println(String v) {
        System.out.println(v);
    }

    public void logReset() {
        this.log = "";
    }

    public void logAdd(String v) {
        IW.log(v);
        this.log = this.log + v + "\n";
    }

    public String logGet() {
        return this.log;
    }

    public static void debugSet(String v) {
        debug = v;
    }

    public String debugGet() {
        return debug;
    }

    public String Code() {
        return this.code;
    }

    public long PinMode() {
        return this.pinmode;
    }

    public int ServiceIndex() {
        return this.serviceindex;
    }

    public String PushAlias() {
        return this.pushAlias;
    }

    public String PushAction() {
        return this.pushAction;
    }

    public String PushContext() {
        return this.pushContext;
    }

    Ixml wscallunit(String url, String action, String args) {
        String res;
        IW.log(url + "?action=" + action + args);
        if (this.ws == null) {
            this.ws = new Ws();
        }
        if ((res = this.ws.WebServiceCall(url + "?action=" + action + args, this.iwtimeout)) == null) {
            IW.log("WebServiceCall returns null");
            return null;
        }
        IW.log(res);
        Ixml x = Ixml.parse(res);
        return x;
    }

    Ixml wscall(String url, String action, String args) {
        Ixml root;
        String addr = this.iwaddr;
        if (this.data.iwserver.length() > 0) {
            addr = this.data.iwserver;
        }
        if ((root = this.wscallunit(addr + url, action, args)) == null) {
            return null;
        }
        Ixml[] lw = root.subtags("warning");
        for (int i = 0; i < lw.length; ++i) {
            Ixml w = lw[i];
            Warning ww = new Warning(w.subtagValue("code"));
            Ixml[] larg = w.subtags("arg");
            for (int j = 0; j < larg.length; ++j) {
                ww.addArg(larg[j].getVal());
            }
            this.warnings.addElement(ww);
        }
        return root;
    }

    public static String wsfilter(String x) {
        x = Util.urlencode(x);
        return x;
    }

    public static String wsfilter(long x) {
        return "" + x;
    }

    long errorfromserver(Ixml root, String err) {
        if (err.compareTo(NOK_VERSION) == 0) {
            this.data.iwmajorversion = 1L;
            this.data.dataTouch();
            return 5L;
        }
        if (err.compareTo(NOK_CODE) == 0) {
            return 2L;
        }
        if (err.compareTo(NOK_SN) == 0) {
            return 3L;
        }
        if (err.compareTo(NOK_BLOCKED) == 0 || err.compareTo(OK_BLOCKED) == 0) {
            this.data.iwblocked = 1L;
            this.data.dataTouch();
            return 7L;
        }
        if (err.compareTo(NOK_ACCESS) == 0) {
            return 4L;
        }
        if (err.compareTo(NOK_STATE) == 0) {
            return 8L;
        }
        if (err.compareTo(NOK_NODEVICE) == 0) {
            this.Deactivate();
            return 9L;
        }
        if (err.compareTo(NOK_NOCA) == 0) {
            return 10L;
        }
        if (err.compareTo(NOK_NOSRV) == 0) {
            return 11L;
        }
        if (err.compareTo(NOK_FORBIDDEN) == 0) {
            return 14L;
        }
        if (err.compareTo(NOK_PINREUSED) == 0) {
            return 12L;
        }
        if (err.compareTo(NOK_PINREFUSED) == 0) {
            return 15L;
        }
        if (err.compareTo(NOK_TIMEOUT) == 0) {
            return 16L;
        }
        if (err.compareTo(NOK_URL) == 0) {
            return 17L;
        }
        if (err.compareTo(NOK_SYNCHROFAILED) == 0) {
            return 13L;
        }
        if (err.compareTo(NOK_MAXNBTOOLS) == 0) {
            return 25L;
        }
        if (err.compareTo(NOK_NOPUSH) == 0) {
            this.data.iwblocked = 0L;
            this.data.dataTouch();
            return 999L;
        }
        if (err.compareTo(NOK_BIOKEY) == 0) {
            return 26L;
        }
        if (err.compareTo(NOK_ERR1) == 0) {
            return 27L;
        }
        if (err.startsWith(NOK)) {
            return 999L;
        }
        return 1L;
    }

    public void WsTimeoutSet(long t) {
        this.iwtimeout = t;
    }

    public void WsServerSet(String server) {
        this.iwaddr = server;
    }

    public static String VersionGet() {
        return IW.LIBVERSION();
    }

    public long DisplayTime() {
        return Otp.displayTime();
    }

    private void warningClear() {
        this.warnings = new Vector();
    }

    public long WarningNb() {
        if (this.warnings == null) {
            return 0L;
        }
        return this.warnings.size();
    }

    public String WarningCode(int i) {
        Warning ww = (Warning)this.warnings.elementAt(i);
        return ww.getCode();
    }

    public long WarningArgc(int i) {
        Warning ww = (Warning)this.warnings.elementAt(i);
        return ww.getArgc();
    }

    public String WarningArgv(int i, int j) {
        Warning ww = (Warning)this.warnings.elementAt(i);
        return ww.getArg(j);
    }

    public long StorageDataChanged() {
        return this.data.dataChanged();
    }

    public String StorageDataGet() {
        return this.data.StorageDataGet();
    }

    public long StorageDataSet(String src) {
        this.logReset();
        this.logAdd("data=");
        this.logAdd(Ixml.StringReplace(src, "&&", ", "));
        this.data = new Data(src, this);
        if (this.data.isOk()) {
            return 0L;
        }
        return 3L;
    }

    public long IsActivated() {
        if (this.data.isOk()) {
            return 1L;
        }
        return 0L;
    }

    public long IsBlocked() {
        return this.data.iwblocked;
    }

    public long HasNoPin() {
        return this.data.iwhasnopin;
    }

    public long MustUpgrade() {
        if (this.data.mustupgrade) {
            return 1L;
        }
        return 0L;
    }

    private boolean CheckForbidden(boolean activated, boolean blocked, boolean upgrade) {
        if (activated != (this.IsActivated() == 1L)) {
            return true;
        }
        if (blocked != (this.IsBlocked() == 1L)) {
            return true;
        }
        return upgrade != (this.MustUpgrade() == 1L);
    }

    public long SynchroJustDone() {
        long k = this.synchroJustDone;
        this.synchroJustDone = 0L;
        return k;
    }

    public long ServiceNb() {
        return this.data.iwsrvn;
    }

    public String ServiceId(int i) {
        if (i < 0 || (long)i >= this.data.iwsrvn) {
            return "0";
        }
        return this.data.iwsrvid[i];
    }

    public String ServiceName(int i) {
        if (i < 0 || (long)i >= this.data.iwsrvn) {
            return "";
        }
        return this.data.iwsrvname[i];
    }

    public String ServiceLogo(int i) {
        if (i < 0 || (long)i >= this.data.iwsrvn) {
            return "";
        }
        return this.data.iwsrvlogo[i];
    }

    public String ServiceUrl(int i) {
        if (i < 0 || (long)i >= this.data.iwsrvn) {
            return "";
        }
        return this.data.iwsrvurl[i];
    }

    public String ServiceAccountName(int i) {
        if (i < 0 || (long)i >= this.data.iwsrvn) {
            return "";
        }
        return this.data.iwsrvaccountname[i];
    }

    public long ServiceOnlineOtp(int i) {
        if (i < 0 || (long)i >= this.data.iwsrvn) {
            return 0L;
        }
        return this.data.iwsrvonlineotp[i];
    }

    public long ServiceDisabled(int i) {
        if (i < 0 || (long)i >= this.data.iwsrvn) {
            return 0L;
        }
        String secure = this.data.iwsrvsecure[i];
        if (secure.substring(2, 3).compareTo("X") == 0) {
            return 1L;
        }
        return 0L;
    }

    public long ServiceConnected(int i) {
        if (!IW.IsMac()) {
            return 0L;
        }
        if (i < 0 || (long)i >= this.data.iwsrvn) {
            return 0L;
        }
        long x = this.data.iwconnected + this.data.iwsrvconnected[i] - Util.time70();
        if (x < 0L) {
            return 0L;
        }
        return x;
    }

    public long MessageNb() {
        return this.data.iwmsgn;
    }

    public String MessageTitle(int i) {
        if (i < 0 || (long)i >= this.data.iwmsgn) {
            return "";
        }
        return this.data.iwmsgtitle[i];
    }

    public String MessageContent(int i) {
        if (i < 0 || (long)i >= this.data.iwmsgn) {
            return "";
        }
        return this.data.iwmsgcontent[i];
    }

    public long MessageNew(int i) {
        if (i < 0 || (long)i >= this.data.iwmsgn) {
            return 0L;
        }
        if (this.data.iwmsgack[i] == 0L) {
            return 1L;
        }
        return 0L;
    }

    public void MessageAck(int i) {
        if (i < 0 || (long)i >= this.data.iwmsgn) {
            return;
        }
        if (this.data.iwmsgack[i] == 0L) {
            this.data.iwmsgack[i] = 2L;
            this.data.dataTouch();
        }
    }

    public long MessagePropose() {
        int i = 0;
        while ((long)i < this.MessageNb()) {
            if (this.MessageNew(i) != 0L) {
                return 1L;
            }
            ++i;
        }
        return 0L;
    }

    public long MessageShouldSynchronize() {
        if (this.data == null) {
            return 0L;
        }
        long t0 = Util.time70();
        if (t0 - this.data.iwmsgtime > MSGSYNC_DELAY) {
            return 1L;
        }
        return 0L;
    }

    public long MessagePostponeSynchro() {
        this.data.iwmsgtime = Util.time70();
        this.data.dataTouch();
        return 0L;
    }

    public long MajorVersionRequired() {
        return this.data.iwmajorversion;
    }

    public String NewVersionAvailable() {
        return this.data.iwnewversion;
    }

    public String NewVersionURL() {
        return this.data.iwnewversionurl;
    }

    public long ShouldAskForMinorUpdate() {
        if (this.tmpMinorPrompted != 0L) {
            return 0L;
        }
        if (this.data == null) {
            return 0L;
        }
        if (this.data.iwnewversion == null) {
            return 0L;
        }
        if (this.data.iwnewversion.length() > 0) {
            this.tmpMinorPrompted = 1L;
            return 1L;
        }
        return 0L;
    }

    public void Deactivate() {
        this.data = new Data("", this);
        this.data.dataTouch();
    }

    public long ActivationStart(String code) {
        this.warningClear();
        if (this.IsActivated() == 1L) {
            return 14L;
        }
        this.tmpAs = new ActionSetup(this);
        long k = this.tmpAs.start(ACTION_ACTIVATE, "&code=" + code);
        this.data.iwblocked = 0L;
        IW.log("kfact=" + this.data.iwKpubFactory);
        IW.log("kiw=" + this.Kiw);
        return k;
    }

    public long ActivationFinalize(String code, String pin, String name) {
        this.warningClear();
        if (!this.tmpAs.action.equals(ACTION_ACTIVATE)) {
            return 19L;
        }
        if (this.IsActivated() == 1L) {
            return 14L;
        }
        if (!Util.checkPin(this, pin)) {
            return 15L;
        }
        this.data.iwalea = Util.rand128(null);
        String Kma = this.generateKma(pin);
        IW.log("Kiw=" + this.Kiw);
        IW.log("Kma=" + Kma);
        String pincrypt = Oaep.KpubEncodePin(pin, this.Kiw);
        String Kmacrypt = Oaep.KpubEncode(Kma, this.Kiw);
        IW.log("Kmacrypt=" + Kmacrypt);
        long k = this.tmpAs.finalize("", "&serial=" + IW.wsfilter(this.getSerial()) + "&code=" + code + "&Kma=" + IW.wsfilter(Kmacrypt) + "&pin=" + IW.wsfilter(pincrypt) + "&name=" + IW.wsfilter(name), null, pin, Kma);
        this.tmpAs = null;
        pin = null;
        Kma = null;
        System.gc();
        return k;
    }

    public long SynchronizeStart() {
        this.warningClear();
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        this.tmpAs = new ActionSetup(this);
        long k = this.tmpAs.start(ACTION_SYNCHRO, "");
        return k;
    }

    public long SynchronizeFinalize(String pin) {
        this.warningClear();
        if (!this.tmpAs.action.equals(ACTION_SYNCHRO)) {
            return 19L;
        }
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        if (this.pinmode == 2L) {
            String nKma = this.generateKma(pin);
            String pincrypt = Oaep.KpubEncodePin(pin, this.Kiw);
            String Kmacrypt = Oaep.KpubEncode(nKma, this.Kiw);
            long k = this.tmpAs.finalize("", "&Kma=" + IW.wsfilter(Kmacrypt) + "&pin=" + IW.wsfilter(pincrypt), null, pin, nKma);
            this.tmpAs = null;
            pin = null;
            nKma = null;
            System.gc();
            return k;
        }
        long k = this.tmpAs.finalize(pin, "");
        this.tmpAs = null;
        pin = null;
        System.gc();
        return k;
    }

    public long MessageSynchronizeStart() {
        this.warningClear();
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        this.tmpAs = new ActionSetup(this);
        long k = this.tmpAs.start(ACTION_MESSAGES, "");
        return k;
    }

    public long MessageSynchronizeFinalize() {
        this.warningClear();
        if (!this.tmpAs.action.equals(ACTION_MESSAGES)) {
            return 19L;
        }
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        long k = this.tmpAs.finalize("", "");
        this.tmpAs = null;
        System.gc();
        return k;
    }

    public long ServiceAddStart(String code) {
        this.warningClear();
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        this.tmpAs = new ActionSetup(this);
        long k = this.tmpAs.start(ACTION_ADDSERVICE, "&code=" + IW.wsfilter(code));
        return k;
    }

    public long ServiceAddFinalize(String code, String pin) {
        long k;
        this.warningClear();
        if (!this.tmpAs.action.equals(ACTION_ADDSERVICE)) {
            return 19L;
        }
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        if (this.pinmode == 2L) {
            if (!Util.checkPin(this, pin)) {
                return 15L;
            }
            String Kma = this.generateKma(pin);
            IW.log("Kiw=" + this.Kiw);
            IW.log("Kma=" + Kma);
            String pincrypt = Oaep.KpubEncodePin(pin, this.Kiw);
            String Kmacrypt = Oaep.KpubEncode(Kma, this.Kiw);
            k = this.tmpAs.finalize("", "&code=" + IW.wsfilter(code) + "&Kma=" + IW.wsfilter(Kmacrypt) + "&pin=" + IW.wsfilter(pincrypt), null, pin, Kma);
            Kma = null;
        } else {
            k = this.tmpAs.finalize(pin, "&code=" + IW.wsfilter(code));
        }
        this.tmpAs = null;
        pin = null;
        System.gc();
        return k;
    }

    public long ResetStart(String code) {
        this.warningClear();
        if (this.IsActivated() != 1L) {
            return 14L;
        }
        if (this.MustUpgrade() == 1L) {
            return 14L;
        }
        this.tmpAs = new ActionSetup(this);
        long k = this.tmpAs.start(ACTION_RESET, "&code=" + code);
        return k;
    }

    public long ResetFinalize(String code, String pin) {
        this.warningClear();
        if (!this.tmpAs.action.equals(ACTION_RESET)) {
            return 19L;
        }
        if (this.IsActivated() != 1L) {
            return 14L;
        }
        if (this.MustUpgrade() == 1L) {
            return 14L;
        }
        if (!Util.checkPin(this, pin)) {
            return 15L;
        }
        String Kma = this.generateKma(pin);
        IW.log("Kiw=" + this.Kiw);
        IW.log("Kma=" + Kma);
        String pincrypt = Oaep.KpubEncodePin(pin, this.Kiw);
        String Kmacrypt = Oaep.KpubEncode(Kma, this.Kiw);
        IW.log("Kmacrypt=" + Kmacrypt);
        long k = this.tmpAs.finalize("", "&code=" + code + "&Kma=" + IW.wsfilter(Kmacrypt) + "&pin=" + IW.wsfilter(pincrypt), null, pin, Kma);
        this.tmpAs = null;
        pin = null;
        Kma = null;
        System.gc();
        return k;
    }

    public long UpgradeStart() {
        this.warningClear();
        if (this.CheckForbidden(true, false, true)) {
            return 14L;
        }
        this.tmpAs = new ActionSetup(this);
        long k = this.tmpAs.start(ACTION_UPGRADE, "");
        return k;
    }

    public long UpgradeFinalize(String pin, String oldserial) {
        this.warningClear();
        if (!this.tmpAs.action.equals(ACTION_UPGRADE)) {
            return 19L;
        }
        if (this.CheckForbidden(true, false, true)) {
            return 14L;
        }
        this.data.iwalea = Util.rand128(null);
        String Kma = this.generateKma(pin);
        IW.log("Kiw=" + this.Kiw);
        IW.log("Kma=" + Kma);
        String pincrypt = Oaep.KpubEncodePin(pin, this.Kiw);
        String Kmacrypt = Oaep.KpubEncode(Kma, this.Kiw);
        IW.log("Kmacrypt=" + Kmacrypt);
        long k = this.tmpAs.finalize(pin, "&serial=" + IW.wsfilter(this.getSerial()) + "&Kma=" + IW.wsfilter(Kmacrypt) + "&pin=" + IW.wsfilter(pincrypt), oldserial, null, null);
        this.tmpAs = null;
        pin = null;
        Kma = null;
        System.gc();
        return k;
    }

    public long ActivationcodeRequestStart() {
        this.warningClear();
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        this.tmpAs = new ActionSetup(this);
        long k = this.tmpAs.start(ACTION_ACTIVATETB, "");
        return k;
    }

    public long ActivationcodeRequestFinalize(String pin) {
        this.warningClear();
        if (!this.tmpAs.action.equals(ACTION_ACTIVATETB)) {
            return 19L;
        }
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        long k = this.tmpAs.finalize(pin, "");
        this.tmpAs = null;
        pin = null;
        System.gc();
        return k;
    }

    public long ExportcodeRequestStart() {
        if (!IW.IsMa()) {
            return 14L;
        }
        this.warningClear();
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        this.tmpAs = new ActionSetup(this);
        long k = this.tmpAs.start(ACTION_EXPORT, "");
        return k;
    }

    public long ExportcodeRequestFinalize(String pin) {
        if (!IW.IsMa()) {
            return 14L;
        }
        this.warningClear();
        if (!this.tmpAs.action.equals(ACTION_EXPORT)) {
            return 19L;
        }
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        long k = this.tmpAs.finalize(pin, "");
        this.tmpAs = null;
        pin = null;
        System.gc();
        return k;
    }

    public long PwdUpdateStart() {
        this.warningClear();
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        this.tmpAs = new ActionSetup(this);
        long k = this.tmpAs.start(ACTION_PASSWORD, "");
        return k;
    }

    public long PwdUpdateFinalize(String newpin, String pin) {
        this.warningClear();
        if (!this.tmpAs.action.equals(ACTION_PASSWORD)) {
            return 19L;
        }
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        if (!Util.checkPin(this, newpin)) {
            return 15L;
        }
        if (pin.equals(newpin)) {
            return 12L;
        }
        String nKma = this.generateKma(newpin);
        String pincrypt = Oaep.KpubEncodePin(newpin, this.Kiw);
        String Kmacrypt = Oaep.KpubEncode(nKma, this.Kiw);
        long k = this.tmpAs.finalize(pin, "&Kma=" + IW.wsfilter(Kmacrypt) + "&pin=" + IW.wsfilter(pincrypt), null, newpin, nKma);
        this.tmpAs = null;
        newpin = null;
        nKma = null;
        System.gc();
        return k;
    }

    public long PushRegistrationStart() {
        if (!IW.IsMa() && !IW.IsMac()) {
            return 0L;
        }
        this.warningClear();
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        this.tmpAs = new ActionSetup(this);
        long k = this.tmpAs.start(ACTION_PUSHREGISTRATION, "");
        return k;
    }

    public long PushRegistrationFinalize(String push_id) {
        if (!IW.IsMa() && !IW.IsMac()) {
            return 0L;
        }
        this.warningClear();
        if (!this.tmpAs.action.equals(ACTION_PUSHREGISTRATION)) {
            return 19L;
        }
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        String push = "{\"type\":\"" + this.Device_OS + "\",\"id\":\"" + push_id + "\"}";
        long k = this.tmpAs.finalize("", "&push=" + IW.wsfilter(push));
        this.tmpAs = null;
        System.gc();
        return k;
    }

    public long PushShouldSynchronize() {
        if (!IW.IsMa() && !IW.IsMac()) {
            return 0L;
        }
        if (this.tmpAs == null) {
            return 0L;
        }
        return this.tmpAs.needsync() ? 1L : 0L;
    }

    public long PushActivateCaStart(String alias) {
        if (!IW.IsMa() && !IW.IsMac()) {
            return 0L;
        }
        this.warningClear();
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        this.tmpAs = new ActionSetup(this);
        long k = this.tmpAs.start(ACTION_PUSHACTIVATECA, "&alias=" + alias);
        return k;
    }

    public long PushActivateCaFinalize(String alias, String pin, boolean ok) {
        if (!IW.IsMa() && !IW.IsMac()) {
            return 0L;
        }
        this.warningClear();
        if (!this.tmpAs.action.equals(ACTION_PUSHACTIVATECA)) {
            return 19L;
        }
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        String answer = ok ? "OK" : NOK;
        long k = this.tmpAs.finalize(pin, "&alias=" + alias + "&answer=" + answer);
        this.tmpAs = null;
        pin = null;
        System.gc();
        return k;
    }

    public long PushOtpStart(String alias) {
        if (!IW.IsMa() && !IW.IsMac()) {
            return 0L;
        }
        this.warningClear();
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        this.tmpAs = new ActionSetup(this);
        long k = this.tmpAs.start(ACTION_PUSHOTP, "&alias=" + alias);
        return k;
    }

    public long PushOtpFinalize(String alias, String pin, boolean ok) {
        return this.PushOtpFinalizeExt(alias, pin, ok, 0L);
    }

    public long PushOtpFinalizeExt(String alias, String pin, boolean ok, long keyType) {
        if (!IW.IsMa() && !IW.IsMac()) {
            return 0L;
        }
        this.warningClear();
        if (!this.tmpAs.action.equals(ACTION_PUSHOTP)) {
            return 19L;
        }
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        String answer = ok ? "OK" : NOK;
        long k = this.tmpAs.finalize(pin, "&alias=" + alias + "&answer=" + answer + "&keytype=" + keyType);
        this.tmpAs = null;
        pin = null;
        System.gc();
        return k;
    }

    public long Connected() {
        if (!IW.IsMac()) {
            return 0L;
        }
        long x = this.data.iwconnected - Util.time70();
        if (x < 0L) {
            return 0L;
        }
        return x;
    }

    public long Disconnect() {
        if (!IW.IsMac()) {
            return 0L;
        }
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        this.tmpAs = new ActionSetup(this);
        long k = this.tmpAs.start(ACTION_DISCONNECT, "");
        if (k != 0L) {
            return k;
        }
        k = this.tmpAs.finalize("", "");
        this.tmpAs = null;
        System.gc();
        return k;
    }

    public long CheckStatus() {
        if (!IW.IsMac()) {
            return 0L;
        }
        if (this.IsActivated() != 1L) {
            return 14L;
        }
        if (this.MustUpgrade() == 1L) {
            return 14L;
        }
        this.tmpAs = new ActionSetup(this);
        long k = this.tmpAs.start(ACTION_STATUS, "");
        if (k != 0L) {
            return k;
        }
        k = this.tmpAs.finalize("", "");
        this.tmpAs = null;
        System.gc();
        return k;
    }

    public long CheckPush() {
        if (!IW.IsMac() && !IW.IsMa()) {
            return 0L;
        }
        if (this.IsActivated() != 1L) {
            return 14L;
        }
        if (this.MustUpgrade() == 1L) {
            return 14L;
        }
        this.tmpAs = new ActionSetup(this);
        long k = this.tmpAs.start(ACTION_CHECKPUSH, "");
        if (k != 0L) {
            return k;
        }
        k = this.tmpAs.finalize("", "");
        this.tmpAs = null;
        System.gc();
        return k;
    }

    public long OtpShouldSynchronize(int serviceid) {
        long time70 = Util.time70();
        if ((long)serviceid != this.otpRetryService) {
            return 0L;
        }
        if (this.otpRetryT1 != 0L && time70 - this.otpRetryT1 < OTPSYNC_DELAY) {
            return 1L;
        }
        return 0L;
    }

    public long OtpModeQuery(int serviceid) {
        this.warningClear();
        long time70 = Util.time70();
        if ((long)serviceid != this.otpRetryService) {
            this.otpRetryT0 = 0L;
            this.otpRetryT1 = 0L;
        }
        this.otpRetryService = serviceid;
        this.otpRetryT1 = this.otpRetryT0;
        this.otpRetryT0 = time70;
        this.otp = new Otp(this.data, serviceid, time70);
        return this.data.iwhasnopin == 0L && this.otp.getPinrequired() ? 1 : 0;
    }

    public String OtpGenerate(String pin) {
        this.warningClear();
        long time70 = Util.time70();
        String res = this.otp.generate(this, pin, time70);
        pin = null;
        System.gc();
        return res;
    }

    public long OtpResult(long result) {
        this.otp.result(this.data, result);
        this.otp = null;
        System.gc();
        return 0L;
    }

    public long OnlineOtpStart(int i) {
        if (!IW.IsMac() && !IW.IsMa()) {
            return 14L;
        }
        this.warningClear();
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        if (i < 0 || (long)i >= this.data.iwsrvn) {
            return 14L;
        }
        this.tmpAs = new ActionSetup(this);
        long k = this.tmpAs.start(ACTION_OTP, "&sid=" + this.data.iwsrvid[i]);
        return k;
    }

    public long OnlineOtpFinalize(int i, String pin) {
        return this.OnlineOtpFinalizeExt(i, pin, 0L);
    }

    public long OnlineOtpFinalizeExt(int i, String pin, long keyType) {
        if (!IW.IsMac() && !IW.IsMa()) {
            return 14L;
        }
        this.warningClear();
        if (this.tmpAs == null || !this.tmpAs.action.equals(ACTION_OTP)) {
            return 19L;
        }
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        if (i < 0 || (long)i >= this.data.iwsrvn) {
            return 14L;
        }
        String sid = this.data.iwsrvid[i];
        long k = this.tmpAs.finalize(pin, "&sid=" + sid + "&keytype=" + keyType);
        this.tmpAs = null;
        System.gc();
        if (k != 0L) {
            pin = null;
            return k;
        }
        i = this.data.getServiceIndex(sid);
        if (i < 0) {
            return 14L;
        }
        String secret = this.data.getSecret(this.data.iwsrvid[i]);
        if (this.defi > 0L) {
            String Kma = this.generateKma(pin);
            secret = Util.decodeAesFromHex128(secret, Kma);
        }
        String s4 = this.data.iwK1 + ":" + this.defi + ":" + secret;
        long is4 = Util.sha256int38(s4);
        IW.log("s4=" + s4);
        if ("8LC".equals(this.format)) {
            OTP = Otp.tobase36(is4, 8);
        } else if ("8C".equals(this.format)) {
            OTP = Otp.tobase10(is4 &= 0x7FFFFFL, 8);
        } else {
            return 999L;
        }
        this.mask = 2L;
        pin = null;
        return 0L;
    }

    public long OtpAnswersGet() {
        return this.mask;
    }

    public String OtpAnswerOtp() {
        if ((this.mask & 2L) != 0L) {
            return OTP;
        }
        return null;
    }

    public long OnlineSealStart(int i) {
        if (!IW.IsMac()) {
            return 14L;
        }
        this.warningClear();
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        if (i < 0 || (long)i >= this.data.iwsrvn) {
            return 14L;
        }
        this.tmpAs = new ActionSetup(this);
        long k = this.tmpAs.start(ACTION_SEAL, "&sid=" + this.data.iwsrvid[i]);
        return k;
    }

    public long OnlineSealFinalize(int i, String pin, String sealdata) {
        return this.OnlineSealFinalizeExt(i, pin, 0L, sealdata);
    }

    public long OnlineSealFinalizeExt(int i, String pin, long keyType, String sealdata) {
        if (!IW.IsMac()) {
            return 14L;
        }
        this.warningClear();
        if (this.tmpAs == null || !this.tmpAs.action.equals(ACTION_SEAL)) {
            return 19L;
        }
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        if (i < 0 || (long)i >= this.data.iwsrvn) {
            return 14L;
        }
        long k = this.tmpAs.finalize(pin, "&sid=" + this.data.iwsrvid[i] + "&keytype=" + keyType);
        this.tmpAs = null;
        System.gc();
        if (k != 0L) {
            pin = null;
            return k;
        }
        String secret = this.data.getSecret(this.data.iwsrvid[i]);
        String Kma = this.generateKma(pin);
        if (this.defi > 0L) {
            secret = Util.decodeAesFromHex128(secret, Kma);
        }
        String s4 = this.data.iwK1 + ":" + this.defi + ":" + secret;
        long is4 = Util.sha256int38(s4);
        IW.log("s4=" + s4);
        this.mask = 3L;
        String ksc = Util.decodeAesFromHex128(this.data.iwsrvksc[i], Kma);
        String m3 = ksc + ":" + sealdata;
        IW.log("m3=" + m3);
        long im3 = Util.sha256int64(m3);
        IW.log("im3=" + im3);
        long e = 8192L;
        long x51 = is4 * e;
        long y51 = im3 >> 13;
        long fx51 = (x51 += im3 & 0x1FFFL) & 0xAAAAAAAAAAAAAL | (y51 &= 0x7FFFFFFFFFFFFL) & 0x5555555555555L;
        long fy51 = y51 & 0xAAAAAAAAAAAAAL | x51 & 0x5555555555555L;
        OTP = Otp.tobase36(fx51, 10) + Otp.tobase36(fy51, 10);
        pin = null;
        return 0L;
    }

    public long SealAnswersGet() {
        return this.mask;
    }

    public String SealAnswerOtp() {
        if ((this.mask & 3L) != 0L) {
            return OTP;
        }
        return null;
    }

    public long SealModeQuery(int serviceid) {
        this.OtpModeQuery(serviceid);
        return 1L;
    }

    public long SealShouldSynchronize(int serviceid) {
        return this.OtpShouldSynchronize(serviceid);
    }

    public String SealGenerate(String pin, String sealdata) {
        this.warningClear();
        long time70 = Util.time70();
        String Kma = this.generateKma(pin);
        long is4 = this.otp.generateUsingFormat(this, pin, time70, "8C", Kma);
        IW.log("is4=" + is4);
        String ksc = Util.decodeAesFromHex128(this.otp.ksc, Kma);
        String m3 = ksc + ":" + sealdata;
        long im3 = Sha256.sha256int(m3);
        IW.log("im3=" + im3);
        long x20 = im3 & 0xFFFFFL;
        IW.log("x20=" + x20);
        long mask23 = 0x7FFFFFL;
        long e23 = mask23 * 8L;
        long x23 = (is4 & e23) >> 3 & mask23;
        IW.log("x23=" + x23);
        long y23 = x20 * 8L + (is4 & 7L);
        IW.log("y23=" + y23);
        long fx23 = x23 & 0x2AAAAAL | y23 & 0x555555L;
        IW.log("fx23=" + fx23);
        long fy23 = y23 & 0x2AAAAAL | x23 & 0x555555L;
        IW.log("fy23=" + fy23);
        long i46 = fx23 * 0x800000L + fy23;
        IW.log("i46=" + i46);
        String res = Otp.tobase36(i46, 9);
        pin = null;
        System.gc();
        return res;
    }

    public long SetBiokeyStart() {
        this.warningClear();
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        this.tmpAs = new ActionSetup(this);
        return this.tmpAs.start(ACTION_SETBIOKEY, "");
    }

    public long SetBiokeyFinalize(String biokey, String pin) {
        this.warningClear();
        if (!this.tmpAs.action.equals(ACTION_SETBIOKEY)) {
            return 19L;
        }
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        String cryptedBioKey = Oaep.KpubEncodePin(biokey, this.Kiw);
        long k = this.tmpAs.finalize(pin, "&biokey=" + IW.wsfilter(cryptedBioKey));
        this.tmpAs = null;
        System.gc();
        return k;
    }

    public long UnsetBiokeysStart() {
        this.warningClear();
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        this.tmpAs = new ActionSetup(this);
        return this.tmpAs.start(ACTION_UNSETBIOKEYS, "");
    }

    public long UnsetBiokeysFinalize(String pin) {
        this.warningClear();
        if (!this.tmpAs.action.equals(ACTION_UNSETBIOKEYS)) {
            return 19L;
        }
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        long k = this.tmpAs.finalize(pin, null);
        this.tmpAs = null;
        System.gc();
        return k;
    }

    public long NewSNStart() {
        this.warningClear();
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        this.tmpAs = new ActionSetup(this);
        long k = this.tmpAs.start(ACTION_NEWSN, "");
        return k;
    }

    public long NewSNFinalize(String pin) {
        this.warningClear();
        if (!this.tmpAs.action.equals(ACTION_NEWSN)) {
            return 19L;
        }
        if (this.CheckForbidden(true, false, false)) {
            return 14L;
        }
        String Kma = this.generateKma(pin);
        String Kmacrypt = Oaep.KpubEncode(Kma, this.Kiw);
        long k = this.tmpAs.finalize(pin, "&serial=" + IW.wsfilter(this.getSerial()) + "&Kma=" + IW.wsfilter(Kmacrypt), null, null, Kma);
        this.tmpAs = null;
        System.gc();
        return k;
    }

    public void SkipTime(long dt) {
        if (this.data.iwTref != 0L) {
            this.data.iwTref -= dt;
        }
        if (this.data.iwlastt1 != 0L) {
            this.data.iwlastt1 -= dt;
        }
        if (this.data.iwlastt2 != 0L) {
            this.data.iwlastt2 -= dt;
        }
        if (this.data.iwlastt3 != 0L) {
            this.data.iwlastt3 -= dt;
        }
        if (this.otpRetryT0 != 0L) {
            this.otpRetryT0 -= dt;
        }
        if (this.otpRetryT1 != 0L) {
            this.otpRetryT1 -= dt;
        }
        this.data.dataTouch();
    }

    public void NoUnsync(boolean b) {
        this.nounsync = b;
    }

    public void DeltaRhodt(int i) {
        this.deltarhodt = i;
    }

    public void debugIdSet(String id) {
        this.data.iwid = id;
    }

    public String getId() {
        return this.data.iwid;
    }

    public void dump(String pin) {
        String Kma = this.generateKma(pin);
        this.data.dump(this, Kma);
        IW.log(this.data.StorageDataGet());
        pin = null;
        Kma = null;
        System.gc();
    }

    static {
        debug = "";
    }
}

