/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.iwlib.security.crypto.util;

public abstract class Pack {
    public static int bigEndianToInt(byte[] bs, int off) {
        int n = bs[off] << 24;
        n |= (bs[++off] & 0xFF) << 16;
        n |= (bs[++off] & 0xFF) << 8;
        return n |= bs[++off] & 0xFF;
    }

    public static void intToBigEndian(int n, byte[] bs, int off) {
        bs[off] = (byte)(n >>> 24);
        bs[++off] = (byte)(n >>> 16);
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)n;
    }

    public static long bigEndianToLong(byte[] bs, int off) {
        int hi = Pack.bigEndianToInt(bs, off);
        int lo = Pack.bigEndianToInt(bs, off + 4);
        return ((long)hi & 0xFFFFFFFFL) << 32 | (long)lo & 0xFFFFFFFFL;
    }

    public static void longToBigEndian(long n, byte[] bs, int off) {
        Pack.intToBigEndian((int)(n >>> 32), bs, off);
        Pack.intToBigEndian((int)(n & 0xFFFFFFFFL), bs, off + 4);
    }

    public static int littleEndianToInt(byte[] bs, int off) {
        int n = bs[off];
        n |= (bs[++off] & 0xFF) << 8;
        n |= (bs[++off] & 0xFF) << 16;
        return n |= (bs[++off] & 0xFF) << 24;
    }

    public static void intToLittleEndian(int n, byte[] bs, int off) {
        bs[off] = (byte)n;
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)(n >>> 16);
        bs[++off] = (byte)(n >>> 24);
    }

    public static long littleEndianToLong(byte[] bs, int off) {
        int lo = Pack.littleEndianToInt(bs, off);
        int hi = Pack.littleEndianToInt(bs, off + 4);
        return ((long)hi & 0xFFFFFFFFL) << 32 | (long)lo & 0xFFFFFFFFL;
    }

    public static void longToLittleEndian(long n, byte[] bs, int off) {
        Pack.intToLittleEndian((int)(n & 0xFFFFFFFFL), bs, off);
        Pack.intToLittleEndian((int)(n >>> 32), bs, off + 4);
    }
}

